/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.protocol.server.rpc.http.impl;

import com.vmware.vapi.protocol.server.rpc.http.LifecycleListener;
import com.vmware.vapi.protocol.server.rpc.http.LifecycleManager;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicLifecycleManager
implements LifecycleManager {
    private Logger _logger = LoggerFactory.getLogger(this.getClass());
    private List<LifecycleListener> _lifecycleListeners;
    private boolean _stopped = false;

    @Override
    public synchronized void setLifecycleListeners(List<LifecycleListener> lifecycleListeners) {
        if (this._stopped) {
            throw new IllegalStateException("Can not set the lifecycle listeners of stopped lifecycle manager!");
        }
        this._lifecycleListeners = lifecycleListeners;
    }

    @Override
    public synchronized void addLifecycleListener(LifecycleListener lifecycleListener) {
        if (this._stopped) {
            throw new IllegalStateException("Can not add lifecycle listener to stopped lifecycle manager!");
        }
        if (this._lifecycleListeners == null) {
            this._lifecycleListeners = new ArrayList<LifecycleListener>();
        }
        this._lifecycleListeners.add(lifecycleListener);
    }

    @Override
    public synchronized void shutdown() {
        if (this._stopped) {
            return;
        }
        this._stopped = true;
        if (this._lifecycleListeners != null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info("Stopping lifecycle listeners.");
            }
            for (LifecycleListener shutdownable : this._lifecycleListeners) {
                shutdownable.shutdown();
            }
        }
    }

    @Override
    public synchronized void shutdownNow() {
        if (this._stopped) {
            return;
        }
        this._stopped = true;
        if (this._lifecycleListeners != null) {
            if (this._logger.isInfoEnabled()) {
                this._logger.info("Stopping lifecycle listeners immediately.");
            }
            for (LifecycleListener shutdownable : this._lifecycleListeners) {
                shutdownable.shutdownNow();
            }
        }
    }
}

