/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.internal.provider.introspection;

import com.vmware.vapi.MessageFactory;
import com.vmware.vapi.core.InterfaceDefinition;
import com.vmware.vapi.core.InterfaceIdentifier;
import com.vmware.vapi.core.MethodDefinition;
import com.vmware.vapi.core.MethodIdentifier;
import com.vmware.vapi.core.ProviderDefinition;
import com.vmware.vapi.data.AnyErrorDefinition;
import com.vmware.vapi.data.BlobDefinition;
import com.vmware.vapi.data.BooleanDefinition;
import com.vmware.vapi.data.DataDefinition;
import com.vmware.vapi.data.DataType;
import com.vmware.vapi.data.DataValue;
import com.vmware.vapi.data.DefinitionVisitor;
import com.vmware.vapi.data.DoubleDefinition;
import com.vmware.vapi.data.DynamicStructDefinition;
import com.vmware.vapi.data.ErrorDefinition;
import com.vmware.vapi.data.IntegerDefinition;
import com.vmware.vapi.data.ListDefinition;
import com.vmware.vapi.data.ListValue;
import com.vmware.vapi.data.OpaqueDefinition;
import com.vmware.vapi.data.OptionalDefinition;
import com.vmware.vapi.data.OptionalValue;
import com.vmware.vapi.data.SecretDefinition;
import com.vmware.vapi.data.StringDefinition;
import com.vmware.vapi.data.StringValue;
import com.vmware.vapi.data.StructDefinition;
import com.vmware.vapi.data.StructRefDefinition;
import com.vmware.vapi.data.StructValue;
import com.vmware.vapi.data.VoidDefinition;
import com.vmware.vapi.internal.data.ReferenceResolver;
import com.vmware.vapi.internal.provider.introspection.IntrospectionException;
import com.vmware.vapi.provider.introspection.IntrospectionConstants;
import com.vmware.vapi.std.StandardDataFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public final class IntrospectionDataFactory {
    public static final MethodIdentifier PROVIDER_GET_METHOD_ID = new MethodIdentifier(IntrospectionConstants.PROVIDER_INTROSPECTION_SERVICE_ID, "get");
    public static final MethodIdentifier SERVICE_LIST_METHOD_ID = new MethodIdentifier(IntrospectionConstants.SERVICE_INTROSPECTION_SERVICE_ID, "list");
    public static final MethodIdentifier SERVICE_GET_METHOD_ID = new MethodIdentifier(IntrospectionConstants.SERVICE_INTROSPECTION_SERVICE_ID, "get");
    public static final MethodIdentifier OPERATION_GET_METHOD_ID = new MethodIdentifier(IntrospectionConstants.OPERATION_INTROSPECTION_SERVICE_ID, "get");
    public static final MethodIdentifier OPERATION_LIST_METHOD_ID = new MethodIdentifier(IntrospectionConstants.OPERATION_INTROSPECTION_SERVICE_ID, "list");
    public static final String SERVICE_GET_METHOD_ID_PARAM = "id";
    public static final String OPERATION_GET_METHOD_SERVICE_ID_PARAM = "service_id";
    public static final String OPERATION_GET_METHOD_OPERATION_ID_PARAM = "operation_id";
    public static final String OPERATION_LIST_METHOD_SERVICE_ID_PARAM = "service_id";
    public static final String PROVIDER_INFO_NAME = "com.vmware.vapi.std.introspection.provider.info";
    public static final String SERVICE_INFO_NAME = "com.vmware.vapi.std.introspection.service.info";
    public static final String OPERATION_INFO_NAME = "com.vmware.vapi.std.introspection.operation.info";
    public static final String OPERATION_DATA_DEF_NAME = "com.vmware.vapi.std.introspection.operation.data_definition";
    public static final String DATA_DEFINITION_NAME = "com.vmware.vapi.std.introspection.operation.data_definition";
    public static final String DATA_DEF_FIELDS_MAP_ENTRY_NAME = "map-entry";
    public static final String PROVIDER_INFO_FIELD_ID = "id";
    public static final String PROVIDER_INFO_FIELD_CHECKSUM = "checksum";
    public static final String SERVICE_INFO_FIELD_OPERATIONS = "operations";
    public static final String OPERATION_INFO_FIELD_INPUTDEF = "input_definition";
    public static final String OPERATION_INFO_FIELD_OUTPUTDEF = "output_definition";
    public static final String OPERATION_INFO_FIELD_ERRORDEF = "error_definitions";
    public static final String DATA_DEFINITION_FIELD_TYPE = "type";
    public static final String DATA_DEFINITION_FIELD_ELEMENT_DEF = "element_definition";
    public static final String DATA_DEFINITION_FIELD_NAME = "name";
    public static final String DATA_DEFINITION_FIELD_FIELDS = "fields";
    public static final String MAP_KEY_FIELD = "key";
    public static final String MAP_VALUE_FIELD = "value";
    public static final StructDefinition PROVIDER_INFO_DEF;
    public static final StructDefinition SERVICE_INFO_DEF;
    public static final StructDefinition OPERATION_INFO_DEF;
    public static final StructDefinition OPERATION_DATA_DEF_DEF;
    public static final StructDefinition DATA_DEFINITION_FIELDS_MAP_DEF;
    public static final ErrorDefinition NOT_FOUND_ERROR_INFO_DEF;
    public static final String DATA_TYPE_VOID = "VOID";
    public static final String DATA_TYPE_LONG = "LONG";
    public static final String DATA_TYPE_DOUBLE = "DOUBLE";
    public static final String DATA_TYPE_BOOLEAN = "BOOLEAN";
    public static final String DATA_TYPE_BINARY = "BINARY";
    public static final String DATA_TYPE_STRING = "STRING";
    public static final String DATA_TYPE_ERROR = "ERROR";
    public static final String DATA_TYPE_OPTIONAL = "OPTIONAL";
    public static final String DATA_TYPE_LIST = "LIST";
    public static final String DATA_TYPE_STRUCTURE = "STRUCTURE";
    public static final String DATA_TYPE_OPAQUE = "OPAQUE";
    public static final String DATA_TYPE_SECRET = "SECRET";
    public static final String DATA_TYPE_STRUCTURE_REF = "STRUCTURE_REF";
    public static final String DATA_TYPE_DYNAMIC_STRUCTURE = "DYNAMIC_STRUCTURE";
    public static final String DATA_TYPE_ANY_ERROR = "ANY_ERROR";

    public static DataValue toProviderInfo(ProviderDefinition provider) {
        StructValue result = PROVIDER_INFO_DEF.newInstance();
        result.setField("id", provider.getIdentifier());
        result.setField(PROVIDER_INFO_FIELD_CHECKSUM, provider.getCheckSum());
        return result;
    }

    public static ListValue toServiceIdList(Set<InterfaceIdentifier> ifaceIds) {
        ListValue list = new ListValue();
        for (InterfaceIdentifier iId : ifaceIds) {
            list.add(new StringValue(iId.getName()));
        }
        return list;
    }

    public static DataValue toServiceInfo(InterfaceDefinition iface) {
        StructValue result = SERVICE_INFO_DEF.newInstance();
        ListValue operations = IntrospectionDataFactory.toMethodIdList(iface);
        result.setField(SERVICE_INFO_FIELD_OPERATIONS, operations);
        return result;
    }

    public static ListValue toMethodIdList(InterfaceDefinition iface) {
        ListValue operations = new ListValue();
        for (MethodIdentifier methodId : iface.getMethodIdentifiers()) {
            operations.add(new StringValue(methodId.getName()));
        }
        return operations;
    }

    public static StructValue toOperationInfo(MethodDefinition method) {
        StructValue result = OPERATION_INFO_DEF.newInstance();
        result.setField(OPERATION_INFO_FIELD_INPUTDEF, IntrospectionDataFactory.toDataDefinition(method.getInputDefinition()));
        result.setField(OPERATION_INFO_FIELD_OUTPUTDEF, IntrospectionDataFactory.toDataDefinition(method.getOutputDefinition()));
        result.setField(OPERATION_INFO_FIELD_ERRORDEF, IntrospectionDataFactory.toDataDefinitionList(method.getErrorDefinitions()));
        return result;
    }

    public static DataValue toDataDefinition(DataDefinition dataDef) {
        DefinitionVisitorImpl visitor = new DefinitionVisitorImpl();
        dataDef.accept(visitor);
        return visitor.getValue();
    }

    public static ListValue toDataDefinitionList(Set<? extends DataDefinition> dataDefs) {
        ListValue result = new ListValue();
        for (DataDefinition dataDefinition : dataDefs) {
            result.add(IntrospectionDataFactory.toDataDefinition(dataDefinition));
        }
        return result;
    }

    private static String typeToString(DataType type) {
        switch (type) {
            case VOID: {
                return DATA_TYPE_VOID;
            }
            case INTEGER: {
                return DATA_TYPE_LONG;
            }
            case DOUBLE: {
                return DATA_TYPE_DOUBLE;
            }
            case BOOLEAN: {
                return DATA_TYPE_BOOLEAN;
            }
            case BLOB: {
                return DATA_TYPE_BINARY;
            }
            case STRING: {
                return DATA_TYPE_STRING;
            }
            case ERROR: {
                return DATA_TYPE_ERROR;
            }
            case OPTIONAL: {
                return DATA_TYPE_OPTIONAL;
            }
            case LIST: {
                return DATA_TYPE_LIST;
            }
            case STRUCTURE: {
                return DATA_TYPE_STRUCTURE;
            }
            case OPAQUE: {
                return DATA_TYPE_OPAQUE;
            }
            case SECRET: {
                return DATA_TYPE_SECRET;
            }
            case STRUCTURE_REF: {
                return DATA_TYPE_STRUCTURE_REF;
            }
            case DYNAMIC_STRUCTURE: {
                return DATA_TYPE_DYNAMIC_STRUCTURE;
            }
            case ANY_ERROR: {
                return DATA_TYPE_ANY_ERROR;
            }
        }
        throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.unknown.data.type.enum", type.toString()));
    }

    public static StructValue createMethodInput() {
        return new StructValue("operation-input");
    }

    public static ProviderDefinition fromProviderInfo(DataValue value) {
        try {
            StructValue struct = IntrospectionDataFactory.toStruct(value, PROVIDER_INFO_NAME);
            String id = struct.getString("id");
            String checkSum = struct.getString(PROVIDER_INFO_FIELD_CHECKSUM);
            return new ProviderDefinition(id, checkSum);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.provider.info.error", new String[0]), (Throwable)ex);
        }
    }

    static DataDefinition fromDataDefinition(DataValue value, ReferenceResolver referenceResolver) {
        try {
            return IntrospectionDataFactory.fromDataDefinitionImpl(value, referenceResolver);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.def.error", new String[0]), (Throwable)ex);
        }
    }

    private static DataDefinition fromDataDefinitionImpl(DataValue value, ReferenceResolver referenceResolver) {
        StructValue struct = IntrospectionDataFactory.toStruct(value, "com.vmware.vapi.std.introspection.operation.data_definition");
        String typeName = struct.getString(DATA_DEFINITION_FIELD_TYPE);
        if (DATA_TYPE_VOID.equals(typeName)) {
            return VoidDefinition.getInstance();
        }
        if (DATA_TYPE_LONG.equals(typeName)) {
            return IntegerDefinition.getInstance();
        }
        if (DATA_TYPE_DOUBLE.equals(typeName)) {
            return DoubleDefinition.getInstance();
        }
        if (DATA_TYPE_BOOLEAN.equals(typeName)) {
            return BooleanDefinition.getInstance();
        }
        if (DATA_TYPE_BINARY.equals(typeName)) {
            return BlobDefinition.getInstance();
        }
        if (DATA_TYPE_STRING.equals(typeName)) {
            return StringDefinition.getInstance();
        }
        if (DATA_TYPE_OPAQUE.equals(typeName)) {
            return OpaqueDefinition.getInstance();
        }
        if (DATA_TYPE_SECRET.equals(typeName)) {
            return SecretDefinition.getInstance();
        }
        if (DATA_TYPE_DYNAMIC_STRUCTURE.equals(typeName)) {
            return DynamicStructDefinition.getInstance();
        }
        if (DATA_TYPE_ANY_ERROR.equals(typeName)) {
            return AnyErrorDefinition.getInstance();
        }
        if (DATA_TYPE_OPTIONAL.equals(typeName)) {
            return new OptionalDefinition(IntrospectionDataFactory.getElementDefinition(struct, referenceResolver));
        }
        if (DATA_TYPE_LIST.equals(typeName)) {
            return new ListDefinition(IntrospectionDataFactory.getElementDefinition(struct, referenceResolver));
        }
        boolean isError = DATA_TYPE_ERROR.equals(typeName);
        if (isError || DATA_TYPE_STRUCTURE.equals(typeName)) {
            String name = IntrospectionDataFactory.getDataDefinitionName(struct);
            Map<String, DataDefinition> fields = IntrospectionDataFactory.getDataDefinitionFields(struct, typeName, referenceResolver);
            if (isError) {
                return new ErrorDefinition(name, fields);
            }
            StructDefinition d = new StructDefinition(name, fields);
            referenceResolver.addDefinition(d);
            return d;
        }
        if (DATA_TYPE_STRUCTURE_REF.equals(typeName)) {
            StructRefDefinition r = new StructRefDefinition(IntrospectionDataFactory.getDataDefinitionName(struct));
            referenceResolver.addReference(r);
            return r;
        }
        throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.unknown.data.type.value", typeName));
    }

    private static String getDataDefinitionName(StructValue struct) {
        try {
            return struct.getOptional(DATA_DEFINITION_FIELD_NAME).getString();
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.def.name.error", new String[0]), (Throwable)ex);
        }
    }

    private static Map<String, DataDefinition> getDataDefinitionFields(StructValue struct, String typeName, ReferenceResolver referenceResolver) {
        ListValue list;
        try {
            list = struct.getOptional(DATA_DEFINITION_FIELD_FIELDS).getList();
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.def.fields.error", new String[0]), (Throwable)ex);
        }
        HashMap<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
        for (DataValue e : list) {
            IntrospectionDataFactory.addDataDefinitionFieldsEntry(fields, e, referenceResolver);
        }
        return fields;
    }

    private static void addDataDefinitionFieldsEntry(Map<String, DataDefinition> fields, DataValue value, ReferenceResolver referenceResolver) {
        try {
            StructValue mapEntryStruct = IntrospectionDataFactory.toStruct(value, DATA_DEF_FIELDS_MAP_ENTRY_NAME);
            String key = mapEntryStruct.getString(MAP_KEY_FIELD);
            StructValue fieldDefStruct = mapEntryStruct.getStruct(MAP_VALUE_FIELD);
            DataDefinition fieldDef = IntrospectionDataFactory.fromDataDefinition(fieldDefStruct, referenceResolver);
            fields.put(key, fieldDef);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.def.fields.entry.error", new String[0]), (Throwable)ex);
        }
    }

    private static DataDefinition getElementDefinition(StructValue dataDef, ReferenceResolver referenceResolver) {
        try {
            return IntrospectionDataFactory.fromDataDefinition(dataDef.getOptional(DATA_DEFINITION_FIELD_ELEMENT_DEF).getStruct(), referenceResolver);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.def.element.error", new String[0]), (Throwable)ex);
        }
    }

    public static MethodDefinition fromOperationInfo(DataValue value, MethodIdentifier methodId) {
        try {
            return IntrospectionDataFactory.fromOperationInfoImpl(value, methodId);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.info.error", new String[0]), (Throwable)ex);
        }
    }

    private static MethodDefinition fromOperationInfoImpl(DataValue value, MethodIdentifier methodId) {
        StructValue struct = IntrospectionDataFactory.toStruct(value, OPERATION_INFO_NAME);
        DataDefinition inputDef = IntrospectionDataFactory.getOperationInfoDefinitionField(struct, OPERATION_INFO_FIELD_INPUTDEF);
        DataDefinition outputDef = IntrospectionDataFactory.getOperationInfoDefinitionField(struct, OPERATION_INFO_FIELD_OUTPUTDEF);
        ListValue list = IntrospectionDataFactory.getErrorsFromOperationInfo(struct);
        HashSet<ErrorDefinition> errors = new HashSet<ErrorDefinition>();
        for (DataValue e : list) {
            errors.add(IntrospectionDataFactory.fromErrorDefinition(e));
        }
        return new MethodDefinition(methodId, inputDef, outputDef, errors);
    }

    private static DataDefinition getOperationInfoDefinitionField(StructValue opInfo, String fieldName) {
        try {
            ReferenceResolver resolver = new ReferenceResolver();
            DataDefinition def = IntrospectionDataFactory.fromDataDefinition(opInfo.getField(fieldName), resolver);
            resolver.resolveReferences();
            return def;
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.info.def.error", fieldName), (Throwable)ex);
        }
    }

    private static ErrorDefinition fromErrorDefinition(DataValue value) {
        try {
            StructValue struct = IntrospectionDataFactory.toStruct(value, "com.vmware.vapi.std.introspection.operation.data_definition");
            String typeName = struct.getString(DATA_DEFINITION_FIELD_TYPE);
            if (!DATA_TYPE_ERROR.equals(typeName)) {
                throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.info.error.def.invalid.type", typeName));
            }
            ReferenceResolver resolver = new ReferenceResolver();
            String name = IntrospectionDataFactory.getDataDefinitionName(struct);
            Map<String, DataDefinition> fields = IntrospectionDataFactory.getDataDefinitionFields(struct, typeName, resolver);
            ErrorDefinition errorDef = new ErrorDefinition(name, fields);
            resolver.resolveReferences();
            return errorDef;
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.info.error.def.error", new String[0]), (Throwable)ex);
        }
    }

    private static ListValue getErrorsFromOperationInfo(StructValue operationInfo) {
        return operationInfo.getList(OPERATION_INFO_FIELD_ERRORDEF);
    }

    private static MethodIdentifier fromOperationId(DataValue value, InterfaceIdentifier ifaceId) {
        if (!(value instanceof StringValue)) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.id.error", IntrospectionDataFactory.getValueName(value)));
        }
        StringValue methodName = (StringValue)value;
        return new MethodIdentifier(ifaceId, methodName.getValue());
    }

    public static InterfaceDefinition fromServiceInfo(DataValue value, InterfaceIdentifier ifaceId) {
        try {
            HashSet<MethodIdentifier> methods = new HashSet<MethodIdentifier>();
            StructValue struct = IntrospectionDataFactory.toStruct(value, SERVICE_INFO_NAME);
            ListValue list = struct.getList(SERVICE_INFO_FIELD_OPERATIONS);
            for (DataValue e : list) {
                methods.add(IntrospectionDataFactory.fromOperationId(e, ifaceId));
            }
            return new InterfaceDefinition(ifaceId, methods);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.service.info.error", new String[0]), (Throwable)ex);
        }
    }

    private static InterfaceIdentifier fromServiceId(DataValue value) {
        if (!(value instanceof StringValue)) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.service.id.error", IntrospectionDataFactory.getValueName(value)));
        }
        StringValue s = (StringValue)value;
        return new InterfaceIdentifier(s.getValue());
    }

    public static Set<InterfaceIdentifier> fromServiceIdList(DataValue value) {
        if (!(value instanceof ListValue)) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.service.id.list.error", IntrospectionDataFactory.getValueName(value)));
        }
        ListValue list = (ListValue)value;
        HashSet<InterfaceIdentifier> services = new HashSet<InterfaceIdentifier>();
        for (DataValue e : list) {
            services.add(IntrospectionDataFactory.fromServiceId(e));
        }
        return services;
    }

    public static void addErrorsToOperationInfo(DataValue operationInfo, Iterable<? extends DataValue> extraErrors) {
        try {
            IntrospectionDataFactory.addErrorsToOperationInfoImpl(operationInfo, extraErrors);
        }
        catch (RuntimeException ex) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.operation.info.error.def.add.error", new String[0]), (Throwable)ex);
        }
    }

    private static void addErrorsToOperationInfoImpl(DataValue operationInfo, Iterable<? extends DataValue> extraErrors) {
        StructValue struct = IntrospectionDataFactory.toStruct(operationInfo, OPERATION_INFO_NAME);
        ListValue errorList = IntrospectionDataFactory.getErrorsFromOperationInfo(struct);
        Set<String> errorNames = IntrospectionDataFactory.getErrorNames(errorList);
        for (DataValue dataValue : extraErrors) {
            StructValue errorStruct = IntrospectionDataFactory.toStruct(dataValue, "com.vmware.vapi.std.introspection.operation.data_definition");
            String name = IntrospectionDataFactory.getDataDefinitionName(errorStruct);
            if (errorNames.contains(name)) continue;
            errorList.add(dataValue);
        }
    }

    private static Set<String> getErrorNames(Iterable<DataValue> errors) {
        HashSet<String> errorNames = new HashSet<String>();
        for (DataValue e : errors) {
            StructValue struct = IntrospectionDataFactory.toStruct(e, "com.vmware.vapi.std.introspection.operation.data_definition");
            errorNames.add(IntrospectionDataFactory.getDataDefinitionName(struct));
        }
        return errorNames;
    }

    private static StructValue toStruct(DataValue value, String expectedStructName) {
        if (!(value instanceof StructValue)) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.struct.type.error", expectedStructName, IntrospectionDataFactory.getValueName(value)));
        }
        StructValue struct = (StructValue)value;
        if (!expectedStructName.equals(struct.getName())) {
            throw new IntrospectionException(MessageFactory.getMessage("vapi.introspection.data.struct.name.error", expectedStructName, struct.getName()));
        }
        return struct;
    }

    private static String getValueName(DataValue value) {
        if (value != null) {
            return value.getType().name();
        }
        return "null";
    }

    static {
        Map<String, DataDefinition> fields = new HashMap<String, DataDefinition>();
        fields.put("id", StringDefinition.getInstance());
        fields.put(PROVIDER_INFO_FIELD_CHECKSUM, StringDefinition.getInstance());
        PROVIDER_INFO_DEF = new StructDefinition(PROVIDER_INFO_NAME, fields);
        fields = Collections.singletonMap(SERVICE_INFO_FIELD_OPERATIONS, new ListDefinition(StringDefinition.getInstance()));
        SERVICE_INFO_DEF = new StructDefinition(SERVICE_INFO_NAME, fields);
        StructRefDefinition OPERATION_DATA_DEF_REF_DEF = new StructRefDefinition("com.vmware.vapi.std.introspection.operation.data_definition");
        fields = new HashMap();
        fields.put(MAP_KEY_FIELD, StringDefinition.getInstance());
        fields.put(MAP_VALUE_FIELD, OPERATION_DATA_DEF_REF_DEF);
        DATA_DEFINITION_FIELDS_MAP_DEF = new StructDefinition(DATA_DEF_FIELDS_MAP_ENTRY_NAME, fields);
        fields = new HashMap();
        fields.put(DATA_DEFINITION_FIELD_TYPE, StringDefinition.getInstance());
        fields.put(DATA_DEFINITION_FIELD_ELEMENT_DEF, new OptionalDefinition(OPERATION_DATA_DEF_REF_DEF));
        fields.put(DATA_DEFINITION_FIELD_NAME, new OptionalDefinition(StringDefinition.getInstance()));
        fields.put(DATA_DEFINITION_FIELD_FIELDS, new OptionalDefinition(new ListDefinition(DATA_DEFINITION_FIELDS_MAP_DEF)));
        OPERATION_DATA_DEF_DEF = new StructDefinition("com.vmware.vapi.std.introspection.operation.data_definition", fields);
        OPERATION_DATA_DEF_REF_DEF.setTarget(OPERATION_DATA_DEF_DEF);
        fields = new HashMap();
        fields.put(OPERATION_INFO_FIELD_INPUTDEF, OPERATION_DATA_DEF_DEF);
        fields.put(OPERATION_INFO_FIELD_OUTPUTDEF, OPERATION_DATA_DEF_DEF);
        fields.put(OPERATION_INFO_FIELD_ERRORDEF, new ListDefinition(OPERATION_DATA_DEF_DEF));
        OPERATION_INFO_DEF = new StructDefinition(OPERATION_INFO_NAME, fields);
        NOT_FOUND_ERROR_INFO_DEF = StandardDataFactory.createStandardErrorDefinition("com.vmware.vapi.std.errors.not_found");
    }

    private static class DefinitionVisitorImpl
    implements DefinitionVisitor {
        private DataValue value;

        private DefinitionVisitorImpl() {
        }

        public DataValue getValue() {
            return this.value;
        }

        @Override
        public void visit(VoidDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(BooleanDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(IntegerDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(DoubleDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(StringDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(BlobDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(OpaqueDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(SecretDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(DynamicStructDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(AnyErrorDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithType(def.getType());
        }

        @Override
        public void visit(OptionalDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithElement(def.getType(), def.getElementType());
        }

        @Override
        public void visit(ListDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithElement(def.getType(), def.getElementType());
        }

        @Override
        public void visit(StructRefDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithName(def.getType(), def.getName());
        }

        @Override
        public void visit(StructDefinition def) {
            this.value = DefinitionVisitorImpl.buildDataDefWithFields(def);
        }

        private static StructValue buildDataDefWithType(DataType type) {
            StructValue struct = new StructValue("com.vmware.vapi.std.introspection.operation.data_definition");
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_TYPE, IntrospectionDataFactory.typeToString(type));
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_NAME, new OptionalValue());
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_ELEMENT_DEF, new OptionalValue());
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_FIELDS, new OptionalValue());
            return struct;
        }

        private static StructValue buildDataDefWithName(DataType type, String name) {
            StructValue struct = DefinitionVisitorImpl.buildDataDefWithType(type);
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_NAME, new OptionalValue(name));
            return struct;
        }

        private static StructValue buildDataDefWithElement(DataType type, DataDefinition elementDef) {
            StructValue struct = DefinitionVisitorImpl.buildDataDefWithType(type);
            DataValue elementDefValue = IntrospectionDataFactory.toDataDefinition(elementDef);
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_ELEMENT_DEF, new OptionalValue(elementDefValue));
            return struct;
        }

        private static StructValue buildDataDefWithFields(StructDefinition def) {
            StructValue struct = DefinitionVisitorImpl.buildDataDefWithName(def.getType(), def.getName());
            ListValue list = new ListValue();
            for (String fieldName : def.getFieldNames()) {
                DataDefinition fieldDef = def.getField(fieldName);
                StructValue mapEntryStruct = DATA_DEFINITION_FIELDS_MAP_DEF.newInstance();
                mapEntryStruct.setField(IntrospectionDataFactory.MAP_KEY_FIELD, fieldName);
                mapEntryStruct.setField(IntrospectionDataFactory.MAP_VALUE_FIELD, IntrospectionDataFactory.toDataDefinition(fieldDef));
                list.add(mapEntryStruct);
            }
            struct.setField(IntrospectionDataFactory.DATA_DEFINITION_FIELD_FIELDS, new OptionalValue(list));
            return struct;
        }
    }
}

