/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.security;

import com.vmware.vapi.core.ExecutionContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.Validate;

public final class OAuthSecurityContext
implements ExecutionContext.SecurityContext {
    public static final String ACCESS_TOKEN = "accessToken";
    private final Map<String, Object> properties = new HashMap<String, Object>();

    public OAuthSecurityContext(char[] accessToken) {
        Validate.notNull((Object)accessToken);
        this.properties.put(ACCESS_TOKEN, accessToken);
        this.properties.put("authn_scheme_id", "com.vmware.vapi.std.security.oauth");
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    @Override
    public Map<String, Object> getAllProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    public char[] getAccessToken() {
        return (char[])this.properties.get(ACCESS_TOKEN);
    }

    public static OAuthSecurityContext newInstance(ExecutionContext.SecurityContext context) {
        Validate.notNull((Object)context);
        Object accessTokenObj = context.getProperty(ACCESS_TOKEN);
        if (accessTokenObj instanceof String) {
            return new OAuthSecurityContext(((String)accessTokenObj).toCharArray());
        }
        if (accessTokenObj instanceof char[]) {
            return new OAuthSecurityContext((char[])accessTokenObj);
        }
        return null;
    }
}

