/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vapi.std;

import org.apache.commons.lang.Validate;

public final class Progress {
    private final long min;
    private final long max;
    private final long current;

    public Progress(long min, long max, long current) {
        Validate.isTrue((min >= 0L ? 1 : 0) != 0, (String)"'min' must be non-negative");
        Validate.isTrue((max >= 0L ? 1 : 0) != 0, (String)"'max' must be non-negative");
        Validate.isTrue((current >= 0L ? 1 : 0) != 0, (String)"'current' must be non-negative");
        Validate.isTrue((min <= max ? 1 : 0) != 0, (String)"'min' must not be greater than 'max'");
        this.min = min;
        this.max = max;
        this.current = current;
    }

    public long getMin() {
        return this.min;
    }

    public long getMax() {
        return this.max;
    }

    public long getCurrent() {
        return this.current;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Progress)) {
            return false;
        }
        Progress other = (Progress)obj;
        return this.min == other.min && this.max == other.max && this.current == other.current;
    }

    public int hashCode() {
        long hash = 11L;
        hash = hash * 31L + this.min;
        hash = hash * 31L + this.max;
        hash = hash * 31L + this.current;
        return (int)hash;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append("progress: {");
        s.append("min=");
        s.append(this.min);
        s.append(", max=");
        s.append(this.max);
        s.append(", current=");
        s.append(this.current);
        s.append("}");
        return s.toString();
    }
}

