/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common;

import java.io.BufferedInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.SecureRandom;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.FileEntity;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

public class HttpClient {
    private final PoolingHttpClientConnectionManager connectionManager;
    private CloseableHttpClient client;

    public HttpClient(boolean infiniteSocketTimeout) {
        try {
            SSLContext sslContext = SSLContext.getInstance("SSL");
            sslContext.init(null, new TrustManager[]{new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return null;
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                }

                @Override
                public void checkClientTrusted(X509Certificate[] arg0, String arg1) throws CertificateException {
                }
            }}, new SecureRandom());
            Registry socketFactoryRegistry = RegistryBuilder.create().register("https", (Object)new SSLConnectionSocketFactory(sslContext)).build();
            this.connectionManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);
            this.connectionManager.setDefaultMaxPerRoute(500);
            this.connectionManager.setMaxTotal(600);
            RequestConfig config = RequestConfig.custom().setConnectTimeout(5000).setConnectionRequestTimeout(5000).setSocketTimeout(infiniteSocketTimeout ? -1 : 60000).build();
            HttpClientBuilder clientBuilder = HttpClientBuilder.create();
            clientBuilder.setConnectionManager((HttpClientConnectionManager)this.connectionManager);
            clientBuilder.setDefaultRequestConfig(config);
            this.client = clientBuilder.build();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void upload(File file, String url) {
        this.upload(file, 0L, file.length(), url, null);
    }

    public void upload(File file, long startByte, long endByte, String url, Header header) {
        HttpPut httpPut = new HttpPut(url);
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
            long fileSize = file.length();
            InputStreamEntity inputStreamRequestEntity = new InputStreamEntity((InputStream)bufferedInputStream, fileSize);
            if (startByte != 0L || endByte != file.length()) {
                inputStreamRequestEntity = new InputStreamEntity((InputStream)bufferedInputStream, endByte - startByte + 1L);
                httpPut.setHeader("Content-Range", "bytes" + Long.toString(startByte) + "-" + Long.toString(endByte) + "/" + Long.toString(fileSize));
                inputStreamRequestEntity.setChunked(true);
            }
            FileEntity fileEntity = new FileEntity(file);
            httpPut.setEntity((HttpEntity)fileEntity);
            HttpResponse httpResponse = this.executeRequest((HttpUriRequest)httpPut);
            this.validateResponse(httpResponse, 200);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("FileNotFoundException for file" + file.getName(), e);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to upload due to IOException!" + file.getName(), e);
        }
        catch (RuntimeException e) {
            httpPut.abort();
            throw e;
        }
    }

    public InputStream downloadFile(String url) {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid Url!", e);
        }
        HttpGet httpGet = new HttpGet(url);
        try {
            CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = httpResponse.getEntity();
            InputStream inputStream = null;
            if (responseEntity != null) {
                inputStream = responseEntity.getContent();
            }
            this.validateResponse((HttpResponse)httpResponse, 200);
            return inputStream;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get url contents", e);
        }
        catch (RuntimeException e) {
            httpGet.abort();
            throw e;
        }
    }

    public String getFile(String url, String filename) throws IOException {
        try {
            new URL(url);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Invalid Url!", e);
        }
        HttpGet httpGet = new HttpGet(url);
        try {
            CloseableHttpResponse httpResponse = this.client.execute((HttpUriRequest)httpGet);
            HttpEntity responseEntity = httpResponse.getEntity();
            String response = new String();
            if (responseEntity != null) {
                response = EntityUtils.toString((HttpEntity)responseEntity);
            }
            HttpClient.createFile(filename, response);
            return response;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to get url contents", e);
        }
        catch (RuntimeException e) {
            httpGet.abort();
            throw e;
        }
    }

    private static void createFile(String outfile, String content) throws IOException {
        FileOutputStream fileoutputstream = new FileOutputStream(outfile);
        DataOutputStream dataoutputstream = new DataOutputStream(fileoutputstream);
        dataoutputstream.writeBytes(content);
        dataoutputstream.flush();
        dataoutputstream.close();
    }

    private HttpResponse executeRequest(HttpUriRequest httpRequest) throws IOException, ClientProtocolException {
        int retries = 3;
        boolean shouldBreak = true;
        CloseableHttpResponse response = null;
        while (retries-- >= 0) {
            try {
                response = this.client.execute(httpRequest);
            }
            catch (SSLHandshakeException ex) {
                System.out.println(ex.getMessage());
                if (retries <= 0) {
                    shouldBreak = true;
                    throw new RuntimeException("Failed to login", ex);
                }
                shouldBreak = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to login", e);
                }
            }
            catch (EOFException ex) {
                System.out.println(ex.getMessage());
                if (retries <= 0) {
                    shouldBreak = true;
                    throw new RuntimeException("Failed to login", ex);
                }
                shouldBreak = false;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    throw new RuntimeException("Failed to login", e);
                }
            }
            catch (FileNotFoundException e) {
                throw e;
            }
            catch (IOException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            if (!shouldBreak) continue;
            break;
        }
        return response;
    }

    private void validateResponse(HttpResponse response, int statusCode) {
        int actualStatusCode = response.getStatusLine().getStatusCode();
        if (actualStatusCode == statusCode) {
            return;
        }
        String errorMessage = "Invalid return code! Expected: " + statusCode + " Actual: " + actualStatusCode + "; ";
        RuntimeException restEx = new RuntimeException(errorMessage);
        if (response.getEntity() != null && response.getEntity().getContentLength() != 0L) {
            System.out.println("Lets do something here");
        }
        throw new RuntimeException(errorMessage, restEx);
    }
}

