/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.common.authentication;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.VimPortType;
import com.vmware.vim25.VimService;
import java.util.Map;
import javax.xml.ws.BindingProvider;

public class VimAuthenticationHelper {
    private VimService vimService;
    private VimPortType vimPort;
    private ServiceContent serviceContent;
    private static ManagedObjectReference SVC_INST_REF = new ManagedObjectReference();
    public static final String VIM_PATH = "/sdk";

    public void loginByUsernameAndPassword(String server, String username, String password) {
        try {
            String vimSdkUrl = "https://" + server + VIM_PATH;
            this.vimService = new VimService();
            this.vimPort = this.vimService.getVimPort();
            Map ctxt = ((BindingProvider)this.vimPort).getRequestContext();
            ctxt.put("javax.xml.ws.service.endpoint.address", vimSdkUrl);
            ctxt.put("javax.xml.ws.session.maintain", true);
            this.serviceContent = this.vimPort.retrieveServiceContent(SVC_INST_REF);
            this.vimPort.login(this.serviceContent.getSessionManager(), username, password, null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void logout() {
        try {
            this.vimPort.logout(this.serviceContent.getSessionManager());
        }
        catch (Exception e) {
            System.out.println(" Connect Failed ");
            e.printStackTrace();
        }
    }

    public VimService getVimService() {
        return this.vimService;
    }

    public VimPortType getVimPort() {
        return this.vimPort;
    }

    public ServiceContent getServiceContent() {
        return this.serviceContent;
    }

    static {
        SVC_INST_REF.setType("ServiceInstance");
        SVC_INST_REF.setValue("ServiceInstance");
    }
}

