/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.contentlibrary.isomount;

import com.vmware.content.library.ItemTypes;
import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.VM;
import com.vmware.vcenter.VMTypes;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.common.authentication.VapiAuthenticationHelper;
import vmware.samples.contentlibrary.client.ClsApiClient;

public class IsoMount
extends SamplesAbstractBase {
    public static String ISO_TYPE = "iso";
    private String vmName;
    private String vmId;
    private String itemName;
    private String itemId;
    private ClsApiClient client;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("Name of the virtual machine").required(true).hasArg().argName("Virtual Machine").build();
        Option itemNameOption = Option.builder().longOpt("isoitemnametomount").desc("Name of an existing iso library item to mount").required(true).hasArg().argName("Iso Library Item").build();
        List<Option> optionList = Arrays.asList(vmNameOption, itemNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
        this.itemName = (String)this.parsedOptions.get("isoitemnametomount");
    }

    @Override
    protected void setup() throws Exception {
        this.client = new ClsApiClient(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig);
        this.itemId = this.getItemId();
        this.vmId = this.getVmId(this.vapiAuthHelper, this.sessionStubConfig);
        System.out.println("Mounting ISO item " + this.itemName + " (" + this.itemId + ") on VM " + this.vmName + " (" + this.vmId + ")");
    }

    private String getVmId(VapiAuthenticationHelper vapiAuthHelper, StubConfiguration sessionStubConfig) {
        VM vmService = (VM)vapiAuthHelper.getStubFactory().createStub(VM.class, (StubConfigurationBase)sessionStubConfig);
        VMTypes.FilterSpec vmFilterSpec = new VMTypes.FilterSpec.Builder().setNames(new HashSet<String>(Arrays.asList(this.vmName))).build();
        List vmList = vmService.list(vmFilterSpec);
        String vmId = ((VMTypes.Summary)vmList.get(0)).getVm();
        return vmId;
    }

    private String getItemId() {
        ItemTypes.FindSpec itemFindSpec = new ItemTypes.FindSpec();
        itemFindSpec.setName(this.itemName);
        itemFindSpec.setType(ISO_TYPE);
        List isoItemIds = this.client.itemService().find(itemFindSpec);
        assert (isoItemIds.size() == 1) : "library item on name " + this.itemName + " and type " + ISO_TYPE + " must exist";
        return (String)isoItemIds.get(0);
    }

    @Override
    protected void run() throws Exception {
        String deviceId = this.mount(this.itemId, this.vmId);
        this.unmount(this.vmId, deviceId);
    }

    @Override
    protected void cleanup() throws Exception {
    }

    private String mount(String itemId, String vmId) {
        String deviceId = this.client.isoImageService().mount(itemId, vmId);
        System.out.println("Mounted device: " + deviceId);
        return deviceId;
    }

    private void unmount(String vmId, String deviceId) {
        this.client.isoImageService().unmount(vmId, deviceId);
        System.out.println("Unmounted device: " + deviceId);
    }

    public static void main(String[] args) throws Exception {
        new IsoMount().execute(args);
    }
}

