/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.sso.soaphandlers;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.xml.bind.JAXBElement;
import javax.xml.soap.SOAPException;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.AttributedDateTime;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.ObjectFactory;
import org.oasis_open.docs.wss._2004._01.oasis_200401_wss_wssecurity_utility_1_0.TimestampType;
import org.w3c.dom.DOMException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import vmware.samples.sso.soaphandlers.SSOHeaderHandler;
import vmware.samples.sso.soaphandlers.WssHelper;

public class TimeStampHandler
extends SSOHeaderHandler {
    public static final String GMT = "GMT";

    public static DateFormat createDateFormatter() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
        dateFormat.setTimeZone(TimeZone.getTimeZone(GMT));
        return dateFormat;
    }

    private JAXBElement<TimestampType> createTimestamp() {
        ObjectFactory wssuObjFactory = new ObjectFactory();
        TimestampType timestamp = wssuObjFactory.createTimestampType();
        long now = System.currentTimeMillis();
        Date createDate = new Date(now);
        Date expirationDate = new Date(now + TimeUnit.MINUTES.toMillis(10L));
        DateFormat wssDateFormat = TimeStampHandler.createDateFormatter();
        AttributedDateTime createTime = wssuObjFactory.createAttributedDateTime();
        createTime.setValue(wssDateFormat.format(createDate));
        AttributedDateTime expirationTime = wssuObjFactory.createAttributedDateTime();
        expirationTime.setValue(wssDateFormat.format(expirationDate));
        timestamp.setCreated(createTime);
        timestamp.setExpires(expirationTime);
        return wssuObjFactory.createTimestamp(timestamp);
    }

    public boolean handleMessage(SOAPMessageContext smc) {
        if (WssHelper.isOutgoingMessage(smc)) {
            try {
                Node securityNode = WssHelper.getSecurityElement(WssHelper.getSOAPHeader(smc));
                Element timeStampNode = WssHelper.marshallJaxbElement(this.createTimestamp()).getDocumentElement();
                securityNode.appendChild(securityNode.getOwnerDocument().importNode(timeStampNode, true));
            }
            catch (DOMException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
            catch (SOAPException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        return true;
    }
}

