/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.helpers;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vcenter.Folder;
import com.vmware.vcenter.FolderTypes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import vmware.samples.vcenter.helpers.DatacenterHelper;

public class FolderHelper {
    public static String getFolder(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String folderName) {
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        Folder folderService = (Folder)stubFactory.createStub(Folder.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> vmFolders = Collections.singleton(folderName);
        FolderTypes.FilterSpec vmFolderFilterSpec = new FolderTypes.FilterSpec.Builder().setNames(vmFolders).setDatacenters(datacenters).build();
        List folderSummaries = folderService.list(vmFolderFilterSpec);
        assert (folderSummaries.size() > 0) : "Folder " + folderName + "not found in datacenter: " + datacenterName;
        return ((FolderTypes.Summary)folderSummaries.get(0)).getFolder();
    }
}

