/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.helpers;

import com.vmware.vapi.bindings.StubConfiguration;
import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vapi.bindings.StubFactory;
import com.vmware.vcenter.ResourcePool;
import com.vmware.vcenter.ResourcePoolTypes;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import vmware.samples.vcenter.helpers.DatacenterHelper;

public class ResourcePoolHelper {
    public static String getResourcePool(StubFactory stubFactory, StubConfiguration sessionStubConfig, String datacenterName, String resourcePoolName) {
        Set<String> datacenters = Collections.singleton(DatacenterHelper.getDatacenter(stubFactory, sessionStubConfig, datacenterName));
        ResourcePool resourcePoolService = (ResourcePool)stubFactory.createStub(ResourcePool.class, (StubConfigurationBase)sessionStubConfig);
        Set<String> resourcePools = Collections.singleton(resourcePoolName);
        ResourcePoolTypes.FilterSpec rpFilterSpec = new ResourcePoolTypes.FilterSpec.Builder().setNames(resourcePools).setDatacenters(datacenters).build();
        List rpSummaries = resourcePoolService.list(rpFilterSpec);
        assert (rpSummaries.size() > 0) : "Resource Pool " + resourcePoolName + "not found in datacenter: " + datacenterName;
        return ((ResourcePoolTypes.Summary)rpSummaries.get(0)).getResourcePool();
    }
}

