/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.create.defaultvm;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.VM;
import com.vmware.vcenter.VMTypes;
import com.vmware.vcenter.vm.GuestOS;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.PlacementHelper;

public class CreateDefaultVM
extends SamplesAbstractBase {
    private String vmFolderName;
    private String datastoreName;
    private String datacenterName;
    private String clusterName;
    private VM vmService;
    private GuestOS vmGuestOS = GuestOS.WINDOWS_9_64;
    private static final String DEFAULT_VM_NAME = "Sample-Default-VM";
    private String defaultVMId;

    @Override
    protected void parseArgs(String[] args) {
        Option datacenterOption = Option.builder().longOpt("datacenter").desc("The name of the datacenter on which to create the vm.").argName("DATACENTER").required(true).hasArg().build();
        Option vmFolderOption = Option.builder().longOpt("vmfolder").desc("The name of the vm folder on which to create the vm.").argName("VM FOLDER").required(true).hasArg().build();
        Option datastoreOption = Option.builder().longOpt("datastore").desc("The name of the datastore on which to create the vm").required(true).argName("DATASTORE").hasArg().build();
        Option clusterOption = Option.builder().longOpt("cluster").desc("The name of the cluster on which to create the vm.").argName("CLUSTER").required(true).hasArg().build();
        List<Option> optionList = Arrays.asList(vmFolderOption, datastoreOption, datacenterOption, clusterOption);
        super.parseArgs(optionList, args);
        this.vmFolderName = (String)this.parsedOptions.get("vmfolder");
        this.datastoreName = (String)this.parsedOptions.get("datastore");
        this.datacenterName = (String)this.parsedOptions.get("datacenter");
        this.clusterName = (String)this.parsedOptions.get("cluster");
    }

    @Override
    protected void setup() throws Exception {
        this.vmService = (VM)this.vapiAuthHelper.getStubFactory().createStub(VM.class, (StubConfigurationBase)this.sessionStubConfig);
    }

    @Override
    protected void run() throws Exception {
        VMTypes.PlacementSpec vmPlacementSpec = PlacementHelper.getPlacementSpecForCluster(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.datacenterName, this.clusterName, this.vmFolderName, this.datastoreName);
        this.createDefaultVM(vmPlacementSpec);
    }

    private void createDefaultVM(VMTypes.PlacementSpec vmPlacementSpec) {
        VMTypes.CreateSpec vmCreateSpec = new VMTypes.CreateSpec.Builder(this.vmGuestOS).setName(DEFAULT_VM_NAME).setPlacement(vmPlacementSpec).build();
        System.out.println("\n\n#### Example: Creating Default VM with spec:\n" + vmCreateSpec);
        this.defaultVMId = this.vmService.create(vmCreateSpec);
        System.out.println("\nCreated default VM : Sample-Default-VM with id: " + this.defaultVMId);
        VMTypes.Info vmInfo = this.vmService.get(this.defaultVMId);
        System.out.println("\nDefault VM Info:\n" + vmInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Deleting the Default VM");
        if (this.defaultVMId != null) {
            this.vmService.delete(this.defaultVMId);
        }
    }

    public static void main(String[] args) throws Exception {
        new CreateDefaultVM().execute(args);
    }
}

