/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.adapter;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.hardware.adapter.Sata;
import com.vmware.vcenter.vm.hardware.adapter.SataTypes;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class SataAdapterConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private List<String> createdSataAdapters = new ArrayList<String>();
    private Sata sataService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().required(true).hasArg().argName("VM NAME").longOpt("vmname").desc("The name of the vm for which to configure virtual SATA adapters.").build();
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.sataService = (Sata)this.vapiAuthHelper.getStubFactory().createStub(Sata.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for SATA adapter configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        SataTypes.Info sataInfo;
        System.out.println("\n\n#### Example: List of all SATA adapters on the VM.");
        List sataSummaries = this.sataService.list(this.vmId);
        System.out.println(sataSummaries);
        System.out.println("\n\n#### Display information about each adapter.");
        for (SataTypes.Summary sataSummary : sataSummaries) {
            sataInfo = this.sataService.get(this.vmId, sataSummary.getAdapter());
            System.out.println(sataInfo);
        }
        System.out.println("\n\n#### Example: Create SATA adapter with defaults.");
        SataTypes.CreateSpec sataCreateSpec = new SataTypes.CreateSpec();
        String sataId = this.sataService.create(this.vmId, sataCreateSpec);
        System.out.println(sataCreateSpec);
        sataInfo = this.sataService.get(this.vmId, sataId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("SATA Adapter ID=" + sataId);
        System.out.println(sataInfo);
        this.createdSataAdapters.add(sataId);
        System.out.println("\n\n#### Create SATA adapter with a specific bus");
        sataCreateSpec = new SataTypes.CreateSpec.Builder().setBus(Long.valueOf(2L)).build();
        System.out.println(sataCreateSpec);
        sataId = this.sataService.create(this.vmId, sataCreateSpec);
        sataInfo = this.sataService.get(this.vmId, sataId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("SATA Adapter ID=" + sataId);
        System.out.println(sataInfo);
        this.createdSataAdapters.add(sataId);
        System.out.println("\n\n#### List of all SATA adapters on the VM.");
        sataSummaries = this.sataService.list(this.vmId);
        System.out.println(sataSummaries);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Deleting all the adapters that were created.");
        for (String sataId : this.createdSataAdapters) {
            this.sataService.delete(this.vmId, sataId);
        }
        List sataSummaries = this.sataService.list(this.vmId);
        System.out.println("\n\n#### List of all SATA adapters on the VM.");
        System.out.println(sataSummaries);
    }

    public static void main(String[] args) throws Exception {
        new SataAdapterConfiguration().execute(args);
    }
}

