/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.boot;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.hardware.Boot;
import com.vmware.vcenter.vm.hardware.BootTypes;
import java.util.ArrayList;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class BootConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private BootTypes.Info originalBootInfo;
    private Boot bootService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().required(true).hasArg().argName("VM NAME").longOpt("vmname").desc("The name of the vm for which to configure boot options").build();
        ArrayList<Option> optionList = new ArrayList<Option>();
        optionList.add(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.bootService = (Boot)this.vapiAuthHelper.getStubFactory().createStub(Boot.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for boot configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        System.out.println("\n\n#### Print the original Boot Info");
        BootTypes.Info bootInfo = this.bootService.get(this.vmId);
        System.out.println(bootInfo);
        this.originalBootInfo = bootInfo;
        System.out.println("\n\n#### Example: Update firmware to EFI for boot configuration.");
        BootTypes.UpdateSpec bootUpdateSpec = new BootTypes.UpdateSpec.Builder().setType(BootTypes.Type.EFI).build();
        this.bootService.update(this.vmId, bootUpdateSpec);
        System.out.println(bootUpdateSpec);
        bootInfo = this.bootService.get(this.vmId);
        System.out.println(bootInfo);
        System.out.println("\n\n#### Example: Update boot firmware to tell it to enter setup mode on next boot.");
        bootUpdateSpec = new BootTypes.UpdateSpec.Builder().setEnterSetupMode(Boolean.valueOf(true)).build();
        this.bootService.update(this.vmId, bootUpdateSpec);
        System.out.println(bootUpdateSpec);
        bootInfo = this.bootService.get(this.vmId);
        System.out.println(bootInfo);
        System.out.println("\n\n#### Example: Update firmware to introduce a delay in boot process and automatically reboot after a failure to boot, retry delay = 30000 ms.");
        bootUpdateSpec = new BootTypes.UpdateSpec.Builder().setDelay(Long.valueOf(10000L)).setRetry(Boolean.valueOf(true)).setRetryDelay(Long.valueOf(30000L)).build();
        this.bootService.update(this.vmId, bootUpdateSpec);
        bootInfo = this.bootService.get(this.vmId);
        System.out.println(bootInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Revert the boot configuration.");
        BootTypes.UpdateSpec bootUpdateSpec = new BootTypes.UpdateSpec.Builder().setDelay(Long.valueOf(this.originalBootInfo.getDelay())).setEfiLegacyBoot(this.originalBootInfo.getEfiLegacyBoot()).setEnterSetupMode(Boolean.valueOf(this.originalBootInfo.getEnterSetupMode())).setNetworkProtocol(this.originalBootInfo.getNetworkProtocol()).setRetry(Boolean.valueOf(this.originalBootInfo.getRetry())).setRetryDelay(Long.valueOf(this.originalBootInfo.getRetryDelay())).setType(this.originalBootInfo.getType()).build();
        this.bootService.update(this.vmId, bootUpdateSpec);
        System.out.println(bootUpdateSpec);
        BootTypes.Info bootInfo = this.bootService.get(this.vmId);
        System.out.println(bootInfo);
    }

    public static void main(String[] args) throws Exception {
        new BootConfiguration().execute(args);
    }
}

