/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.bootdevices;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.VM;
import com.vmware.vcenter.VMTypes;
import com.vmware.vcenter.vm.hardware.Disk;
import com.vmware.vcenter.vm.hardware.DiskTypes;
import com.vmware.vcenter.vm.hardware.Ethernet;
import com.vmware.vcenter.vm.hardware.EthernetTypes;
import com.vmware.vcenter.vm.hardware.boot.Device;
import com.vmware.vcenter.vm.hardware.boot.DeviceTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class BootDeviceConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private List<DeviceTypes.Entry> originalBootDeviceEntries;
    private Device bootDeviceService;
    private Disk diskService;
    private Ethernet ethernetService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The name of the vm for which to configure boot device order.").required(true).hasArg().argName("VM NAME").build();
        List<Option> optionList = Collections.singletonList(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.diskService = (Disk)this.vapiAuthHelper.getStubFactory().createStub(Disk.class, (StubConfigurationBase)this.sessionStubConfig);
        this.ethernetService = (Ethernet)this.vapiAuthHelper.getStubFactory().createStub(Ethernet.class, (StubConfigurationBase)this.sessionStubConfig);
        this.bootDeviceService = (Device)this.vapiAuthHelper.getStubFactory().createStub(Device.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("\nUsing VM: " + this.vmName + " (vmId=" + this.vmId + " ) for boot device configuration sample.");
        System.out.println("\nValidate whether the vm has required minimum number of devices");
        VM vmService = (VM)this.vapiAuthHelper.getStubFactory().createStub(VM.class, (StubConfigurationBase)this.sessionStubConfig);
        VMTypes.Info vmInfo = vmService.get(this.vmId);
        if (vmInfo.getCdroms().size() < 1 || vmInfo.getFloppies().size() < 1 || vmInfo.getDisks().size() < 3 || vmInfo.getNics().size() < 1) {
            throw new Exception("\nSelected VM does not have the required minimum number of devices: i.e. 1 Ethernet adapter, 1 CD-ROM, 1 Floppy drive, 3 disks");
        }
    }

    @Override
    protected void run() throws Exception {
        System.out.println("\n\n#### Example: Print the current boot device configuration");
        List bootDeviceEntries = this.bootDeviceService.get(this.vmId);
        System.out.println(bootDeviceEntries);
        this.originalBootDeviceEntries = bootDeviceEntries;
        System.out.println("\n\n#### Example: Set boot order to be Floppy, Disk1, Disk2, Disk3, Ethernet NIC, CD-ROM");
        List diskSummaries = this.diskService.list(this.vmId);
        System.out.println("\nList of disks attached to vm: \n" + diskSummaries);
        ArrayList<String> diskIds = new ArrayList<String>();
        for (DiskTypes.Summary diskSummary : diskSummaries) {
            diskIds.add(diskSummary.getDisk());
        }
        List ethernetSummaries = this.ethernetService.list(this.vmId);
        System.out.println("\nList of ethernet nics attached to vm: \n" + ethernetSummaries);
        ArrayList<String> ethernetIds = new ArrayList<String>();
        for (EthernetTypes.Summary ethernetSummary : ethernetSummaries) {
            ethernetIds.add(ethernetSummary.getNic());
        }
        List<DeviceTypes.Entry> devices = Arrays.asList(new DeviceTypes.Entry.Builder(DeviceTypes.Type.FLOPPY).build(), new DeviceTypes.Entry.Builder(DeviceTypes.Type.DISK).setDisks(diskIds).build(), new DeviceTypes.Entry.Builder(DeviceTypes.Type.ETHERNET).setNic((String)ethernetIds.get(0)).build(), new DeviceTypes.Entry.Builder(DeviceTypes.Type.CDROM).build());
        this.bootDeviceService.set(this.vmId, devices);
        bootDeviceEntries = this.bootDeviceService.get(this.vmId);
        System.out.println("\nNew boot device configuration");
        System.out.println(bootDeviceEntries);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Revert boot device configuration");
        this.bootDeviceService.set(this.vmId, this.originalBootDeviceEntries);
        List bootDeviceEntries = this.bootDeviceService.get(this.vmId);
        System.out.println(bootDeviceEntries);
    }

    public static void main(String[] args) throws Exception {
        new BootDeviceConfiguration().execute(args);
    }
}

