/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.cdrom;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.Power;
import com.vmware.vcenter.vm.PowerTypes;
import com.vmware.vcenter.vm.hardware.Cdrom;
import com.vmware.vcenter.vm.hardware.CdromTypes;
import com.vmware.vcenter.vm.hardware.IdeAddressSpec;
import com.vmware.vcenter.vm.hardware.SataAddressSpec;
import com.vmware.vcenter.vm.hardware.adapter.Sata;
import com.vmware.vcenter.vm.hardware.adapter.SataTypes;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class CdromConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    private String sataId;
    private String isoDatastorePath;
    private Cdrom cdromService;
    private Power powerService;
    private Sata sataService;
    private List<String> createdCdroms = new ArrayList<String>();

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The name of the vm for which to configure virtual CD-ROM device.").required(true).hasArg().argName("VM NAME").build();
        Option isoDatastorePathOption = Option.builder().longOpt("isodatastorepath").desc("The path to the iso file on the datastore").required(true).hasArg().argName("ISO DATASTORE PATH").build();
        List<Option> optionList = Arrays.asList(vmNameOption, isoDatastorePathOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
        this.isoDatastorePath = (String)this.parsedOptions.get("isodatastorepath");
    }

    @Override
    protected void setup() throws Exception {
        this.cdromService = (Cdrom)this.vapiAuthHelper.getStubFactory().createStub(Cdrom.class, (StubConfigurationBase)this.sessionStubConfig);
        this.powerService = (Power)this.vapiAuthHelper.getStubFactory().createStub(Power.class, (StubConfigurationBase)this.sessionStubConfig);
        this.sataService = (Sata)this.vapiAuthHelper.getStubFactory().createStub(Sata.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for the CD-ROM configuration sample.");
        System.out.println("\n\n#### Setup: Create SATA controller");
        SataTypes.CreateSpec sataCreateSpec = new SataTypes.CreateSpec();
        this.sataId = this.sataService.create(this.vmId, sataCreateSpec);
        System.out.println(sataCreateSpec);
    }

    @Override
    protected void run() throws Exception {
        System.out.println("\n\n### Example: List all CD-ROMs");
        this.listAllCdroms();
        System.out.println("\n\n### Example: Create CD-ROM with ISO_FILE backing");
        this.createCdrom(CdromTypes.BackingType.ISO_FILE);
        System.out.println("\n\n### Example: Create CD-ROM with CLIENT_DEVICE backing");
        this.createCdrom(CdromTypes.BackingType.CLIENT_DEVICE);
        System.out.println("\n\n### Example: Create SATA CD-ROM with CLIENT_DEVICE backing");
        this.createCdromForAdapterType(CdromTypes.HostBusAdapterType.SATA, CdromTypes.BackingType.CLIENT_DEVICE);
        System.out.println("\n\n### Example: Create SATA CD-ROM on specific bus with CLIENT_DEVICE backing");
        this.createSataCdromAtSpecificLocation(CdromTypes.BackingType.CLIENT_DEVICE, 0L, null);
        System.out.println("\n\n### Example: Create SATA CD-ROM on specific bus and unit number with CLIENT_DEVICE backing");
        this.createSataCdromAtSpecificLocation(CdromTypes.BackingType.CLIENT_DEVICE, 0L, 10L);
        System.out.println("\n\n### Example: Create IDE CD-ROM with CLIENT_DEVICE backing");
        this.createCdromForAdapterType(CdromTypes.HostBusAdapterType.IDE, CdromTypes.BackingType.CLIENT_DEVICE);
        System.out.println("\n\n### Example: Create IDE CD-ROM as a slave device with HOST_DEVICE backing");
        this.createIdeCdromAsSpecificDevice(CdromTypes.BackingType.HOST_DEVICE, false);
        String lastCdromId = this.createdCdroms.get(this.createdCdroms.size() - 1);
        System.out.println("\n\n#### Example: Update backing from CLIENT_DEVICE to ISO_FILE for the last created CD-ROM");
        CdromTypes.UpdateSpec cdromUpdateSpec = new CdromTypes.UpdateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(CdromTypes.BackingType.ISO_FILE).setIsoFile(this.isoDatastorePath).build()).build();
        this.cdromService.update(this.vmId, lastCdromId, cdromUpdateSpec);
        System.out.println(cdromUpdateSpec);
        CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### Example: Update startConnected and allowGuestControl to false for the last created cdrom");
        cdromUpdateSpec = new CdromTypes.UpdateSpec.Builder().setAllowGuestControl(Boolean.valueOf(false)).setStartConnected(Boolean.valueOf(false)).build();
        this.cdromService.update(this.vmId, lastCdromId, cdromUpdateSpec);
        cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### Power on VM to run connect/disconnect sample");
        this.powerService.start(this.vmId);
        cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### Example: Connect CD-ROM after powering on VM");
        this.cdromService.connect(this.vmId, lastCdromId);
        cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### Example: Disconnect cdrom while VM is powered on");
        this.cdromService.disconnect(this.vmId, lastCdromId);
        cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### Power off the VM after the connect/disconnect");
        this.powerService.stop(this.vmId);
        cdromInfo = this.cdromService.get(this.vmId, lastCdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + lastCdromId);
        System.out.println(cdromInfo);
        System.out.println("\n\n#### List all the CD-ROMs");
        this.listAllCdroms();
    }

    private void listAllCdroms() {
        List cdromSummaries = this.cdromService.list(this.vmId);
        System.out.println(cdromSummaries);
        for (CdromTypes.Summary cdromSummary : cdromSummaries) {
            String cdromId = cdromSummary.getCdrom();
            CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
            System.out.println(cdromInfo);
        }
    }

    private void createCdrom(CdromTypes.BackingType backingType) {
        CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(backingType).build()).build();
        if (backingType.equals((Object)CdromTypes.BackingType.ISO_FILE)) {
            cdromCreateSpec.getBacking().setIsoFile(this.isoDatastorePath);
        }
        String cdromId = this.cdromService.create(this.vmId, cdromCreateSpec);
        System.out.println(cdromCreateSpec);
        this.createdCdroms.add(cdromId);
        CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + cdromId);
        System.out.println(cdromInfo);
    }

    private void createCdromForAdapterType(CdromTypes.HostBusAdapterType hostBusAdapterType, CdromTypes.BackingType backingType) {
        CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(backingType).build()).setType(hostBusAdapterType).build();
        String cdromId = this.cdromService.create(this.vmId, cdromCreateSpec);
        System.out.println(cdromCreateSpec);
        this.createdCdroms.add(cdromId);
        CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + cdromId);
        System.out.println(cdromInfo);
    }

    private void createIdeCdromAsSpecificDevice(CdromTypes.BackingType backingType, boolean isMaster) {
        String cdromId = null;
        CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(backingType).build()).setType(CdromTypes.HostBusAdapterType.IDE).setIde(new IdeAddressSpec.Builder().setMaster(Boolean.valueOf(isMaster)).build()).build();
        cdromId = this.cdromService.create(this.vmId, cdromCreateSpec);
        System.out.println(cdromCreateSpec);
        CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println("CD-ROM ID=" + cdromId);
        System.out.println(cdromInfo);
        this.createdCdroms.add(cdromId);
    }

    private void createSataCdromAtSpecificLocation(CdromTypes.BackingType backingType, Long bus, Long unit) {
        String cdromId = null;
        if (unit == null) {
            CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(backingType).build()).setType(CdromTypes.HostBusAdapterType.SATA).setSata(new SataAddressSpec.Builder(0L).build()).build();
            cdromId = this.cdromService.create(this.vmId, cdromCreateSpec);
            System.out.println(cdromCreateSpec);
            CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
            System.out.println("VM ID=" + this.vmId);
            System.out.println("CD-ROM ID=" + cdromId);
            System.out.println(cdromInfo);
        } else {
            CdromTypes.CreateSpec cdromCreateSpec = new CdromTypes.CreateSpec.Builder().setBacking(new CdromTypes.BackingSpec.Builder(backingType).build()).setType(CdromTypes.HostBusAdapterType.SATA).setSata(new SataAddressSpec.Builder(0L).setUnit(Long.valueOf(10L)).build()).build();
            cdromId = this.cdromService.create(this.vmId, cdromCreateSpec);
            System.out.println(cdromCreateSpec);
            CdromTypes.Info cdromInfo = this.cdromService.get(this.vmId, cdromId);
            System.out.println("VM ID=" + this.vmId);
            System.out.println("CD-ROM ID=" + cdromId);
            System.out.println(cdromInfo);
        }
        this.createdCdroms.add(cdromId);
    }

    @Override
    protected void cleanup() throws Exception {
        PowerTypes.Info powerInfo = this.powerService.get(this.vmId);
        if (powerInfo.getState().equals((Object)PowerTypes.State.POWERED_ON)) {
            System.out.println("\n\n#### Cleanup: Powering off the VM");
            this.powerService.stop(this.vmId);
        }
        if (this.sataId != null) {
            System.out.println("\n\n#### Cleanup: Deleting the SATA controller");
            this.sataService.delete(this.vmId, this.sataId);
        }
        System.out.println("\n\n#### Cleanup: Deleting all the created CD-ROMs");
        for (String cdromId : this.createdCdroms) {
            this.cdromService.delete(this.vmId, cdromId);
        }
        this.listAllCdroms();
    }

    public static void main(String[] args) throws Exception {
        new CdromConfiguration().execute(args);
    }
}

