/*
 * Decompiled with CFR 0.152.
 */
package vmware.samples.vcenter.vm.hardware.cpu;

import com.vmware.vapi.bindings.StubConfigurationBase;
import com.vmware.vcenter.vm.hardware.Cpu;
import com.vmware.vcenter.vm.hardware.CpuTypes;
import java.util.Collections;
import java.util.List;
import org.apache.commons.cli.Option;
import vmware.samples.common.SamplesAbstractBase;
import vmware.samples.vcenter.helpers.VmHelper;

public class CpuConfiguration
extends SamplesAbstractBase {
    private String vmName;
    private String vmId;
    CpuTypes.Info originalCpuInfo;
    private Cpu cpuService;

    @Override
    protected void parseArgs(String[] args) {
        Option vmNameOption = Option.builder().longOpt("vmname").desc("The name of the vm for which to configure cpu settings.").required(true).hasArg().argName("VM NAME").build();
        List<Option> optionList = Collections.singletonList(vmNameOption);
        super.parseArgs(optionList, args);
        this.vmName = (String)this.parsedOptions.get("vmname");
    }

    @Override
    protected void setup() throws Exception {
        this.cpuService = (Cpu)this.vapiAuthHelper.getStubFactory().createStub(Cpu.class, (StubConfigurationBase)this.sessionStubConfig);
        System.out.println("\n\n#### Setup: Get the virtual machine id");
        this.vmId = VmHelper.getVM(this.vapiAuthHelper.getStubFactory(), this.sessionStubConfig, this.vmName);
        System.out.println("Using VM: " + this.vmName + " (vmId=" + this.vmId + " ) for CPU configuration sample.");
    }

    @Override
    protected void run() throws Exception {
        System.out.println("\n\n#### Example: Print original cpu info");
        CpuTypes.Info cpuInfo = this.cpuService.get(this.vmId);
        System.out.println(cpuInfo);
        this.originalCpuInfo = cpuInfo;
        System.out.println("\n\n#### Example: Update count field of CPU configuration");
        CpuTypes.UpdateSpec cpuUpdateSpec = new CpuTypes.UpdateSpec.Builder().setCount(Long.valueOf(2L)).build();
        this.cpuService.update(this.vmId, cpuUpdateSpec);
        System.out.println(cpuUpdateSpec);
        cpuInfo = this.cpuService.get(this.vmId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println(cpuInfo);
        System.out.println("\n\n#### Example: Update cpu fields, number of cores per socket=2, enable hot add");
        cpuUpdateSpec = new CpuTypes.UpdateSpec.Builder().setCoresPerSocket(Long.valueOf(2L)).setHotAddEnabled(Boolean.valueOf(true)).build();
        this.cpuService.update(this.vmId, cpuUpdateSpec);
        System.out.println(cpuUpdateSpec);
        cpuInfo = this.cpuService.get(this.vmId);
        System.out.println("VM ID=" + this.vmId);
        System.out.println(cpuInfo);
    }

    @Override
    protected void cleanup() throws Exception {
        System.out.println("\n\n#### Cleanup: Revert cpu configuration");
        CpuTypes.UpdateSpec cpuUpdateSpec = new CpuTypes.UpdateSpec.Builder().setCoresPerSocket(Long.valueOf(this.originalCpuInfo.getCoresPerSocket())).setCount(Long.valueOf(this.originalCpuInfo.getCount())).setHotAddEnabled(Boolean.valueOf(this.originalCpuInfo.getHotAddEnabled())).setHotRemoveEnabled(Boolean.valueOf(this.originalCpuInfo.getHotRemoveEnabled())).build();
        this.cpuService.update(this.vmId, cpuUpdateSpec);
        System.out.println(cpuUpdateSpec);
        CpuTypes.Info cpuInfo = this.cpuService.get(this.vmId);
        System.out.println("VMID=" + this.vmId);
        System.out.println(cpuInfo);
    }

    public static void main(String[] args) throws Exception {
        new CpuConfiguration().execute(args);
    }
}

