########################################################################
# Copyright (C) 2013 - 2014 VMware, Inc.
########################################################################

## @file TypeStub.pm
# Auto generated vAPI skeleton file.
# DO NOT MODIFY!
#
#

#use Com::Vmware::Vapi::Std::Errors;

package Com::Vmware::Content::TypeStub;

## @class Com::Vmware::Content::Type
#
#The {@name Type} {@term service} exposes the {@link ItemModel} types
#that this Content Library Service supports.
#<p>
#A library item has an optional type which can be specified with the
#{@link ItemModel#type} {@term field}. For items with a type that is supported
#by a plugin, the Content Library Service may understand the files which are
#part of the library item and can produce metadata for the item.
#<p>
#In other cases, uploads may require a process in which one upload implies
#subsequent uploads. For example, an Open Virtualization Format (OVF) package
#is composed of an OVF descriptor file and the associated virtual disk files.
#Uploading an OVF descriptor can enable the Content Library Service to
#understand that the complete OVF package requires additional disk files, and
#it can set up the transfers for the disks automatically by adding the file
#entries for the disks when the OVF descriptor is uploaded.
#<p>
#When a type is not supported by a plugin, or the type is not specified, the
#Content Library Service can handle a library item in a default way, without
#adding metadata to the item or guiding the upload process.
#

#
# Core Perl modules
#
use strict;
use warnings;
use Carp;

#
# Vapi Perl modules
#
use Com::Vmware::Vapi::Bindings::Type::BlobType;
use Com::Vmware::Vapi::Bindings::Type::BooleanType;
use Com::Vmware::Vapi::Bindings::Type::DateTimeType;
use Com::Vmware::Vapi::Bindings::Type::DoubleType;
use Com::Vmware::Vapi::Bindings::Type::EnumType;
use Com::Vmware::Vapi::Bindings::Type::ErrorType;
use Com::Vmware::Vapi::Bindings::Type::ListType;
use Com::Vmware::Vapi::Bindings::Type::LongType;
use Com::Vmware::Vapi::Bindings::Type::MapType;
use Com::Vmware::Vapi::Bindings::Type::OpaqueType;
use Com::Vmware::Vapi::Bindings::Type::OptionalType;
use Com::Vmware::Vapi::Bindings::Type::ReferenceType;
use Com::Vmware::Vapi::Bindings::Type::SecretType;
use Com::Vmware::Vapi::Bindings::Type::SetType;
use Com::Vmware::Vapi::Bindings::Type::StringType;
use Com::Vmware::Vapi::Bindings::Type::StructType;
use Com::Vmware::Vapi::Bindings::Type::DynamicStructType;
use Com::Vmware::Vapi::Bindings::Type::URIType;
use Com::Vmware::Vapi::Bindings::Type::VoidType;
use Com::Vmware::Vapi::Data::UnionValidator;

#
# Base class
#
use base qw(Com::Vmware::Vapi::Bindings::ApiInterfaceStub);

## @method new
# Constructor to initialize the object
#
# @param ApiProvider - ApiProvider for vAPI stubs
#
# @return
# Blessed object
#
sub new
{
   my ($class, %args) = @_;
   my $api_provider = $args {api_provider};
   $class = ref($class) || $class;
      #
   # properties for list operation
   #
   my $list_input_type = new Com::Vmware::Vapi::Bindings::Type::StructType(
      'name' => 'operation-input',
      'fields' => {}
   );
   my $list_error_dict = {};

   my $list_input_validator_list = [
   ];
   my $list_output_validator_list = [];

   #
   # All the methods (operations) info in a hash
   #
   my $operations = {
      'list' => {
                'input_type'=> $list_input_type,
                'output_type'=> new Com::Vmware::Vapi::Bindings::Type::ListType(new Com::Vmware::Vapi::Bindings::Type::ReferenceType('module_ctx' => 'Com::Vmware::Content', 'type_name' => 'Type::Info')),
                'errors'=> $list_error_dict,
                'input_validator_list'=> $list_input_validator_list,
                'output_validator_list'=> $list_output_validator_list,
            },
   };

   my $self = $class->SUPER::new ('api_provider' => $api_provider,
                                  'iface_name' => 'com.vmware.content.type',
                                  'operations' => $operations
                                 );
   bless $self, $class;
   return $self;
}

1;
