"""
Protocol connector factory
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'

import logging
from vmware.vapi.lib.load import dynamic_import

logger = logging.getLogger(__name__)


class ProtocolConnectorFactory(object):
    """ Protocol connector factory """

    def __init__(self):
        """ Protocol connector factory init """
        self.connectors = {
            # msg protocol name : constructor
            'json': 'vmware.vapi.protocol.client.msg.json_connector.get_protocol_connector',
        }

    def get_connector(self, protocol, *args, **kwargs):
        """
        Create protocol connector

        :type    protocol: :class:`str`
        :param   protocol: protocol name
        :type    args: :class:`tuple`
        :param   args: position parameters to protocol connector constructor
        :type    kwargs: :class:`dict`
        :param   kwargs: key parameters to protocol connector constructor
        :rtype:  :class:`vmware.vapi.protocol.client.connector.Connector`
        :return: Connector object
        """
        constructor = self.connectors.get(protocol)
        if constructor is not None:
            constructor = dynamic_import(constructor)
            if constructor:
                return constructor(*args, **kwargs)
