#!/usr/bin/env python

"""
rpc provider interface
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'


# Interface class, don't need to warn about unused argument / method
# could be function, or abstracted class not referenced
# pylint: disable=W0613,R0201,R0921
class RpcProvider(object):
    """ Rpc provider interface """

    def __init__(self):
        """ Rpc provider interface init """
        pass

    def connect(self):
        """
        connect

        :rtype: :class:`vmware.vapi.protocol.client.rpc.provider.RpcProvider`
        :return: a rpc provider
        """
        raise NotImplementedError

    def disconnect(self):
        """ disconnect """
        raise NotImplementedError

    def do_request(self, request_ctx, request):
        """
        Do rpc request

        :type  request_ctx: :class:`dict` of :class:`str`, :class:`str`
        :param request_ctx: Request context dictionary. The valid key/value pairs are:
                content-type, {as in http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html 14.17}
        :type  request: :class:`str`
        :param request: The request body

        :rtype: :class:`tuple` of (:class:`dict` of :class:`str`, :class:`str`),
            :class:`str`
        :return: Tuple of (response_ctx, response_body) where
            response_ctx: Response context dictionary. The valid key/value pairs are:
                    content-type, {as in http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html 14.17}
            response: The response body
        """
        raise NotImplementedError

    # NYI: Async request
    #def do_request_async(self, request, on_response_cb, on_err_cb=None, timeout=-1):
    #   raise NotImplementedError
