"""
AuthenticationChain processor lib
"""

__author__ = 'VMware, Inc.'
__copyright__ = 'Copyright (c) 2015 VMware, Inc.  All rights reserved.'

import logging

from vmware.vapi.lib.constants import PROCESSORS
from vmware.vapi.lib.load import import_multiple_classes

processors = import_multiple_classes(__name__, PROCESSORS)
logger = logging.getLogger(__name__)


def next_security_context(ctx):
    """
    Returns the next security context based on the current context

    :type  ctx: :class:`vmware.vapi.core.SecurityContext`
    :param ctx: Current security context
    :rtype: :class:`vmware.vapi.core.SecurityContext`
    :return: Next security context
    """
    for processor in processors:
        ctx = processor.next_context(ctx)
    return ctx
