/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.cim.helpers;

import com.vmware.cim.helpers.GetHost;
import com.vmware.connection.Connection;
import com.vmware.vim25.HostServiceTicket;
import java.net.URL;
import java.security.Principal;
import java.util.Locale;
import javax.cim.CIMObjectPath;
import javax.security.auth.Subject;
import javax.wbem.WBEMException;
import javax.wbem.client.UserPrincipal;
import javax.wbem.client.WBEMClient;
import javax.wbem.client.WBEMClientFactory;

public class GetCim {
    public static final String WBEMCLIENT_FORMAT = "CIM-XML";
    public static final String INTEROP_NAMESPACE = "root/interop";
    public static final String IMPL_NAMESPACE = "root/cimv2";
    public static final String[] NAMESPACES = new String[]{"root/interop", "root/cimv2"};
    public final Connection connection;
    public final String cimHostname;
    public final GetHost getHost;

    public GetCim(Connection connection, String string, GetHost getHost) {
        if (string == null || "".equals(string)) {
            throw new GetCimRuntimeFault("The CIM host name was not properly set!");
        }
        this.connection = connection;
        this.cimHostname = string;
        this.getHost = getHost;
    }

    public GetCim(Connection connection, String string) {
        this(connection, string, new GetHost(connection));
    }

    public GetCim(Connection connection) {
        this(connection, connection.getHost(), new GetHost(connection));
    }

    public HostServiceTicket ticket() {
        this.getHost.vCenterCheck();
        HostServiceTicket hostServiceTicket = null;
        try {
            hostServiceTicket = this.connection.connect().getVimPort().acquireCimServicesTicket(this.getHost.byName(this.cimHostname));
        }
        catch (Throwable throwable) {
            throw new GetCimRuntimeFault(throwable);
        }
        return hostServiceTicket;
    }

    public CIMObjectPath baseObjectPath(URL uRL, String string) {
        return new CIMObjectPath(uRL.toString() + string);
    }

    public CIMObjectPath objectPath(URL uRL, String string, String string2) {
        return new CIMObjectPath(uRL.toString() + string + ":" + string2);
    }

    public WBEMClient client(HostServiceTicket hostServiceTicket, CIMObjectPath cIMObjectPath) {
        return this.client(hostServiceTicket.getSessionId(), hostServiceTicket.getSessionId(), cIMObjectPath);
    }

    public WBEMClient client(String string, String string2, CIMObjectPath cIMObjectPath) {
        return this.client(this.subject(string, string2), cIMObjectPath);
    }

    public WBEMClient client(Subject subject, CIMObjectPath cIMObjectPath) {
        WBEMClient wBEMClient = WBEMClientFactory.getClient((String)WBEMCLIENT_FORMAT);
        try {
            wBEMClient.initialize(cIMObjectPath, subject, new Locale[]{new Locale("en")});
        }
        catch (WBEMException wBEMException) {
            throw new GetCimWBEMException(wBEMException);
        }
        return wBEMClient;
    }

    public WBEMClient client(String string, String string2, URL uRL, String string3, String string4) {
        return this.client(this.subject(string, string2), uRL, string3, string4);
    }

    public WBEMClient client(HostServiceTicket hostServiceTicket, URL uRL, String string, String string2) {
        return this.client(this.subject(hostServiceTicket), uRL, string, string2);
    }

    public WBEMClient client(Subject subject, URL uRL, String string, String string2) {
        return this.client(subject, this.objectPath(uRL, string, string2));
    }

    public Subject subject(HostServiceTicket hostServiceTicket) {
        return this.subject(hostServiceTicket.getSessionId(), hostServiceTicket.getSessionId());
    }

    public Subject subject(String string, String string2) {
        Subject subject = new Subject();
        subject.getPrincipals().add((Principal)new UserPrincipal(string));
        subject.getPrivateCredentials().add((Object)new PasswordCredential(string2));
        return subject;
    }

    public WBEMClient client(HostServiceTicket hostServiceTicket, URL uRL, String string) {
        return this.client(hostServiceTicket, this.baseObjectPath(uRL, string));
    }

    public WBEMClient client(String string, String string2, URL uRL, String string3) {
        return this.client(this.subject(string, string2), this.baseObjectPath(uRL, string3));
    }

    public static class PasswordCredential
    extends javax.wbem.client.PasswordCredential {
        private final String longPassword;

        public PasswordCredential(String string) {
            super("fake password");
            this.longPassword = string;
        }

        public char[] getUserPassword() {
            return this.longPassword.toCharArray();
        }
    }

    private class GetCimRuntimeFault
    extends GetCimException {
        private static final long serialVersionUID = 1L;

        public GetCimRuntimeFault(Throwable throwable) {
            super(throwable);
        }

        public GetCimRuntimeFault(String string) {
            super(string);
        }
    }

    private class GetCimWBEMException
    extends GetCimException {
        private static final long serialVersionUID = 1L;

        public GetCimWBEMException(WBEMException wBEMException) {
            super((Throwable)wBEMException);
        }
    }

    private class GetCimException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public GetCimException(Throwable throwable) {
            super(throwable);
        }

        public GetCimException(String string) {
            super(string);
        }
    }
}

