/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.connection.helpers;

import com.vmware.connection.Connection;
import com.vmware.connection.helpers.BaseHelper;
import com.vmware.connection.helpers.builders.ObjectSpecBuilder;
import com.vmware.connection.helpers.builders.PropertyFilterSpecBuilder;
import com.vmware.connection.helpers.builders.PropertySpecBuilder;
import com.vmware.connection.helpers.builders.SelectionSpecBuilder;
import com.vmware.connection.helpers.builders.TraversalSpecBuilder;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.ServiceContent;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VimPortType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GetMOREF
extends BaseHelper {
    VimPortType vimPort;
    ServiceContent serviceContent;

    public GetMOREF(Connection connection) {
        super(connection);
    }

    private void init() {
        try {
            this.vimPort = this.connection.connect().getVimPort();
            this.serviceContent = this.connection.connect().getServiceContent();
        }
        catch (Throwable throwable) {
            throw new BaseHelper.HelperException(throwable);
        }
    }

    public RetrieveResult containerViewByType(ManagedObjectReference managedObjectReference, String string, RetrieveOptions retrieveOptions) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        return this.containerViewByType(managedObjectReference, string, retrieveOptions, "name");
    }

    public RetrieveResult containerViewByType(ManagedObjectReference managedObjectReference, String string, RetrieveOptions retrieveOptions, String ... stringArray) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.init();
        PropertyFilterSpec[] propertyFilterSpecArray = this.propertyFilterSpecs(managedObjectReference, string, stringArray);
        return this.containerViewByType(managedObjectReference, string, stringArray, retrieveOptions, propertyFilterSpecArray);
    }

    public PropertyFilterSpec[] propertyFilterSpecs(ManagedObjectReference managedObjectReference, String string, String ... stringArray) throws RuntimeFaultFaultMsg {
        this.init();
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getViewManager();
        ManagedObjectReference managedObjectReference3 = this.vimPort.createContainerView(managedObjectReference2, managedObjectReference, Arrays.asList(string), true);
        return new PropertyFilterSpec[]{new PropertyFilterSpecBuilder().propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(string).pathSet(stringArray)).objectSet(new ObjectSpecBuilder().obj(managedObjectReference3).skip(Boolean.TRUE).selectSet(new SelectionSpec[]{new TraversalSpecBuilder().name("view").path("view").skip(false).type("ContainerView")}))};
    }

    public RetrieveResult containerViewByType(ManagedObjectReference managedObjectReference, String string, String[] stringArray, RetrieveOptions retrieveOptions, PropertyFilterSpec ... propertyFilterSpecArray) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.init();
        return this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), Arrays.asList(propertyFilterSpecArray), retrieveOptions);
    }

    public Map<String, ManagedObjectReference> inFolderByType(ManagedObjectReference managedObjectReference, String string, RetrieveOptions retrieveOptions) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        PropertyFilterSpec[] propertyFilterSpecArray = this.propertyFilterSpecs(managedObjectReference, string, "name");
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getPropertyCollector();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(managedObjectReference2, Arrays.asList(propertyFilterSpecArray), retrieveOptions);
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        while (retrieveResult != null && !retrieveResult.getObjects().isEmpty()) {
            this.resultsToTgtMorefMap(retrieveResult, hashMap);
            String string2 = retrieveResult.getToken();
            retrieveResult = string2 != null ? this.vimPort.continueRetrievePropertiesEx(managedObjectReference2, string2) : null;
        }
        return hashMap;
    }

    private void resultsToTgtMorefMap(RetrieveResult retrieveResult, Map<String, ManagedObjectReference> map) {
        List list;
        List list2 = list = retrieveResult != null ? retrieveResult.getObjects() : null;
        if (list != null) {
            for (ObjectContent objectContent : list) {
                ManagedObjectReference managedObjectReference = objectContent.getObj();
                String string = null;
                List list3 = objectContent.getPropSet();
                if (list3 != null) {
                    for (DynamicProperty dynamicProperty : list3) {
                        string = (String)dynamicProperty.getVal();
                    }
                }
                map.put(string, managedObjectReference);
            }
        }
    }

    public Map<ManagedObjectReference, Map<String, Object>> inContainerByType(ManagedObjectReference managedObjectReference, String string, String[] stringArray, RetrieveOptions retrieveOptions) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        List list = this.containerViewByType(managedObjectReference, string, retrieveOptions, stringArray).getObjects();
        HashMap<ManagedObjectReference, Map<String, Object>> hashMap = new HashMap<ManagedObjectReference, Map<String, Object>>();
        if (list != null) {
            for (ObjectContent objectContent : list) {
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                List list2 = objectContent.getPropSet();
                if (list2 != null) {
                    for (DynamicProperty dynamicProperty : list2) {
                        hashMap2.put(dynamicProperty.getName(), dynamicProperty.getVal());
                    }
                }
                hashMap.put(objectContent.getObj(), hashMap2);
            }
        }
        return hashMap;
    }

    public Map<String, ManagedObjectReference> inContainerByType(ManagedObjectReference managedObjectReference, String string, RetrieveOptions retrieveOptions) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        this.init();
        RetrieveResult retrieveResult = this.containerViewByType(managedObjectReference, string, retrieveOptions);
        return this.toMap(retrieveResult);
    }

    public Map<String, ManagedObjectReference> toMap(RetrieveResult retrieveResult) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        HashMap<String, ManagedObjectReference> hashMap = new HashMap<String, ManagedObjectReference>();
        String string = null;
        string = GetMOREF.populate(retrieveResult, hashMap);
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.serviceContent.getPropertyCollector(), string);
            string = GetMOREF.populate(retrieveResult, hashMap);
        }
        return hashMap;
    }

    public static String populate(RetrieveResult retrieveResult, Map<String, ManagedObjectReference> map) {
        String string = null;
        if (retrieveResult != null) {
            string = retrieveResult.getToken();
            for (ObjectContent objectContent : retrieveResult.getObjects()) {
                ManagedObjectReference managedObjectReference = objectContent.getObj();
                String string2 = null;
                List list = objectContent.getPropSet();
                if (list != null) {
                    for (DynamicProperty dynamicProperty : list) {
                        string2 = (String)dynamicProperty.getVal();
                    }
                }
                map.put(string2, managedObjectReference);
            }
        }
        return string;
    }

    public static String populate(RetrieveResult retrieveResult, List<ObjectContent> list) {
        String string = null;
        if (retrieveResult != null) {
            string = retrieveResult.getToken();
            list.addAll(retrieveResult.getObjects());
        }
        return string;
    }

    public ManagedObjectReference vmByVMname(String string, ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        this.init();
        ManagedObjectReference managedObjectReference2 = null;
        ManagedObjectReference managedObjectReference3 = this.serviceContent.getRootFolder();
        TraversalSpec traversalSpec = this.getVMTraversalSpec();
        PropertySpecBuilder propertySpecBuilder = new PropertySpecBuilder().all(Boolean.FALSE).pathSet("name").type("VirtualMachine");
        ObjectSpecBuilder objectSpecBuilder = new ObjectSpecBuilder().obj(managedObjectReference3).skip(Boolean.TRUE).selectSet(new SelectionSpec[]{traversalSpec});
        PropertyFilterSpecBuilder propertyFilterSpecBuilder = new PropertyFilterSpecBuilder().propSet(propertySpecBuilder).objectSet(objectSpecBuilder);
        ArrayList<PropertyFilterSpecBuilder> arrayList = new ArrayList<PropertyFilterSpecBuilder>(1);
        arrayList.add(propertyFilterSpecBuilder);
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        List list = this.vimPort.retrievePropertiesEx(managedObjectReference, arrayList, retrieveOptions).getObjects();
        if (list != null) {
            for (ObjectContent objectContent : list) {
                ManagedObjectReference managedObjectReference4 = objectContent.getObj();
                String string2 = null;
                List list2 = objectContent.getPropSet();
                if (list2 != null) {
                    for (DynamicProperty dynamicProperty : list2) {
                        string2 = (String)dynamicProperty.getVal();
                    }
                }
                if (string2 == null || !string2.equals(string)) continue;
                managedObjectReference2 = managedObjectReference4;
                break;
            }
        }
        return managedObjectReference2;
    }

    public TraversalSpec getVMTraversalSpec() {
        TraversalSpecBuilder traversalSpecBuilder = new TraversalSpecBuilder().name("vAppToVM").type("VirtualApp").path("vm");
        TraversalSpecBuilder traversalSpecBuilder2 = new TraversalSpecBuilder().name("vAppToVApp").type("VirtualApp").path("resourcePool").selectSet(new SelectionSpecBuilder().name("vAppToVApp"), new SelectionSpecBuilder().name("vAppToVM"));
        SelectionSpecBuilder selectionSpecBuilder = new SelectionSpecBuilder().name("VisitFolders");
        TraversalSpecBuilder traversalSpecBuilder3 = new TraversalSpecBuilder().name("DataCenterToVMFolder").type("Datacenter").path("vmFolder").skip(false).selectSet(selectionSpecBuilder);
        return new TraversalSpecBuilder().name("VisitFolders").type("Folder").path("childEntity").skip(false).selectSet(new SelectionSpec[]{selectionSpecBuilder, traversalSpecBuilder3, traversalSpecBuilder, traversalSpecBuilder2});
    }

    public Map<String, Object> entityProps(ManagedObjectReference managedObjectReference, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        this.init();
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        PropertyFilterSpec[] propertyFilterSpecArray = new PropertyFilterSpec[]{new PropertyFilterSpecBuilder().propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(managedObjectReference.getType()).pathSet(stringArray)).objectSet(new ObjectSpecBuilder().obj(managedObjectReference))};
        List list = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), Arrays.asList(propertyFilterSpecArray), new RetrieveOptions()).getObjects();
        if (list != null) {
            for (ObjectContent objectContent : list) {
                List list2 = objectContent.getPropSet();
                for (DynamicProperty dynamicProperty : list2) {
                    hashMap.put(dynamicProperty.getName(), dynamicProperty.getVal());
                }
            }
        }
        return hashMap;
    }

    public Map<ManagedObjectReference, Map<String, Object>> entityProps(List<ManagedObjectReference> list, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ManagedObjectReference managedObjectReference2;
        this.init();
        HashMap<ManagedObjectReference, Map<String, Object>> hashMap = new HashMap<ManagedObjectReference, Map<String, Object>>();
        PropertyFilterSpecBuilder propertyFilterSpecBuilder = new PropertyFilterSpecBuilder();
        HashMap<String, String> hashMap2 = new HashMap<String, String>();
        for (ManagedObjectReference managedObjectReference2 : list) {
            if (!hashMap2.containsKey(managedObjectReference2.getType())) {
                propertyFilterSpecBuilder.propSet(new PropertySpecBuilder().all(Boolean.FALSE).type(managedObjectReference2.getType()).pathSet(stringArray));
                hashMap2.put(managedObjectReference2.getType(), "");
            }
            propertyFilterSpecBuilder.objectSet(new ObjectSpecBuilder().obj(managedObjectReference2));
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(propertyFilterSpecBuilder);
        managedObjectReference2 = this.vimPort.retrievePropertiesEx(this.serviceContent.getPropertyCollector(), (List)arrayList, new RetrieveOptions());
        ArrayList<ObjectContent> arrayList2 = new ArrayList<ObjectContent>();
        String string = GetMOREF.populate((RetrieveResult)managedObjectReference2, arrayList2);
        while (string != null && !string.isEmpty()) {
            managedObjectReference2 = this.vimPort.continueRetrievePropertiesEx(this.serviceContent.getPropertyCollector(), string);
            string = GetMOREF.populate((RetrieveResult)managedObjectReference2, arrayList2);
        }
        for (ObjectContent objectContent : arrayList2) {
            List list2 = objectContent.getPropSet();
            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
            if (list2 != null) {
                for (DynamicProperty dynamicProperty : list2) {
                    hashMap3.put(dynamicProperty.getName(), dynamicProperty.getVal());
                }
            }
            hashMap.put(objectContent.getObj(), hashMap3);
        }
        return hashMap;
    }

    public Map<String, ManagedObjectReference> inContainerByType(ManagedObjectReference managedObjectReference, String string) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        return this.inContainerByType(managedObjectReference, string, new RetrieveOptions());
    }

    public Map<String, ManagedObjectReference> inFolderByType(ManagedObjectReference managedObjectReference, String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        return this.inFolderByType(managedObjectReference, string, new RetrieveOptions());
    }

    public Map<ManagedObjectReference, Map<String, Object>> inContainerByType(ManagedObjectReference managedObjectReference, String string, String[] stringArray) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        return this.inContainerByType(managedObjectReference, string, stringArray, new RetrieveOptions());
    }
}

