/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.events;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfEvent;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.Event;
import com.vmware.vim25.EventFilterSpec;
import com.vmware.vim25.EventFilterSpecByEntity;
import com.vmware.vim25.EventFilterSpecRecursionOption;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Sample(name="vmevent-history-collector-monitor", description="This sample is responsible for creating EventHistoryCollector filtered for a single VM and monitoring Events using the latestPage attribute of the EventHistoryCollector.")
public class VMEventHistoryCollectorMonitor
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference rootFolderRef;
    private ManagedObjectReference eventHistoryCollectorRef;
    private ManagedObjectReference eventManagerRef;
    private ManagedObjectReference vmRef;
    private String vmName;

    @Option(name="vmname", description="virtual machine name")
    public void setVmName(String string) {
        this.vmName = string;
    }

    void createEventHistoryCollector() throws RuntimeFaultFaultMsg, InvalidStateFaultMsg {
        EventFilterSpecByEntity eventFilterSpecByEntity = new EventFilterSpecByEntity();
        eventFilterSpecByEntity.setEntity(this.vmRef);
        eventFilterSpecByEntity.setRecursion(EventFilterSpecRecursionOption.SELF);
        EventFilterSpec eventFilterSpec = new EventFilterSpec();
        eventFilterSpec.setEntity(eventFilterSpecByEntity);
        this.eventHistoryCollectorRef = this.vimPort.createCollectorForEvents(this.eventManagerRef, eventFilterSpec);
    }

    PropertyFilterSpec createEventFilterSpec() {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(new Boolean(false));
        propertySpec.getPathSet().add("latestPage");
        propertySpec.setType(this.eventHistoryCollectorRef.getType());
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.eventHistoryCollectorRef);
        objectSpec.setSkip(new Boolean(false));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        return propertyFilterSpec;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    void monitorEvents(PropertyFilterSpec propertyFilterSpec) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            ObjectContent objectContent = list.get(0);
            ArrayOfEvent arrayOfEvent = (ArrayOfEvent)((DynamicProperty)objectContent.getPropSet().get(0)).getVal();
            ArrayList arrayList2 = (ArrayList)arrayOfEvent.getEvent();
            System.out.println("Events In the latestPage are: ");
            for (int i = 0; i < arrayList2.size(); ++i) {
                Event event = (Event)arrayList2.get(i);
                System.out.println("Event: " + event.getClass().getName());
            }
        } else {
            System.out.println("No Events retrieved!");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidStateFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.rootFolderRef = this.serviceContent.getRootFolder();
        this.eventManagerRef = this.serviceContent.getEventManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        this.vmRef = map.get(this.vmName);
        if (this.vmRef == null) {
            System.out.println("Virtual Machine " + this.vmName + " Not Found.");
            return;
        }
        this.createEventHistoryCollector();
        PropertyFilterSpec propertyFilterSpec = this.createEventFilterSpec();
        this.monitorEvents(propertyFilterSpec);
    }
}

