/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.general;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.Map;
import javax.xml.ws.soap.SOAPFaultException;

@Sample(name="search-index", description="This sample demonstrates the SearchIndex API")
public class SearchIndex
extends ConnectedVimServiceBase {
    public final String SVC_INST_NAME = "ServiceInstance";
    public final String PROP_ME_NAME = "name";
    private String dcName;
    private String vmDnsName;
    private String vmPath;
    private String hostDnsName;
    private String vmIP;

    @Option(name="dcname", description="name of the datacenter")
    public void setDcName(String string) {
        this.dcName = string;
    }

    @Option(name="vmdnsname", required=false, description="Dns of a virtual machine")
    public void setVmDnsName(String string) {
        this.vmDnsName = string;
    }

    @Option(name="hostdnsname", required=false, description="Dns of the ESX host")
    public void setHostDnsName(String string) {
        this.hostDnsName = string;
    }

    @Option(name="vmpath", required=false, description="Inventory path of a virtual machine")
    public void setVmPath(String string) {
        this.vmPath = string;
    }

    @Option(name="vmip", required=false, description="IP Address of a virtual machine")
    public void setVmIP(String string) {
        this.vmIP = string;
    }

    public void printSoapFaultException(SOAPFaultException sOAPFaultException) {
        System.out.println("SOAP Fault -");
        if (sOAPFaultException.getFault().hasDetail()) {
            System.out.println(sOAPFaultException.getFault().getDetail().getFirstChild().getLocalName());
        }
        if (sOAPFaultException.getFault().getFaultString() != null) {
            System.out.println("\n Message: " + sOAPFaultException.getFault().getFaultString());
        }
    }

    @Action
    public void action() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        ManagedObjectReference managedObjectReference;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "Datacenter");
        ManagedObjectReference managedObjectReference2 = map.get(this.dcName);
        if (managedObjectReference2 == null) {
            System.out.println("Datacenter not Found with name: " + this.dcName);
            return;
        }
        System.out.println("Found Datacenter with name: " + this.dcName + ", MoRef: " + managedObjectReference2.getValue());
        if (this.vmDnsName != null) {
            managedObjectReference = null;
            try {
                managedObjectReference = this.vimPort.findByDnsName(this.serviceContent.getSearchIndex(), managedObjectReference2, this.vmDnsName, true);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Error Encountered: " + (Object)((Object)runtimeFaultFaultMsg));
            }
            if (managedObjectReference != null) {
                System.out.println("Found VirtualMachine with DNS name: " + this.vmDnsName + ", MoRef: " + managedObjectReference.getValue());
            } else {
                System.out.println("VirtualMachine not Found with DNS name: " + this.vmDnsName);
            }
        }
        if (this.vmPath != null) {
            managedObjectReference = null;
            try {
                managedObjectReference = this.vimPort.findByInventoryPath(this.serviceContent.getSearchIndex(), this.vmPath);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Error Encountered: " + (Object)((Object)runtimeFaultFaultMsg));
            }
            if (managedObjectReference != null) {
                System.out.println("Found VirtualMachine with Path: " + this.vmPath + ", MoRef: " + managedObjectReference.getValue());
            } else {
                System.out.println("VirtualMachine not found with vmPath address: " + this.vmPath);
            }
        }
        if (this.vmIP != null) {
            managedObjectReference = null;
            try {
                managedObjectReference = this.vimPort.findByIp(this.serviceContent.getSearchIndex(), managedObjectReference2, this.vmIP, true);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Error Encountered: " + (Object)((Object)runtimeFaultFaultMsg));
            }
            if (managedObjectReference != null) {
                System.out.println("Found VirtualMachine with IP address " + this.vmIP + ", MoRef: " + managedObjectReference.getValue());
            } else {
                System.out.println("VirtualMachine not found with IP address: " + this.vmIP);
            }
        }
        if (this.hostDnsName != null) {
            managedObjectReference = null;
            try {
                managedObjectReference = this.vimPort.findByDnsName(this.serviceContent.getSearchIndex(), null, this.hostDnsName, false);
            }
            catch (SOAPFaultException sOAPFaultException) {
                this.printSoapFaultException(sOAPFaultException);
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Error Encountered: " + (Object)((Object)runtimeFaultFaultMsg));
            }
            if (managedObjectReference != null) {
                System.out.println("Found HostSystem with DNS name " + this.hostDnsName + ", MoRef: " + managedObjectReference.getValue());
            } else {
                System.out.println("HostSystem not Found with DNS name:" + this.hostDnsName);
            }
        }
    }
}

