/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.HostServiceTicket;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Sample(name="acquire-session-info", description="This sample will acquire a session with VC or ESX and print a cim service ticket and related session information to a file")
public class AcquireSessionInfo
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private String hostname;
    private String info;
    private String filename;

    @Option(name="host", description="name of host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="info", required=false, description="Type of info required [cimticket]")
    public void setInfo(String string) {
        this.info = string;
    }

    @Option(name="file", required=false, description="Full path of the file to save data to")
    public void setFilename(String string) {
        this.filename = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    String stringToWrite(HostServiceTicket hostServiceTicket) {
        String string = "undefined";
        String string2 = "undefined";
        String string3 = "undefined";
        String string4 = hostServiceTicket.getService();
        String string5 = hostServiceTicket.getServiceVersion();
        String string6 = hostServiceTicket.getSessionId();
        if (hostServiceTicket.getSslThumbprint() != null) {
            string = hostServiceTicket.getSslThumbprint();
        }
        if (hostServiceTicket.getHost() != null) {
            string2 = hostServiceTicket.getHost();
        }
        if (hostServiceTicket.getPort() != null) {
            string3 = Integer.toString(hostServiceTicket.getPort());
        }
        StringBuilder stringBuilder = new StringBuilder("");
        stringBuilder.append("CIM Host Service Ticket Information\n");
        stringBuilder.append("Service        : ");
        stringBuilder.append(string4);
        stringBuilder.append("\n");
        stringBuilder.append("Service Version: ");
        stringBuilder.append(string5);
        stringBuilder.append("\n");
        stringBuilder.append("Session Id     : ");
        stringBuilder.append(string6);
        stringBuilder.append("\n");
        stringBuilder.append("SSL Thumbprint : ");
        stringBuilder.append(string);
        stringBuilder.append("\n");
        stringBuilder.append("Host           : ");
        stringBuilder.append(string2);
        stringBuilder.append("\n");
        stringBuilder.append("Port           : ");
        stringBuilder.append(string3);
        stringBuilder.append("\n");
        System.out.println("CIM Host Service Ticket Information\n");
        System.out.println("Service           : " + string4);
        System.out.println("Service Version   : " + string5);
        System.out.println("Session Id        : " + string6);
        System.out.println("SSL Thumbprint    : " + string);
        System.out.println("Host              : " + string2);
        System.out.println("Port              : " + string3);
        return stringBuilder.toString();
    }

    void acquireSessionInfo() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, IOException {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        ManagedObjectReference managedObjectReference = map.get(this.hostname);
        if (managedObjectReference == null) {
            String string = "Failure: Host [ " + this.hostname + "] not found";
            throw new HostFailure(string);
        }
        if (this.info == null || this.info.equalsIgnoreCase("cimticket")) {
            HostServiceTicket hostServiceTicket = this.vimPort.acquireCimServicesTicket(managedObjectReference);
            if (hostServiceTicket != null) {
                String string = this.stringToWrite(hostServiceTicket);
                this.writeToFile(string, this.filename);
            }
        } else {
            System.out.println("Support for " + this.info + " not implemented.");
        }
    }

    void writeToFile(String string, String string2) throws IOException {
        string2 = string2 == null ? "cimTicketInfo.txt" : string2;
        File file = new File(string2);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        if (file.exists()) {
            String string3 = string;
            fileOutputStream.write(string3.getBytes());
            fileOutputStream.flush();
            fileOutputStream.close();
            System.out.println("Saved session information at " + file.getAbsolutePath());
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, IOException, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.acquireSessionInfo();
    }

    private class HostFailure
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public HostFailure(String string) {
            super(string);
        }
    }
}

