/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.host;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.HostConfigFaultFaultMsg;
import com.vmware.vim25.HostConfigManager;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.NotFoundFaultMsg;
import com.vmware.vim25.ResourceInUseFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.util.Map;

@Sample(name="remove-virtual-switch-port-group", description="This sample removes a Virtual Switch PortGroup")
public class RemoveVirtualSwitchPortGroup
extends ConnectedVimServiceBase {
    private String host;
    private String portgroupname;

    @Option(name="hostname", description="Name of the host")
    public void setHost(String string) {
        this.host = string;
    }

    @Option(name="portgroupname", description="Name of the port group to be removed")
    public void setPortgroupname(String string) {
        this.portgroupname = string;
    }

    void removeVirtualSwitchPortGroup() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem");
        ManagedObjectReference managedObjectReference = map.get(this.host);
        if (managedObjectReference != null) {
            try {
                HostConfigManager hostConfigManager = (HostConfigManager)this.getMOREFs.entityProps(managedObjectReference, new String[]{"configManager"}).get("configManager");
                this.vimPort.removePortGroup(hostConfigManager.getNetworkSystem(), this.portgroupname);
                System.out.println("Successfully removed portgroup " + this.portgroupname);
            }
            catch (HostConfigFaultFaultMsg hostConfigFaultFaultMsg) {
                System.out.println("Failed removing " + this.portgroupname);
                System.out.println("Datacenter or Host may be invalid \n");
            }
            catch (NotFoundFaultMsg notFoundFaultMsg) {
                System.out.println("Failed removing " + this.portgroupname);
                System.out.println(" portgroup not found.\n");
            }
            catch (ResourceInUseFaultMsg resourceInUseFaultMsg) {
                System.out.println("Failed removing portgroup " + this.portgroupname);
                System.out.println("port group can not be removed because there are virtual network adapters associated with it.");
            }
            catch (RuntimeFaultFaultMsg runtimeFaultFaultMsg) {
                System.out.println("Failed removing " + this.portgroupname + runtimeFaultFaultMsg.getMessage());
            }
        } else {
            System.out.println("Host not found");
        }
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        this.removeVirtualSwitchPortGroup();
    }
}

