/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.Main;
import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.ArrayOfPerfInterval;
import com.vmware.vim25.ElementDescription;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfInterval;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfProviderSummary;
import com.vmware.vim25.PerfSummaryType;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.VimPortType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;

@Sample(name="performance-basics", description="displays available performance counters or other data")
public class Basics
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference perfManager;
    private String info;
    private String hostname;

    @Option(name="info", description="requested info - [interval|counter|host]")
    public void setInfo(String string) {
        this.info = string;
    }

    @Option(name="hostname", required=false, description="required when 'info' is 'host'")
    public void setHostname(String string) {
        this.hostname = string;
    }

    void validateTheInput() {
        if (this.info.equalsIgnoreCase("host") && this.hostname == null) {
            throw new Main.SampleInputValidationException("Must specify the --hostname parameter when --info is host");
        }
    }

    void displayBasics() throws RuntimeFaultFaultMsg, DatatypeConfigurationException, InvalidPropertyFaultMsg {
        if (this.info.equalsIgnoreCase("interval")) {
            this.getIntervals(this.perfManager, this.vimPort);
        } else if (this.info.equalsIgnoreCase("counter")) {
            this.getCounters(this.perfManager, this.vimPort);
        } else if (this.info.equalsIgnoreCase("host")) {
            Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
            ManagedObjectReference managedObjectReference = map.get(this.hostname);
            if (managedObjectReference == null) {
                System.out.println("Host " + this.hostname + " not found");
                return;
            }
            this.getQuerySummary(this.perfManager, managedObjectReference, this.vimPort);
            this.getQueryAvailable(this.perfManager, managedObjectReference, this.vimPort);
        } else {
            System.out.println("Invalid info argument [host|counter|interval]");
        }
    }

    void getIntervals(ManagedObjectReference managedObjectReference, VimPortType vimPortType) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Object object = this.getMOREFs.entityProps(managedObjectReference, new String[]{"historicalInterval"}).get("historicalInterval");
        ArrayOfPerfInterval arrayOfPerfInterval = (ArrayOfPerfInterval)object;
        List list = arrayOfPerfInterval.getPerfInterval();
        System.out.println("Performance intervals (" + list.size() + "):");
        System.out.println("---------------------");
        int n = 0;
        for (PerfInterval perfInterval : list) {
            System.out.print(++n + ": " + perfInterval.getName());
            System.out.print(" -- period = " + perfInterval.getSamplingPeriod());
            System.out.println(", length = " + perfInterval.getLength());
        }
        System.out.println();
    }

    void getCounters(ManagedObjectReference managedObjectReference, VimPortType vimPortType) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        Object object = this.getMOREFs.entityProps(managedObjectReference, new String[]{"perfCounter"}).get("perfCounter");
        ArrayOfPerfCounterInfo arrayOfPerfCounterInfo = (ArrayOfPerfCounterInfo)object;
        List list = arrayOfPerfCounterInfo.getPerfCounterInfo();
        System.out.println("Performance counters (averages only):");
        System.out.println("-------------------------------------");
        for (PerfCounterInfo perfCounterInfo : list) {
            if (perfCounterInfo.getRollupType() != PerfSummaryType.AVERAGE) continue;
            ElementDescription elementDescription = perfCounterInfo.getNameInfo();
            System.out.println(elementDescription.getLabel() + ": " + elementDescription.getSummary());
        }
        System.out.println();
    }

    void getQuerySummary(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, VimPortType vimPortType) throws RuntimeFaultFaultMsg {
        PerfProviderSummary perfProviderSummary = vimPortType.queryPerfProviderSummary(managedObjectReference, managedObjectReference2);
        System.out.println("Host perf capabilities:");
        System.out.println("----------------------");
        System.out.println("  Summary supported: " + perfProviderSummary.isSummarySupported());
        System.out.println("  Current supported: " + perfProviderSummary.isCurrentSupported());
        if (perfProviderSummary.isCurrentSupported()) {
            System.out.println("  Current refresh rate: " + perfProviderSummary.getRefreshRate());
        }
        System.out.println();
    }

    void getQueryAvailable(ManagedObjectReference managedObjectReference, ManagedObjectReference managedObjectReference2, VimPortType vimPortType) throws DatatypeConfigurationException, RuntimeFaultFaultMsg {
        PerfProviderSummary perfProviderSummary = vimPortType.queryPerfProviderSummary(managedObjectReference, managedObjectReference2);
        List list = vimPortType.queryAvailablePerfMetric(managedObjectReference, managedObjectReference2, null, null, perfProviderSummary.getRefreshRate());
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (int i = 0; i != list.size(); ++i) {
            arrayList.add(((PerfMetricId)list.get(i)).getCounterId());
        }
        List list2 = vimPortType.queryPerfCounter(managedObjectReference, arrayList);
        System.out.println("Available real-time metrics for host (" + list.size() + "):");
        System.out.println("--------------------------");
        for (int i = 0; i != list.size(); ++i) {
            String string = ((PerfCounterInfo)list2.get(i)).getNameInfo().getLabel();
            String string2 = ((PerfMetricId)list.get(i)).getInstance();
            System.out.print("   " + string);
            if (string2.length() != 0) {
                System.out.print(" [" + string2 + "]");
            }
            System.out.println();
        }
        System.out.println();
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DatatypeConfigurationException {
        this.validateTheInput();
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.perfManager = this.serviceContent.getPerfManager();
        this.displayBasics();
    }
}

