/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.performance;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfPerfCounterInfo;
import com.vmware.vim25.ArrayOfPerfInterval;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PerfCounterInfo;
import com.vmware.vim25.PerfEntityMetric;
import com.vmware.vim25.PerfEntityMetricBase;
import com.vmware.vim25.PerfInterval;
import com.vmware.vim25.PerfMetricId;
import com.vmware.vim25.PerfMetricIntSeries;
import com.vmware.vim25.PerfMetricSeries;
import com.vmware.vim25.PerfQuerySpec;
import com.vmware.vim25.PerfSampleInfo;
import com.vmware.vim25.PerfStatsType;
import com.vmware.vim25.PerfSummaryType;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="history", description="reads performance measurements from the current time")
public class History
extends ConnectedVimServiceBase {
    private ManagedObjectReference rootFolder;
    private ManagedObjectReference perfManager;
    private ManagedObjectReference propCollector;
    Map<String, Map<String, ArrayList<PerfCounterInfo>>> pci = new HashMap<String, Map<String, ArrayList<PerfCounterInfo>>>();
    String hostname = null;
    String interval = null;
    int starttime = 0;
    int duration = 0;
    String groupname = null;
    String countername = null;

    @Option(name="hostname", description="name of the host")
    public void setHostname(String string) {
        this.hostname = string;
    }

    @Option(name="interval", description="sampling interval in seconds.")
    public void setInterval(String string) {
        this.interval = string;
    }

    @Option(name="starttime", required=false, description="In minutes, to specify what's start time from which samples needs to be collected")
    public void setStarttime(int n) {
        this.starttime = n;
    }

    @Option(name="duration", required=false, description="Duration for which samples needs to be  taken")
    public void setDuration(int n) {
        this.duration = n;
    }

    @Option(name="groupname", description="[cpu|mem]")
    public void setGroupname(String string) {
        this.groupname = string;
    }

    @Option(name="countername", description="usage (for cpu and mem), overhead (for mem)")
    public void setCountername(String string) {
        this.countername = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws Exception {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollector, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollector, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    void setStartTimeAndDuration(int n, int n2) throws Exception {
        if (n == 0 || n2 == 0) {
            this.duration = 20;
            this.starttime = 20;
        } else {
            this.duration = n <= 0 ? 20 : n;
            int n3 = this.starttime = n2 <= 0 ? 20 : n2;
        }
        if (this.duration > this.starttime) {
            System.out.println("Duration must be less than startime");
        }
    }

    List<PerfInterval> getPerfInterval() throws Exception {
        List list = null;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("historicalInterval");
        propertySpec.setType("PerformanceManager");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.perfManager);
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
        arrayList3.add(propertyFilterSpec);
        ArrayList<PropertyFilterSpec> arrayList4 = new ArrayList<PropertyFilterSpec>(1);
        arrayList4.add(propertyFilterSpec);
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList4);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                List list3 = objectContent.getPropSet();
                if (list3 == null) continue;
                for (DynamicProperty dynamicProperty : list3) {
                    List list4;
                    list = list4 = ((ArrayOfPerfInterval)dynamicProperty.getVal()).getPerfInterval();
                }
            }
        }
        return list;
    }

    void displayHistory() throws Exception {
        int n;
        Map<String, ManagedObjectReference> map = this.getMOREFs.inFolderByType(this.serviceContent.getRootFolder(), "HostSystem", new RetrieveOptions());
        ManagedObjectReference managedObjectReference = map.get(this.hostname);
        if (managedObjectReference == null) {
            System.out.println("Host " + this.hostname + " not found");
            return;
        }
        this.counterInfo(this.perfManager);
        List<PerfInterval> list = this.getPerfInterval();
        boolean bl = this.checkInterval(list, Integer.valueOf(this.interval));
        if (!bl) {
            System.out.println("Invalid interval, Specify one from above");
            return;
        }
        PerfCounterInfo perfCounterInfo = this.getCounterInfo(this.groupname, this.countername, PerfSummaryType.AVERAGE, null);
        if (perfCounterInfo == null) {
            System.out.println("Incorrect Group Name and Countername specified");
            return;
        }
        PerfQuerySpec perfQuerySpec = new PerfQuerySpec();
        perfQuerySpec.setEntity(managedObjectReference);
        perfQuerySpec.setMaxSample(new Integer(10));
        ArrayList<PerfQuerySpec> arrayList = new ArrayList<PerfQuerySpec>();
        arrayList.add(perfQuerySpec);
        XMLGregorianCalendar xMLGregorianCalendar = this.vimPort.currentTime(this.getServiceInstanceReference());
        XMLGregorianCalendar xMLGregorianCalendar2 = this.vimPort.currentTime(this.getServiceInstanceReference());
        int n2 = this.duration - 2 * this.starttime;
        int n3 = this.duration - (2 * this.starttime + this.duration);
        if (n3 < 0) {
            n = xMLGregorianCalendar.getMinute() + (60 + n3);
            if (n >= 60) {
                xMLGregorianCalendar.setMinute(n -= 60);
            } else {
                xMLGregorianCalendar.setHour(xMLGregorianCalendar.getHour() - 1);
                xMLGregorianCalendar.setMinute(n);
            }
        } else {
            xMLGregorianCalendar.setMinute(xMLGregorianCalendar.getMinute() + (this.duration - (2 * this.starttime + this.duration)));
        }
        if (n2 < 0) {
            n = xMLGregorianCalendar2.getMinute() + (60 + n2);
            if (n >= 60) {
                xMLGregorianCalendar2.setMinute(n -= 60);
            } else {
                xMLGregorianCalendar2.setHour(xMLGregorianCalendar2.getHour() - 1);
                xMLGregorianCalendar2.setMinute(n);
            }
        } else {
            xMLGregorianCalendar2.setMinute(xMLGregorianCalendar2.getMinute() + (this.duration - 2 * this.starttime));
        }
        System.out.println("Start Time " + xMLGregorianCalendar.toGregorianCalendar().getTime().toString());
        System.out.println("End Time   " + xMLGregorianCalendar2.toGregorianCalendar().getTime().toString());
        System.out.println();
        List list2 = this.vimPort.queryAvailablePerfMetric(this.perfManager, managedObjectReference, xMLGregorianCalendar, xMLGregorianCalendar2, Integer.valueOf(this.interval));
        PerfMetricId perfMetricId = null;
        for (int i = 0; i < list2.size(); ++i) {
            if (((PerfMetricId)list2.get(i)).getCounterId() != perfCounterInfo.getKey()) continue;
            perfMetricId = (PerfMetricId)list2.get(i);
            break;
        }
        if (perfMetricId == null) {
            System.out.println("No data on Host to collect. Has it been running for at least " + this.duration + " minutes");
        } else {
            perfQuerySpec = new PerfQuerySpec();
            perfQuerySpec.setEntity(managedObjectReference);
            perfQuerySpec.setStartTime(xMLGregorianCalendar);
            perfQuerySpec.setEndTime(xMLGregorianCalendar2);
            perfQuerySpec.getMetricId().addAll(Arrays.asList(perfMetricId));
            perfQuerySpec.setIntervalId(Integer.valueOf(this.interval));
            arrayList.add(perfQuerySpec);
            ArrayList<PerfQuerySpec> arrayList2 = new ArrayList<PerfQuerySpec>(1);
            arrayList2.add(perfQuerySpec);
            List list3 = this.vimPort.queryPerf(this.perfManager, arrayList2);
            if (list3 != null) {
                this.displayValues(list3, perfCounterInfo, perfMetricId, Integer.valueOf(this.interval));
            } else {
                System.out.println("No Samples Found");
            }
        }
    }

    boolean checkInterval(List<PerfInterval> list, Integer n) throws Exception {
        PerfInterval perfInterval;
        int n2;
        boolean bl = false;
        for (n2 = 0; n2 < list.size(); ++n2) {
            perfInterval = list.get(n2);
            if (perfInterval.getSamplingPeriod() != n.intValue()) continue;
            bl = true;
            break;
        }
        if (!bl) {
            System.out.println("Available summary collection intervals");
            System.out.println("Period\tLength\tName");
            for (n2 = 0; n2 < list.size(); ++n2) {
                perfInterval = list.get(n2);
                System.out.println(perfInterval.getSamplingPeriod() + "\t" + perfInterval.getLength() + "\t" + perfInterval.getName());
            }
            System.out.println();
        }
        return bl;
    }

    List<PerfCounterInfo> getPerfCounters() throws Exception {
        List list = null;
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("perfCounter");
        propertySpec.setType("PerformanceManager");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.perfManager);
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList3 = new ArrayList<PropertyFilterSpec>();
        arrayList3.add(propertyFilterSpec);
        ArrayList<PropertyFilterSpec> arrayList4 = new ArrayList<PropertyFilterSpec>(1);
        arrayList4.add(propertyFilterSpec);
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList4);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                List list3 = objectContent.getPropSet();
                if (list3 == null) continue;
                for (DynamicProperty dynamicProperty : list3) {
                    List list4;
                    list = list4 = ((ArrayOfPerfCounterInfo)dynamicProperty.getVal()).getPerfCounterInfo();
                }
            }
        }
        return list;
    }

    void counterInfo(ManagedObjectReference managedObjectReference) throws Exception {
        List<PerfCounterInfo> list = this.getPerfCounters();
        for (int i = 0; i < list.size(); ++i) {
            PerfCounterInfo perfCounterInfo = list.get(i);
            String string = perfCounterInfo.getGroupInfo().getKey();
            Map<Object, Object> map = null;
            if (!this.pci.containsKey(string)) {
                map = new HashMap();
                this.pci.put(string, map);
            } else {
                map = this.pci.get(string);
            }
            String string2 = perfCounterInfo.getNameInfo().getKey();
            ArrayList arrayList = null;
            if (!map.containsKey(string2)) {
                arrayList = new ArrayList();
                map.put(string2, arrayList);
            } else {
                arrayList = (ArrayList)map.get(string2);
            }
            arrayList.add(perfCounterInfo);
        }
    }

    ArrayList<PerfCounterInfo> getCounterInfos(String string, String string2) {
        ArrayList<PerfCounterInfo> arrayList;
        Map<String, ArrayList<PerfCounterInfo>> map = this.pci.get(string);
        if (map != null && (arrayList = map.get(string2)) != null) {
            return arrayList;
        }
        return null;
    }

    PerfCounterInfo getCounterInfo(String string, String string2, PerfSummaryType perfSummaryType, PerfStatsType perfStatsType) {
        ArrayList<PerfCounterInfo> arrayList = this.getCounterInfos(string, string2);
        if (arrayList != null) {
            for (PerfCounterInfo perfCounterInfo : arrayList) {
                if (perfStatsType != null && !perfStatsType.equals((Object)perfCounterInfo.getStatsType()) || perfSummaryType != null && !perfSummaryType.equals((Object)perfCounterInfo.getRollupType())) continue;
                return perfCounterInfo;
            }
        }
        return null;
    }

    void displayValues(List<PerfEntityMetricBase> list, PerfCounterInfo perfCounterInfo, PerfMetricId perfMetricId, Integer n) {
        for (int i = 0; i < list.size(); ++i) {
            List list2 = ((PerfEntityMetric)list.get(i)).getValue();
            List list3 = ((PerfEntityMetric)list.get(i)).getSampleInfo();
            if (list3 == null || list3.size() == 0) {
                System.out.println("No Samples available. Continuing.");
                continue;
            }
            System.out.println("Sample time range: " + ((PerfSampleInfo)list3.get(0)).getTimestamp().toGregorianCalendar().getTime().toString() + " - " + ((PerfSampleInfo)list3.get(list3.size() - 1)).getTimestamp().toGregorianCalendar().getTime().toString() + ", read every " + n + " seconds");
            for (int j = 0; j < list2.size(); ++j) {
                if (perfCounterInfo != null) {
                    if (perfCounterInfo.getKey() != ((PerfMetricSeries)list2.get(j)).getId().getCounterId()) continue;
                    System.out.println(perfCounterInfo.getNameInfo().getSummary() + " - Instance: " + perfMetricId.getInstance());
                }
                if (!(list2.get(j) instanceof PerfMetricIntSeries)) continue;
                PerfMetricIntSeries perfMetricIntSeries = (PerfMetricIntSeries)list2.get(j);
                List list4 = perfMetricIntSeries.getValue();
                for (int k = 0; k < list4.size(); ++k) {
                    System.out.println("timestamp: " + ((PerfSampleInfo)list3.get(k)).getTimestamp().toGregorianCalendar().getTime() + "\tvalue: " + list4.get(k));
                }
            }
        }
    }

    @Action
    public void run() throws Exception {
        this.rootFolder = this.serviceContent.getRootFolder();
        this.perfManager = this.serviceContent.getPerfManager();
        this.propCollector = this.serviceContent.getPropertyCollector();
        this.setStartTimeAndDuration(this.duration, this.starttime);
        this.displayHistory();
    }
}

