/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.scheduling;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TraversalSpec;
import java.util.ArrayList;
import java.util.List;

@Sample(name="delete-one-time-task", description="This sample demonstrates deleting a scheduled task")
public class DeleteOneTimeScheduledTask
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference scheduleManager;
    String taskName = null;

    @Option(name="taskname", description="name of the task to be deleted")
    public void setTaskName(String string) {
        this.taskName = string;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
        if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
            arrayList.addAll(retrieveResult.getObjects());
        }
        String string = null;
        if (retrieveResult != null && retrieveResult.getToken() != null) {
            string = retrieveResult.getToken();
        }
        while (string != null && !string.isEmpty()) {
            retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
            string = null;
            if (retrieveResult == null) continue;
            string = retrieveResult.getToken();
            if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
            arrayList.addAll(retrieveResult.getObjects());
        }
        return arrayList;
    }

    private PropertyFilterSpec createTaskPropertyFilterSpec() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setType(this.scheduleManager.getType());
        traversalSpec.setPath("scheduledTask");
        traversalSpec.setSkip(Boolean.FALSE);
        traversalSpec.setName("scheduleManagerToScheduledTasks");
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(new Boolean(false));
        propertySpec.getPathSet().add("info.name");
        propertySpec.setType("ScheduledTask");
        ArrayList<PropertySpec> arrayList = new ArrayList<PropertySpec>();
        arrayList.add(propertySpec);
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.scheduleManager);
        objectSpec.getSelectSet().add(traversalSpec);
        objectSpec.setSkip(Boolean.TRUE);
        ArrayList<ObjectSpec> arrayList2 = new ArrayList<ObjectSpec>();
        arrayList2.add(objectSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().addAll(arrayList);
        propertyFilterSpec.getObjectSet().addAll(arrayList2);
        return propertyFilterSpec;
    }

    private ManagedObjectReference findOneTimeScheduledTask(PropertyFilterSpec propertyFilterSpec) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        boolean bl = false;
        ManagedObjectReference managedObjectReference = null;
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            for (int i = 0; i < list.size() && !bl; ++i) {
                ObjectContent objectContent = list.get(i);
                List list2 = objectContent.getPropSet();
                for (int j = 0; j < list2.size() && !bl; ++j) {
                    DynamicProperty dynamicProperty = (DynamicProperty)list2.get(j);
                    String string = (String)dynamicProperty.getVal();
                    if (!this.taskName.equals(string)) continue;
                    managedObjectReference = objectContent.getObj();
                    bl = true;
                }
            }
        }
        if (!bl) {
            System.out.println("Scheduled task '" + this.taskName + "' not found");
        }
        return managedObjectReference;
    }

    private void deleteScheduledTask(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidStateFaultMsg {
        this.vimPort.removeScheduledTask(managedObjectReference);
        System.out.println("Successfully Deleted ScheduledTask: " + managedObjectReference.getValue());
    }

    @Action
    public void run() throws RuntimeFaultFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.scheduleManager = this.serviceContent.getScheduledTaskManager();
        PropertyFilterSpec propertyFilterSpec = this.createTaskPropertyFilterSpec();
        ManagedObjectReference managedObjectReference = this.findOneTimeScheduledTask(propertyFilterSpec);
        if (managedObjectReference != null) {
            this.deleteScheduledTask(managedObjectReference);
        }
    }
}

