/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.scheduling;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodAction;
import com.vmware.vim25.OnceTaskScheduler;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ScheduledTaskSpec;
import com.vmware.vim25.TaskScheduler;
import java.util.GregorianCalendar;
import java.util.Map;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="one-time-task", description="This sample demonstrates creation of ScheduledTask using the ScheduledTaskManager")
public class OneTimeScheduledTask
extends ConnectedVimServiceBase {
    ManagedObjectReference propCollectorRef;
    ManagedObjectReference scheduleManager;
    ManagedObjectReference virtualMachine;
    String vmName = null;
    String taskName = null;

    @Option(name="vmname", description="name of the VM to power off")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="taskname", description="name of the task")
    public void setTaskName(String string) {
        this.taskName = string;
    }

    com.vmware.vim25.Action createTaskAction() {
        MethodAction methodAction = new MethodAction();
        methodAction.setName("PowerOffVM_Task");
        return methodAction;
    }

    TaskScheduler createTaskScheduler() throws DatatypeConfigurationException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.add(12, 30);
        XMLGregorianCalendar xMLGregorianCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(gregorianCalendar);
        OnceTaskScheduler onceTaskScheduler = new OnceTaskScheduler();
        onceTaskScheduler.setRunAt(xMLGregorianCalendar);
        return onceTaskScheduler;
    }

    void createScheduledTask(com.vmware.vim25.Action action, TaskScheduler taskScheduler) throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg {
        ScheduledTaskSpec scheduledTaskSpec = new ScheduledTaskSpec();
        scheduledTaskSpec.setName(this.taskName);
        scheduledTaskSpec.setDescription("PowerOff VM in 30 minutes");
        scheduledTaskSpec.setEnabled(true);
        scheduledTaskSpec.setAction(action);
        scheduledTaskSpec.setScheduler(taskScheduler);
        if (this.virtualMachine == null) {
            System.out.println("Virtual Machine " + this.vmName + " not found");
            return;
        }
        ManagedObjectReference managedObjectReference = this.vimPort.createScheduledTask(this.scheduleManager, this.virtualMachine, scheduledTaskSpec);
        System.out.println("Successfully created Once Task: " + managedObjectReference.getValue());
    }

    @Action
    public void run() throws DatatypeConfigurationException, DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.scheduleManager = this.serviceContent.getScheduledTaskManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        this.virtualMachine = map.get(this.vmName);
        com.vmware.vim25.Action action = this.createTaskAction();
        TaskScheduler taskScheduler = this.createTaskScheduler();
        this.createScheduledTask(action, taskScheduler);
    }
}

