/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.scheduling;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MethodAction;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.ScheduledTaskSpec;
import com.vmware.vim25.TaskScheduler;
import com.vmware.vim25.WeeklyTaskScheduler;
import java.util.Map;

@Sample(name="weekly-scheduled-task", description="This sample demonstrates creation of weekly recurring ScheduledTask using the ScheduledTaskManager. This sample will create a task to Reboot Guest VM's at 11.59 pm every Saturday")
public class WeeklyRecurrenceScheduledTask
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    private ManagedObjectReference virtualMachine;
    private ManagedObjectReference scheduleManager;
    String vmName = null;
    String taskName = null;

    @Option(name="vmname", description="virtual machine to be powered off")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="taskname", description="Name of the task to be created")
    public void setTaskName(String string) {
        this.taskName = string;
    }

    private com.vmware.vim25.Action createTaskAction() {
        MethodAction methodAction = new MethodAction();
        methodAction.setName("RebootGuest");
        return methodAction;
    }

    private TaskScheduler createTaskScheduler() {
        WeeklyTaskScheduler weeklyTaskScheduler = new WeeklyTaskScheduler();
        weeklyTaskScheduler.setSaturday(true);
        weeklyTaskScheduler.setHour(23);
        weeklyTaskScheduler.setMinute(59);
        weeklyTaskScheduler.setInterval(1);
        return weeklyTaskScheduler;
    }

    void createScheduledTask(com.vmware.vim25.Action action, TaskScheduler taskScheduler) throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg {
        ScheduledTaskSpec scheduledTaskSpec = new ScheduledTaskSpec();
        scheduledTaskSpec.setName(this.taskName);
        scheduledTaskSpec.setDescription("Reboot VM's Guest at 11.59 pm every Saturday");
        scheduledTaskSpec.setEnabled(true);
        scheduledTaskSpec.setAction(action);
        scheduledTaskSpec.setScheduler(taskScheduler);
        ManagedObjectReference managedObjectReference = this.vimPort.createScheduledTask(this.scheduleManager, this.virtualMachine, scheduledTaskSpec);
        System.out.println("Successfully created Weekly Task: " + managedObjectReference.getValue());
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.scheduleManager = this.serviceContent.getScheduledTaskManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "VirtualMachine");
        this.virtualMachine = map.get(this.vmName);
        com.vmware.vim25.Action action = this.createTaskAction();
        TaskScheduler taskScheduler = this.createTaskScheduler();
        this.createScheduledTask(action, taskScheduler);
    }
}

