/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.storage;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidFolderFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.StorageDrsConfigSpec;
import com.vmware.vim25.StorageDrsIoLoadBalanceConfig;
import com.vmware.vim25.StorageDrsPodConfigSpec;
import com.vmware.vim25.StorageDrsSpaceLoadBalanceConfig;
import com.vmware.vim25.TaskInfoState;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Map;

@Sample(name="create-storage-drs", description="This sample demonstrates how to create Storage DRS")
public class CreateStorageDRS
extends ConnectedVimServiceBase {
    private ManagedObjectReference propCollectorRef;
    String dcName = null;
    String sdrsname = null;
    Boolean behavior = Boolean.FALSE;
    String ioLatencyThreshold = null;
    String ioLoadImbalanceThreshold = null;
    String loadBalanceInterval = null;
    String minSpaceUtilizationDifference = null;
    String spaceUtilizationThreshold = null;
    String dsname = null;

    @Option(name="dcname", description="data center name")
    public void setDcName(String string) {
        this.dcName = string;
    }

    @Option(name="sdrsname", description="Name for the new storage pod.")
    public void setSdrsname(String string) {
        this.sdrsname = string;
    }

    @Option(name="behavior", required=false, description="Storage DRS behavior: 'true' if automated. It is manual by default.")
    public void setBehavior(String string) {
        this.behavior = new Boolean(string);
    }

    @Option(name="iolatencythreshold", required=false, description="int: Storage DRS makes storage migration\nrecommendations if I/O latency on one (or more)\nof the datastores is higher than the specified\nthreshold. Range is 5-100 ms, default is 15ms\n")
    public void setIoLatencyThreshold(String string) {
        this.ioLatencyThreshold = string;
    }

    @Option(name="ioloadimbalancethreshold", required=false, description="\n\tStorage DRS makes storage migration\nrecommendations if I/O load imbalance\nlevel is higher than the specified threshold.\nRange is 1-100, default is 5\n")
    public void setIoLoadImbalanceThreshold(String string) {
        this.ioLoadImbalanceThreshold = string;
    }

    @Option(name="loadbalinterval", required=false, description="Specify the interval that storage DRS runs to\nload balance among datastores within a storage\npod. it is 480 by default.")
    public void setLoadBalanceInterval(String string) {
        this.loadBalanceInterval = string;
    }

    @Option(name="minutilizationdiff", required=false, description="Storage DRS considers making storage migration\nrecommendations if the difference in space\nutilization between the source and  destination\ndatastores is higher than the specified threshold.\nRange 1-50%, default is 5%")
    public void setMinSpaceUtilizationDifference(String string) {
        this.minSpaceUtilizationDifference = string;
    }

    @Option(name="utilizationthreshold", required=false, description="Storage DRS makes storage migration\nrecommendations if space utilization on one\n(or more) of the datastores is higher than the\nspecified threshold. Range 50-100%, default is 80%")
    public void setSpaceUtilizationThreshold(String string) {
        this.spaceUtilizationThreshold = string;
    }

    @Option(name="datastore", required=false, description="Name of the datastore to be added in StoragePod.")
    public void setDsname(String string) {
        this.dsname = string;
    }

    void validate() {
        if (this.sdrsname == null || this.dcName == null) {
            throw new IllegalArgumentException("Expected valid -dcname, --sdrsname arguments.");
        }
        if (this.ioLatencyThreshold != null && (Integer.parseInt(this.ioLatencyThreshold) < 5 || Integer.parseInt(this.ioLatencyThreshold) > 50)) {
            throw new IllegalArgumentException("Expected valid --iolatencythreshold argument. Range is 5-50 ms.");
        }
        if (this.ioLoadImbalanceThreshold != null && (Integer.parseInt(this.ioLoadImbalanceThreshold) < 1 || Integer.parseInt(this.ioLoadImbalanceThreshold) > 100)) {
            throw new IllegalArgumentException("Expected valid --ioloadimbalancethreshold argument. Range is 1-100.");
        }
        if (this.minSpaceUtilizationDifference != null && (Integer.parseInt(this.minSpaceUtilizationDifference) < 1 || Integer.parseInt(this.minSpaceUtilizationDifference) > 50)) {
            throw new IllegalArgumentException("Expected valid --minutilizationdiff argument. Range is 1-50%.");
        }
        if (this.spaceUtilizationThreshold != null && (Integer.parseInt(this.spaceUtilizationThreshold) < 50 || Integer.parseInt(this.spaceUtilizationThreshold) > 100)) {
            throw new IllegalArgumentException("Expected valid --utilizationthreshold argument. Range is 50-100%.");
        }
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    StorageDrsConfigSpec getStorageDrsConfigSpec(boolean bl, String string, String string2, String string3, String string4, String string5) {
        StorageDrsConfigSpec storageDrsConfigSpec = new StorageDrsConfigSpec();
        StorageDrsPodConfigSpec storageDrsPodConfigSpec = new StorageDrsPodConfigSpec();
        storageDrsPodConfigSpec.setDefaultIntraVmAffinity(Boolean.valueOf(true));
        if (bl) {
            storageDrsPodConfigSpec.setDefaultVmBehavior("automated");
        } else {
            storageDrsPodConfigSpec.setDefaultVmBehavior("manual");
        }
        storageDrsPodConfigSpec.setEnabled(Boolean.valueOf(true));
        StorageDrsIoLoadBalanceConfig storageDrsIoLoadBalanceConfig = new StorageDrsIoLoadBalanceConfig();
        if (string != null) {
            storageDrsIoLoadBalanceConfig.setIoLatencyThreshold(Integer.valueOf(Integer.parseInt(string)));
        } else {
            storageDrsIoLoadBalanceConfig.setIoLatencyThreshold(Integer.valueOf(15));
        }
        if (string2 != null) {
            storageDrsIoLoadBalanceConfig.setIoLoadImbalanceThreshold(Integer.valueOf(Integer.parseInt(string2)));
        } else {
            storageDrsIoLoadBalanceConfig.setIoLoadImbalanceThreshold(Integer.valueOf(5));
        }
        storageDrsPodConfigSpec.setIoLoadBalanceConfig(storageDrsIoLoadBalanceConfig);
        storageDrsPodConfigSpec.setIoLoadBalanceEnabled(Boolean.valueOf(true));
        if (string3 != null) {
            storageDrsPodConfigSpec.setLoadBalanceInterval(Integer.valueOf(Integer.parseInt(string3)));
        } else {
            storageDrsPodConfigSpec.setLoadBalanceInterval(Integer.valueOf(480));
        }
        StorageDrsSpaceLoadBalanceConfig storageDrsSpaceLoadBalanceConfig = new StorageDrsSpaceLoadBalanceConfig();
        if (string4 != null) {
            storageDrsSpaceLoadBalanceConfig.setMinSpaceUtilizationDifference(Integer.valueOf(Integer.parseInt(string4)));
        } else {
            storageDrsSpaceLoadBalanceConfig.setMinSpaceUtilizationDifference(Integer.valueOf(5));
        }
        if (string5 != null) {
            storageDrsSpaceLoadBalanceConfig.setSpaceUtilizationThreshold(Integer.valueOf(Integer.parseInt(string5)));
        } else {
            storageDrsSpaceLoadBalanceConfig.setSpaceUtilizationThreshold(Integer.valueOf(80));
        }
        storageDrsPodConfigSpec.setSpaceLoadBalanceConfig(storageDrsSpaceLoadBalanceConfig);
        storageDrsConfigSpec.setPodConfigSpec(storageDrsPodConfigSpec);
        return storageDrsConfigSpec;
    }

    /*
     * Enabled aggressive block sorting
     */
    void createSDRS(String string, String string2, boolean bl, String string3, String string4, String string5, String string6, String string7, String string8) throws InvocationTargetException, NoSuchMethodException, IllegalAccessException, DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, InvalidFolderFaultMsg, InvalidStateFaultMsg {
        ManagedObjectReference managedObjectReference = new ManagedObjectReference();
        ManagedObjectReference managedObjectReference2 = this.serviceContent.getStorageResourceManager();
        Map<String, ManagedObjectReference> map = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datacenter");
        ManagedObjectReference managedObjectReference3 = map.get(string);
        if (managedObjectReference3 == null) {
            System.out.println("Datacenter " + string + " Not Found");
            return;
        }
        Map<String, Object> map2 = this.getMOREFs.entityProps(managedObjectReference3, new String[]{"datastoreFolder"});
        ManagedObjectReference managedObjectReference4 = (ManagedObjectReference)map2.get("datastoreFolder");
        managedObjectReference = this.vimPort.createStoragePod(managedObjectReference4, string2);
        System.out.printf("Success: Creating storagePod.", new Object[0]);
        StorageDrsConfigSpec storageDrsConfigSpec = this.getStorageDrsConfigSpec(bl, string3, string4, string5, string6, string7);
        ManagedObjectReference managedObjectReference5 = this.vimPort.configureStorageDrsForPodTask(managedObjectReference2, managedObjectReference, storageDrsConfigSpec, true);
        if (!this.getTaskResultAfterDone(managedObjectReference5)) throw new RuntimeException("Failure: Configuring storagePod.");
        System.out.printf("\nSuccess: Configuring storagePod.", new Object[0]);
        if (string8 == null) return;
        Map<String, ManagedObjectReference> map3 = this.getMOREFs.inContainerByType(this.serviceContent.getRootFolder(), "Datastore");
        ManagedObjectReference managedObjectReference6 = map3.get(string8);
        if (managedObjectReference6 != null) {
            ArrayList<ManagedObjectReference> arrayList = new ArrayList<ManagedObjectReference>();
            arrayList.add(managedObjectReference6);
            ManagedObjectReference managedObjectReference7 = this.vimPort.moveIntoFolderTask(managedObjectReference, arrayList);
            if (!this.getTaskResultAfterDone(managedObjectReference7)) throw new RuntimeException("Failure: Adding datastore to storagePod.");
            System.out.printf("\nSuccess: Adding datastore to storagePod.", new Object[0]);
            return;
        }
        System.out.println("Datastore " + string8 + " Not Found");
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, InvocationTargetException, InvalidFolderFaultMsg, InvalidPropertyFaultMsg, NoSuchMethodException, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg, IllegalAccessException {
        this.validate();
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.createSDRS(this.dcName, this.sdrsname, this.behavior, this.ioLatencyThreshold, this.ioLoadImbalanceThreshold, this.loadBalanceInterval, this.minSpaceUtilizationDifference, this.spaceUtilizationThreshold, this.dsname);
    }
}

