/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.DynamicProperty;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.ObjectContent;
import com.vmware.vim25.ObjectSpec;
import com.vmware.vim25.PropertyFilterSpec;
import com.vmware.vim25.PropertySpec;
import com.vmware.vim25.RetrieveOptions;
import com.vmware.vim25.RetrieveResult;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SelectionSpec;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.TraversalSpec;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecFileOperation;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceFileBackingInfo;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer1BackingInfo;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualDiskRawDiskMappingVer1BackingInfo;
import com.vmware.vim25.VirtualDiskSparseVer1BackingInfo;
import com.vmware.vim25.VirtualDiskSparseVer2BackingInfo;
import com.vmware.vim25.VirtualHardware;
import com.vmware.vim25.VirtualMachineConfigSpec;
import java.util.ArrayList;
import java.util.List;

@Sample(name="vm-delta-disk", description="This sample creates a delta disk on top of an existing virtual disk in a VM,\nand simultaneously removes the original disk using the reconfigure API.\n")
public class VMDeltaDisk
extends ConnectedVimServiceBase {
    private ManagedObjectReference rootFolderRef;
    private ManagedObjectReference propCollectorRef;
    String vmName = null;
    String device = null;
    String diskName = null;

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVmName(String string) {
        this.vmName = string;
    }

    @Option(name="devicename", description="Name of the new delta disk")
    public void setDevice(String string) {
        this.device = string;
    }

    @Option(name="diskname", description="Name of the disk")
    public void setDiskName(String string) {
        this.diskName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    List<ObjectContent> retrievePropertiesAllObjects(List<PropertyFilterSpec> list) {
        RetrieveOptions retrieveOptions = new RetrieveOptions();
        ArrayList<ObjectContent> arrayList = new ArrayList<ObjectContent>();
        try {
            RetrieveResult retrieveResult = this.vimPort.retrievePropertiesEx(this.propCollectorRef, list, retrieveOptions);
            if (retrieveResult != null && retrieveResult.getObjects() != null && !retrieveResult.getObjects().isEmpty()) {
                arrayList.addAll(retrieveResult.getObjects());
            }
            String string = null;
            if (retrieveResult != null && retrieveResult.getToken() != null) {
                string = retrieveResult.getToken();
            }
            while (string != null && !string.isEmpty()) {
                retrieveResult = this.vimPort.continueRetrievePropertiesEx(this.propCollectorRef, string);
                string = null;
                if (retrieveResult == null) continue;
                string = retrieveResult.getToken();
                if (retrieveResult.getObjects() == null || retrieveResult.getObjects().isEmpty()) continue;
                arrayList.addAll(retrieveResult.getObjects());
            }
        }
        catch (Exception exception) {
            System.out.println(" : Failed Getting Contents");
            exception.printStackTrace();
        }
        return arrayList;
    }

    void createDeltaDisk() throws IllegalArgumentException {
        List list;
        ManagedObjectReference managedObjectReference = this.getVMByVMname(this.vmName);
        String string = null;
        VirtualHardware virtualHardware = new VirtualHardware();
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>();
        arrayList.add(this.createPropertyFilterSpec(managedObjectReference, "config.hardware"));
        List<ObjectContent> list2 = this.retrievePropertiesAllObjects(arrayList);
        if (list2 != null) {
            for (ObjectContent objectContent : list2) {
                list = objectContent.getPropSet();
                if (list == null) continue;
                for (DynamicProperty dynamicProperty : list) {
                    virtualHardware = (VirtualHardware)dynamicProperty.getVal();
                }
            }
        }
        if (managedObjectReference != null) {
            VirtualDisk virtualDisk = this.findVirtualDisk(managedObjectReference, this.diskName, virtualHardware);
            if (virtualDisk != null) {
                VirtualDiskFlatVer1BackingInfo virtualDiskFlatVer1BackingInfo;
                List exception;
                DynamicProperty dynamicProperty;
                ObjectContent objectContent;
                objectContent = new VirtualMachineConfigSpec();
                list = new VirtualDeviceConfigSpec();
                list.setOperation(VirtualDeviceConfigSpecOperation.ADD);
                list.setFileOperation(VirtualDeviceConfigSpecFileOperation.CREATE);
                VirtualDisk virtualDisk2 = new VirtualDisk();
                virtualDisk2.setCapacityInKB(virtualDisk.getCapacityInKB());
                if (virtualDisk.getShares() != null) {
                    virtualDisk2.setShares(virtualDisk.getShares());
                }
                if (virtualDisk.getConnectable() != null) {
                    virtualDisk2.setConnectable(virtualDisk.getConnectable());
                }
                if (virtualDisk.getControllerKey() != null) {
                    virtualDisk2.setControllerKey(virtualDisk.getControllerKey());
                }
                dynamicProperty = (VirtualDeviceFileBackingInfo)virtualDisk.getBacking();
                ArrayList<PropertyFilterSpec> arrayList2 = new ArrayList<PropertyFilterSpec>();
                arrayList2.add(this.createPropertyFilterSpec(dynamicProperty.getDatastore(), "summary.name"));
                List<ObjectContent> list4 = this.retrievePropertiesAllObjects(arrayList2);
                if (list4 != null) {
                    for (ObjectContent object2 : list4) {
                        exception = object2.getPropSet();
                        if (exception == null) continue;
                        for (DynamicProperty dynamicProperty2 : exception) {
                            string = (String)dynamicProperty2.getVal();
                        }
                    }
                }
                virtualDisk2.setUnitNumber(virtualDisk.getUnitNumber());
                virtualDisk2.setKey(virtualDisk.getKey());
                if (virtualDisk.getBacking() instanceof VirtualDiskFlatVer1BackingInfo) {
                    virtualDiskFlatVer1BackingInfo = new VirtualDiskFlatVer1BackingInfo();
                    virtualDiskFlatVer1BackingInfo.setDiskMode(((VirtualDiskFlatVer1BackingInfo)virtualDisk.getBacking()).getDiskMode());
                    virtualDiskFlatVer1BackingInfo.setFileName("[" + string + "] " + this.vmName + "/" + this.device + ".vmdk");
                    virtualDiskFlatVer1BackingInfo.setParent((VirtualDiskFlatVer1BackingInfo)virtualDisk.getBacking());
                    virtualDisk2.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer1BackingInfo);
                } else if (virtualDisk.getBacking() instanceof VirtualDiskFlatVer2BackingInfo) {
                    virtualDiskFlatVer1BackingInfo = new VirtualDiskFlatVer2BackingInfo();
                    virtualDiskFlatVer1BackingInfo.setDiskMode(((VirtualDiskFlatVer2BackingInfo)virtualDisk.getBacking()).getDiskMode());
                    virtualDiskFlatVer1BackingInfo.setFileName("[" + string + "] " + this.vmName + "/" + this.device + ".vmdk");
                    virtualDiskFlatVer1BackingInfo.setParent((VirtualDiskFlatVer2BackingInfo)virtualDisk.getBacking());
                    virtualDisk2.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer1BackingInfo);
                } else if (virtualDisk.getBacking() instanceof VirtualDiskRawDiskMappingVer1BackingInfo) {
                    virtualDiskFlatVer1BackingInfo = new VirtualDiskRawDiskMappingVer1BackingInfo();
                    virtualDiskFlatVer1BackingInfo.setDiskMode(((VirtualDiskRawDiskMappingVer1BackingInfo)virtualDisk.getBacking()).getDiskMode());
                    virtualDiskFlatVer1BackingInfo.setFileName("[" + string + "] " + this.vmName + "/" + this.device + ".vmdk");
                    virtualDiskFlatVer1BackingInfo.setParent((VirtualDiskRawDiskMappingVer1BackingInfo)virtualDisk.getBacking());
                    virtualDisk2.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer1BackingInfo);
                } else if (virtualDisk.getBacking() instanceof VirtualDiskSparseVer1BackingInfo) {
                    virtualDiskFlatVer1BackingInfo = new VirtualDiskSparseVer1BackingInfo();
                    virtualDiskFlatVer1BackingInfo.setDiskMode(((VirtualDiskSparseVer1BackingInfo)virtualDisk.getBacking()).getDiskMode());
                    virtualDiskFlatVer1BackingInfo.setFileName("[" + string + "] " + this.vmName + "/" + this.device + ".vmdk");
                    virtualDiskFlatVer1BackingInfo.setParent((VirtualDiskSparseVer1BackingInfo)virtualDisk.getBacking());
                    virtualDisk2.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer1BackingInfo);
                } else if (virtualDisk.getBacking() instanceof VirtualDiskSparseVer2BackingInfo) {
                    virtualDiskFlatVer1BackingInfo = new VirtualDiskSparseVer2BackingInfo();
                    virtualDiskFlatVer1BackingInfo.setDiskMode(((VirtualDiskSparseVer2BackingInfo)virtualDisk.getBacking()).getDiskMode());
                    virtualDiskFlatVer1BackingInfo.setFileName("[" + string + "] " + this.vmName + "/" + this.device + ".vmdk");
                    virtualDiskFlatVer1BackingInfo.setParent((VirtualDiskSparseVer2BackingInfo)virtualDisk.getBacking());
                    virtualDisk2.setBacking((VirtualDeviceBackingInfo)virtualDiskFlatVer1BackingInfo);
                }
                list.setDevice((VirtualDevice)virtualDisk2);
                virtualDiskFlatVer1BackingInfo = new VirtualDeviceConfigSpec();
                virtualDiskFlatVer1BackingInfo.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
                virtualDiskFlatVer1BackingInfo.setDevice((VirtualDevice)virtualDisk);
                ArrayList<Object> arrayList3 = new ArrayList<Object>();
                arrayList3.add(virtualDiskFlatVer1BackingInfo);
                arrayList3.add(list);
                objectContent.getDeviceChange().addAll(arrayList3);
                try {
                    exception = this.vimPort.reconfigVMTask(managedObjectReference, (VirtualMachineConfigSpec)objectContent);
                    if (this.getTaskResultAfterDone((ManagedObjectReference)exception)) {
                        System.out.println("Delta Disk Created successfully.");
                    }
                    System.out.println("Failure -: Delta Disk cannot be created");
                }
                catch (Exception exception2) {
                    throw new RuntimeException(exception2);
                }
            } else {
                System.out.println("Virtual Disk " + this.diskName + " not found");
            }
        } else {
            System.out.println("Virtual Machine " + this.vmName + " doesn't exist");
        }
    }

    VirtualDisk findVirtualDisk(ManagedObjectReference managedObjectReference, String string, VirtualHardware virtualHardware) {
        VirtualDisk virtualDisk = null;
        List list = virtualHardware.getDevice();
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualDisk) || !string.equalsIgnoreCase(virtualDevice.getDeviceInfo().getLabel())) continue;
            virtualDisk = (VirtualDisk)virtualDevice;
            break;
        }
        return virtualDisk;
    }

    PropertyFilterSpec createPropertyFilterSpec(ManagedObjectReference managedObjectReference, String string) {
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(new Boolean(false));
        propertySpec.getPathSet().add(string);
        propertySpec.setType(managedObjectReference.getType());
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(managedObjectReference);
        objectSpec.setSkip(new Boolean(false));
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        return propertyFilterSpec;
    }

    TraversalSpec getVMTraversalSpec() {
        TraversalSpec traversalSpec = new TraversalSpec();
        traversalSpec.setName("vAppToVM");
        traversalSpec.setType("VirtualApp");
        traversalSpec.setPath("vm");
        TraversalSpec traversalSpec2 = new TraversalSpec();
        traversalSpec2.setName("vAppToVApp");
        traversalSpec2.setType("VirtualApp");
        traversalSpec2.setPath("resourcePool");
        SelectionSpec selectionSpec = new SelectionSpec();
        selectionSpec.setName("vAppToVApp");
        SelectionSpec selectionSpec2 = new SelectionSpec();
        selectionSpec2.setName("vAppToVM");
        ArrayList<SelectionSpec> arrayList = new ArrayList<SelectionSpec>();
        arrayList.add(selectionSpec);
        arrayList.add(selectionSpec2);
        traversalSpec2.getSelectSet().addAll(arrayList);
        SelectionSpec selectionSpec3 = new SelectionSpec();
        selectionSpec3.setName("VisitFolders");
        TraversalSpec traversalSpec3 = new TraversalSpec();
        traversalSpec3.setName("DataCenterToVMFolder");
        traversalSpec3.setType("Datacenter");
        traversalSpec3.setPath("vmFolder");
        traversalSpec3.setSkip(Boolean.valueOf(false));
        traversalSpec3.getSelectSet().add(selectionSpec3);
        TraversalSpec traversalSpec4 = new TraversalSpec();
        traversalSpec4.setName("VisitFolders");
        traversalSpec4.setType("Folder");
        traversalSpec4.setPath("childEntity");
        traversalSpec4.setSkip(Boolean.valueOf(false));
        ArrayList<Object> arrayList2 = new ArrayList<Object>();
        arrayList2.add(selectionSpec3);
        arrayList2.add(traversalSpec3);
        arrayList2.add(traversalSpec);
        arrayList2.add(traversalSpec2);
        traversalSpec4.getSelectSet().addAll(arrayList2);
        return traversalSpec4;
    }

    ManagedObjectReference getVMByVMname(String string) throws IllegalArgumentException {
        ManagedObjectReference managedObjectReference = null;
        TraversalSpec traversalSpec = this.getVMTraversalSpec();
        PropertySpec propertySpec = new PropertySpec();
        propertySpec.setAll(Boolean.FALSE);
        propertySpec.getPathSet().add("name");
        propertySpec.setType("VirtualMachine");
        ObjectSpec objectSpec = new ObjectSpec();
        objectSpec.setObj(this.rootFolderRef);
        objectSpec.setSkip(Boolean.TRUE);
        objectSpec.getSelectSet().add(traversalSpec);
        PropertyFilterSpec propertyFilterSpec = new PropertyFilterSpec();
        propertyFilterSpec.getPropSet().add(propertySpec);
        propertyFilterSpec.getObjectSet().add(objectSpec);
        ArrayList<PropertyFilterSpec> arrayList = new ArrayList<PropertyFilterSpec>(1);
        arrayList.add(propertyFilterSpec);
        List<ObjectContent> list = this.retrievePropertiesAllObjects(arrayList);
        if (list != null) {
            for (ObjectContent objectContent : list) {
                ManagedObjectReference managedObjectReference2 = objectContent.getObj();
                String string2 = null;
                List list2 = objectContent.getPropSet();
                if (list2 != null) {
                    for (DynamicProperty dynamicProperty : list2) {
                        string2 = (String)dynamicProperty.getVal();
                    }
                }
                if (string2 == null || !string2.equals(string)) continue;
                managedObjectReference = managedObjectReference2;
                break;
            }
        }
        if (managedObjectReference == null) {
            throw new IllegalArgumentException("VM not found.");
        }
        return managedObjectReference;
    }

    @Action
    public void run() {
        this.propCollectorRef = this.serviceContent.getPropertyCollector();
        this.rootFolderRef = this.serviceContent.getRootFolder();
        this.createDeltaDisk();
    }
}

