/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfManagedObjectReference;
import com.vmware.vim25.CustomizationFaultFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.MigrationFaultFaultMsg;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDisk;
import com.vmware.vim25.VirtualDiskFlatVer1BackingInfo;
import com.vmware.vim25.VirtualDiskFlatVer2BackingInfo;
import com.vmware.vim25.VirtualDiskRawDiskMappingVer1BackingInfo;
import com.vmware.vim25.VirtualDiskSparseVer1BackingInfo;
import com.vmware.vim25.VirtualDiskSparseVer2BackingInfo;
import com.vmware.vim25.VirtualHardware;
import com.vmware.vim25.VirtualMachineCloneSpec;
import com.vmware.vim25.VirtualMachineRelocateDiskMoveOptions;
import com.vmware.vim25.VirtualMachineRelocateSpec;
import com.vmware.vim25.VirtualMachineRelocateSpecDiskLocator;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;

@Sample(name="vm-linked-clone", description="This sample creates a linked clone from an existing snapshot\nEach independent disk needs a DiskLocator with\ndiskmovetype as moveAllDiskBackingsAndDisallowSharing\n")
public class VMLinkedClone
extends ConnectedVimServiceBase {
    String cloneName;
    String virtualMachineName;
    String snapshotName;

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    @Option(name="snapshotname", description="Name of the snaphot")
    public void setSnapshotName(String string) {
        this.snapshotName = string;
    }

    @Option(name="clonename", description="Name of the cloneName")
    public void setCloneName(String string) {
        this.cloneName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void createLinkedClone() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, CustomizationFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, MigrationFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.virtualMachineName, managedObjectReference);
        if (managedObjectReference2 != null) {
            ManagedObjectReference managedObjectReference3 = this.getSnapshotReference(managedObjectReference2, this.snapshotName);
            if (managedObjectReference3 != null) {
                ManagedObjectReference managedObjectReference4;
                Object object;
                ArrayList<Integer> arrayList = this.getIndependenetVirtualDiskKeys(managedObjectReference2);
                VirtualMachineRelocateSpec virtualMachineRelocateSpec = new VirtualMachineRelocateSpec();
                if (arrayList.size() > 0) {
                    object = ((ArrayOfManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"datastore"}).get("datastore")).getManagedObjectReference();
                    managedObjectReference4 = new ArrayList();
                    for (Integer n : arrayList) {
                        VirtualMachineRelocateSpecDiskLocator virtualMachineRelocateSpecDiskLocator = new VirtualMachineRelocateSpecDiskLocator();
                        virtualMachineRelocateSpecDiskLocator.setDatastore((ManagedObjectReference)object.get(0));
                        virtualMachineRelocateSpecDiskLocator.setDiskMoveType(VirtualMachineRelocateDiskMoveOptions.MOVE_ALL_DISK_BACKINGS_AND_DISALLOW_SHARING.value());
                        virtualMachineRelocateSpecDiskLocator.setDiskId(n.intValue());
                        managedObjectReference4.add(virtualMachineRelocateSpecDiskLocator);
                    }
                    virtualMachineRelocateSpec.setDiskMoveType(VirtualMachineRelocateDiskMoveOptions.CREATE_NEW_CHILD_DISK_BACKING.value());
                    virtualMachineRelocateSpec.getDisk().addAll(managedObjectReference4);
                } else {
                    virtualMachineRelocateSpec.setDiskMoveType(VirtualMachineRelocateDiskMoveOptions.CREATE_NEW_CHILD_DISK_BACKING.value());
                }
                object = new VirtualMachineCloneSpec();
                object.setPowerOn(false);
                object.setTemplate(false);
                object.setLocation(virtualMachineRelocateSpec);
                object.setSnapshot(managedObjectReference3);
                managedObjectReference4 = (ManagedObjectReference)this.getMOREFs.entityProps(managedObjectReference2, new String[]{"parent"}).get("parent");
                if (managedObjectReference4 == null) {
                    throw new RuntimeException("The selected VM is a part of vAPP. This sample only works with virtual machines that are not a part of any vAPP");
                }
                ManagedObjectReference managedObjectReference5 = this.vimPort.cloneVMTask(managedObjectReference2, managedObjectReference4, this.cloneName, (VirtualMachineCloneSpec)object);
                if (this.getTaskResultAfterDone(managedObjectReference5)) {
                    System.out.printf(" Cloning Successful", new Object[0]);
                } else {
                    System.out.printf(" Cloning Failure", new Object[0]);
                }
            } else {
                System.out.println("Snapshot " + this.snapshotName + " doesn't exist");
            }
        } else {
            System.out.println("Virtual Machine " + this.virtualMachineName + " doesn't exist");
        }
    }

    ArrayList<Integer> getIndependenetVirtualDiskKeys(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        VirtualHardware virtualHardware = (VirtualHardware)this.getMOREFs.entityProps(managedObjectReference, new String[]{"config.hardware"}).get("config.hardware");
        List list = virtualHardware.getDevice();
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualDisk)) continue;
            String string = "";
            if (virtualDevice.getBacking() instanceof VirtualDiskFlatVer1BackingInfo) {
                string = ((VirtualDiskFlatVer1BackingInfo)virtualDevice.getBacking()).getDiskMode();
            } else if (virtualDevice.getBacking() instanceof VirtualDiskFlatVer2BackingInfo) {
                string = ((VirtualDiskFlatVer2BackingInfo)virtualDevice.getBacking()).getDiskMode();
            } else if (virtualDevice.getBacking() instanceof VirtualDiskRawDiskMappingVer1BackingInfo) {
                string = ((VirtualDiskRawDiskMappingVer1BackingInfo)virtualDevice.getBacking()).getDiskMode();
            } else if (virtualDevice.getBacking() instanceof VirtualDiskSparseVer1BackingInfo) {
                string = ((VirtualDiskSparseVer1BackingInfo)virtualDevice.getBacking()).getDiskMode();
            } else if (virtualDevice.getBacking() instanceof VirtualDiskSparseVer2BackingInfo) {
                string = ((VirtualDiskSparseVer2BackingInfo)virtualDevice.getBacking()).getDiskMode();
            }
            if (string.indexOf("independent") == -1) continue;
            arrayList.add(virtualDevice.getKey());
        }
        return arrayList;
    }

    ManagedObjectReference getSnapshotReference(ManagedObjectReference managedObjectReference, String string) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        VirtualMachineSnapshotInfo virtualMachineSnapshotInfo = (VirtualMachineSnapshotInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"snapshot"}).get("snapshot");
        ManagedObjectReference managedObjectReference2 = null;
        if (virtualMachineSnapshotInfo != null) {
            List list;
            List list2 = list = virtualMachineSnapshotInfo.getRootSnapshotList();
            managedObjectReference2 = this.traverseSnapshotInTree(list2, string);
        }
        return managedObjectReference2;
    }

    ManagedObjectReference traverseSnapshotInTree(List<VirtualMachineSnapshotTree> list, String string) {
        ManagedObjectReference managedObjectReference = null;
        if (list == null) {
            return managedObjectReference;
        }
        for (int i = 0; i < list.size() && managedObjectReference == null; ++i) {
            VirtualMachineSnapshotTree virtualMachineSnapshotTree = list.get(i);
            if (string != null && virtualMachineSnapshotTree.getName().equals(string)) {
                managedObjectReference = virtualMachineSnapshotTree.getSnapshot();
                continue;
            }
            List list2 = virtualMachineSnapshotTree.getChildSnapshotList();
            managedObjectReference = this.traverseSnapshotInTree(list2, string);
        }
        return managedObjectReference;
    }

    @Action
    public void run() throws CustomizationFaultFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, MigrationFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        this.createLinkedClone();
    }
}

