/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.Description;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualCdrom;
import com.vmware.vim25.VirtualCdromAtapiBackingInfo;
import com.vmware.vim25.VirtualCdromIsoBackingInfo;
import com.vmware.vim25.VirtualCdromPassthroughBackingInfo;
import com.vmware.vim25.VirtualCdromRemoteAtapiBackingInfo;
import com.vmware.vim25.VirtualCdromRemotePassthroughBackingInfo;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceConnectInfo;
import com.vmware.vim25.VirtualIDEController;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@Sample(name="vm-manage-cd", description="This sample adds / removes CDROM to / from an existing VM\nThis sample lists information about a VMs CDROMs\nThis sample updates an existing CDROM a VM\n")
public class VMManageCD
extends ConnectedVimServiceBase {
    static final String[] operations = new String[]{"get", "add", "remove", "set"};
    private ManagedObjectReference vmRef;
    String virtualMachineName;
    String operation;
    String labelName;
    String connect;
    String isoPath;
    String deviceName;
    String remote;
    String startConnected;

    @Option(name="vmname", description="name of the virtual machine")
    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    @Option(name="operation", description="operation type - [get|add|remove|set]")
    public void setOperation(String string) {
        if (this.check(string, operations)) {
            this.operation = string;
        }
    }

    @Option(name="isopath", required=false, description="full datastore path to the iso file")
    public void setIsoPath(String string) {
        this.isoPath = string;
    }

    @Option(name="remote", required=false, description="Specify the device is a remote or client device or iso")
    public void setRemote(String string) {
        this.remote = string;
    }

    @Option(name="startconnected", required=false, description="virtual CD starts connected when VM powers on")
    public void setStartConnected(String string) {
        this.startConnected = string;
    }

    @Option(name="connect", required=false, description="virtual CD is connected after creation or update\nSet only if VM is powered on")
    public void setConnect(String string) {
        this.connect = string;
    }

    @Option(name="label", required=false, description="used to find the device.key value")
    public void setLabelName(String string) {
        this.labelName = string;
    }

    @Option(name="devicename", required=false, description="Specify the path to the CD on the VM's host")
    public void setDeviceName(String string) {
        this.deviceName = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    void doOperation() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        this.vmRef = this.getMOREFs.vmByVMname(this.virtualMachineName, managedObjectReference);
        if (this.vmRef == null) {
            System.out.println("Virtual Machine " + this.virtualMachineName + " not found.");
            return;
        }
        if (this.operation.equalsIgnoreCase("get")) {
            this.getInfo();
        } else if (this.operation.equalsIgnoreCase("add")) {
            this.addCdRom();
        }
        if (this.operation.equalsIgnoreCase("remove")) {
            this.removeCdRom();
        }
        if (this.operation.equalsIgnoreCase("set")) {
            this.setCdRom();
        }
    }

    void getInfo() throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        int n = 0;
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualCdrom)) continue;
            String string = virtualDevice.getDeviceInfo().getLabel();
            int n2 = virtualDevice.getKey();
            boolean bl = virtualDevice.getConnectable().isConnected();
            boolean bl2 = virtualDevice.getConnectable().isStartConnected();
            boolean bl3 = false;
            String string2 = "";
            String string3 = "";
            if (virtualDevice.getBacking() instanceof VirtualCdromRemoteAtapiBackingInfo) {
                bl3 = true;
                string2 = ((VirtualCdromRemoteAtapiBackingInfo)virtualDevice.getBacking()).getDeviceName();
            } else if (virtualDevice.getBacking() instanceof VirtualCdromRemotePassthroughBackingInfo) {
                bl3 = true;
                string2 = ((VirtualCdromRemotePassthroughBackingInfo)virtualDevice.getBacking()).getDeviceName();
            } else if (virtualDevice.getBacking() instanceof VirtualCdromAtapiBackingInfo) {
                string2 = ((VirtualCdromAtapiBackingInfo)virtualDevice.getBacking()).getDeviceName();
            } else if (virtualDevice.getBacking() instanceof VirtualCdromPassthroughBackingInfo) {
                string2 = ((VirtualCdromPassthroughBackingInfo)virtualDevice.getBacking()).getDeviceName();
            } else if (virtualDevice.getBacking() instanceof VirtualCdromIsoBackingInfo) {
                string3 = ((VirtualCdromIsoBackingInfo)virtualDevice.getBacking()).getFileName();
            }
            System.out.println("ISO Path                : " + string3);
            System.out.println("Device                  : " + string2);
            System.out.println("Remote                  : " + bl3);
            System.out.println("Connected               : " + bl);
            System.out.println("ConnectedAtPowerOn      : " + bl2);
            System.out.println("Id                      : VirtualMachine-" + this.vmRef.getValue() + "/" + n2);
            System.out.println("Name                    : CD/" + string);
            ++n;
        }
        if (n == 0) {
            System.out.println("No CdRom device attached to this VM.");
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void addCdRom() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualIDEController virtualIDEController;
        VirtualDevice virtualDevice2;
        Object object2;
        if (this.remote == null) {
            this.remote = "false";
        }
        if (this.startConnected == null) {
            this.startConnected = "false";
        }
        if (this.connect == null) {
            this.connect = "false";
        }
        int n = -1;
        int n2 = 0;
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (Object object2 : list) {
            hashMap.put(object2.getKey(), object2);
        }
        boolean bl = false;
        for (VirtualDevice virtualDevice2 : list) {
            if (!(virtualDevice2 instanceof VirtualIDEController)) continue;
            virtualIDEController = (VirtualIDEController)virtualDevice2;
            int[] nArray = new int[2];
            List list2 = virtualIDEController.getDevice();
            for (Integer n3 : list2) {
                if (((VirtualDevice)hashMap.get(n3)).getUnitNumber() == null) continue;
                nArray[((VirtualDevice)hashMap.get((Object)n3)).getUnitNumber().intValue()] = 1;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 1) continue;
                n = virtualIDEController.getKey();
                n2 = i;
                bl = true;
                break;
            }
            if (!bl) continue;
        }
        if (!bl) {
            throw new RuntimeException("The IDE controller on the vm has maxed out its capacity. Please add an additional IDE controller");
        }
        object2 = new VirtualCdrom();
        object2.setControllerKey(Integer.valueOf(n));
        object2.setUnitNumber(Integer.valueOf(n2));
        object2.setKey(-1);
        virtualDevice2 = new VirtualDeviceConnectInfo();
        if (this.connect != null) {
            virtualDevice2.setConnected(Boolean.valueOf(this.connect).booleanValue());
        }
        if (this.startConnected != null) {
            virtualDevice2.setStartConnected(Boolean.valueOf(this.startConnected).booleanValue());
        }
        object2.setConnectable((VirtualDeviceConnectInfo)virtualDevice2);
        if (this.deviceName == null && this.isoPath == null) {
            if (!this.remote.equalsIgnoreCase("true")) {
                System.out.println("For Local option, either specify ISOPath or Device Name");
                return;
            }
            virtualIDEController = new VirtualCdromRemotePassthroughBackingInfo();
            virtualIDEController.setExclusive(false);
            virtualIDEController.setDeviceName("");
            virtualIDEController.setUseAutoDetect(Boolean.valueOf(true));
            object2.setBacking((VirtualDeviceBackingInfo)virtualIDEController);
        } else if (this.deviceName != null) {
            if (this.remote.equalsIgnoreCase("true")) {
                System.out.println("For Device name option is only valid for Local CD Rom");
                return;
            }
            virtualIDEController = new VirtualCdromAtapiBackingInfo();
            virtualIDEController.setDeviceName(this.deviceName);
            object2.setBacking((VirtualDeviceBackingInfo)virtualIDEController);
        } else if (this.isoPath != null) {
            virtualIDEController = new VirtualCdromIsoBackingInfo();
            if (this.remote.equalsIgnoreCase("true")) {
                System.out.println("Iso path option is only valid for Local CD Rom");
                return;
            }
            virtualIDEController.setFileName(this.isoPath);
            object2.setBacking((VirtualDeviceBackingInfo)virtualIDEController);
        }
        virtualDeviceConfigSpec.setDevice((VirtualDevice)object2);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        arrayList.add(virtualDeviceConfigSpec);
        virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        virtualIDEController = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone((ManagedObjectReference)virtualIDEController)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualMachineName, this.operation);
            return;
        }
        System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualMachineName, this.operation);
    }

    void removeCdRom() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        Description description;
        Object object3;
        if (this.labelName == null) {
            System.out.println("Option label is required for remove option");
            return;
        }
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        Object object2 = null;
        for (Object object3 : list) {
            if (!(object3 instanceof VirtualCdrom) || (description = object3.getDeviceInfo()) == null || !description.getLabel().equalsIgnoreCase(this.labelName)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            System.out.println("Specified Device Not Found");
            return;
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        object3 = new ArrayList();
        description = new VirtualDeviceConfigSpec();
        description.setDevice(object2);
        description.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
        object3.add(description);
        virtualMachineConfigSpec.getDeviceChange().addAll(object3);
        ManagedObjectReference managedObjectReference = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone(managedObjectReference)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualMachineName, this.operation);
        } else {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualMachineName, this.operation);
        }
    }

    void setCdRom() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg {
        VirtualCdromIsoBackingInfo virtualCdromIsoBackingInfo;
        Description description;
        Object object3;
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        Object object2 = null;
        for (Object object3 : list) {
            if (!(object3 instanceof VirtualCdrom) || (description = object3.getDeviceInfo()) == null || !description.getLabel().equalsIgnoreCase(this.labelName)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            System.out.println("Specified Device Not Found");
            return;
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        object3 = new ArrayList();
        description = new VirtualDeviceConfigSpec();
        VirtualDeviceConnectInfo virtualDeviceConnectInfo = new VirtualDeviceConnectInfo();
        if (this.connect != null) {
            virtualDeviceConnectInfo.setConnected(Boolean.valueOf(this.connect).booleanValue());
        }
        if (this.startConnected != null) {
            virtualDeviceConnectInfo.setStartConnected(Boolean.valueOf(this.startConnected).booleanValue());
        }
        object2.setConnectable(virtualDeviceConnectInfo);
        if (this.deviceName == null && this.isoPath == null) {
            if (this.remote.equalsIgnoreCase("true")) {
                virtualCdromIsoBackingInfo = new VirtualCdromRemotePassthroughBackingInfo();
                virtualCdromIsoBackingInfo.setExclusive(false);
                virtualCdromIsoBackingInfo.setDeviceName("");
                virtualCdromIsoBackingInfo.setUseAutoDetect(Boolean.valueOf(true));
                object2.setBacking((VirtualDeviceBackingInfo)virtualCdromIsoBackingInfo);
            }
        } else if (this.deviceName != null) {
            if (this.remote.equalsIgnoreCase("true")) {
                System.out.println("For Device name option is only valid for Local CD Rom");
                return;
            }
            virtualCdromIsoBackingInfo = new VirtualCdromAtapiBackingInfo();
            virtualCdromIsoBackingInfo.setDeviceName(this.deviceName);
            object2.setBacking((VirtualDeviceBackingInfo)virtualCdromIsoBackingInfo);
        } else if (this.isoPath != null) {
            virtualCdromIsoBackingInfo = new VirtualCdromIsoBackingInfo();
            if (this.remote.equalsIgnoreCase("true")) {
                System.out.println("Iso path option is only valid for Local CD Rom");
                return;
            }
            virtualCdromIsoBackingInfo.setFileName(this.isoPath);
            object2.setBacking((VirtualDeviceBackingInfo)virtualCdromIsoBackingInfo);
        }
        description.setDevice((VirtualDevice)object2);
        description.setOperation(VirtualDeviceConfigSpecOperation.EDIT);
        object3.add(description);
        virtualMachineConfigSpec.getDeviceChange().addAll(object3);
        virtualCdromIsoBackingInfo = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone((ManagedObjectReference)virtualCdromIsoBackingInfo)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualMachineName, this.operation);
        } else {
            System.out.printf("Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualMachineName, this.operation);
        }
    }

    boolean check(String string, String[] stringArray) {
        boolean bl = false;
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg {
        this.doOperation();
    }
}

