/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.ArrayOfVirtualDevice;
import com.vmware.vim25.ConcurrentAccessFaultMsg;
import com.vmware.vim25.Description;
import com.vmware.vim25.DuplicateNameFaultMsg;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidDatastoreFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualDevice;
import com.vmware.vim25.VirtualDeviceBackingInfo;
import com.vmware.vim25.VirtualDeviceConfigSpec;
import com.vmware.vim25.VirtualDeviceConfigSpecOperation;
import com.vmware.vim25.VirtualDeviceConnectInfo;
import com.vmware.vim25.VirtualFloppy;
import com.vmware.vim25.VirtualFloppyDeviceBackingInfo;
import com.vmware.vim25.VirtualFloppyImageBackingInfo;
import com.vmware.vim25.VirtualFloppyRemoteDeviceBackingInfo;
import com.vmware.vim25.VirtualMachineConfigSpec;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.ArrayList;
import java.util.List;

@Sample(name="vm-manage-floppy", description="This sample adds / removes floppy to / from an existing VM\nThis sample lists information about a VMs Floppies\nThis sample updates an existing floppy drive on a VM\n")
public class VMManageFloppy
extends ConnectedVimServiceBase {
    ManagedObjectReference vmRef;
    String virtualmachinename;
    String operation;
    String imagePath;
    String remote;
    String startConnected;
    String device;
    String label;
    String setConnect;

    @Option(name="vmname", description="name of the virtual machine")
    public void setVirtualmachinename(String string) {
        this.virtualmachinename = string;
    }

    @Option(name="operation", description="operation type - [get|add|remove|set]")
    public void setOperation(String string) {
        this.operation = string;
    }

    @Option(name="imgpath", required=false, description="path of image file")
    public void setImagePath(String string) {
        this.imagePath = string;
    }

    @Option(name="remote", required=false, description="device is a remote or client device or iso")
    public void setRemote(String string) {
        this.remote = string;
    }

    @Option(name="startconnected", required=false, description="virtual floppy starts connected on VM poweron")
    public void setStartConnected(String string) {
        this.startConnected = string;
    }

    @Option(name="connect", required=false, description="virtual floppy is connected. Set only if the VM is powered on")
    public void setSetConnect(String string) {
        this.setConnect = string;
    }

    @Option(name="lable", required=false, description="used to find the device.key value")
    public void setLabel(String string) {
        this.label = string;
    }

    @Option(name="device", required=false, description="path to the floppy on the VM's host")
    public void setDevice(String string) {
        this.device = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    boolean validateTheInput() {
        boolean bl = true;
        if (!(this.operation == null || this.operation.equalsIgnoreCase("add") || this.operation.equalsIgnoreCase("get") || this.operation.equalsIgnoreCase("remove") || this.operation.equalsIgnoreCase("set"))) {
            System.out.println("Invalid option for operation");
            System.out.println("Valid Options : get | remove | add | set");
            bl = false;
        }
        if (this.setConnect != null && !this.setConnect.equalsIgnoreCase("true") && !this.setConnect.equalsIgnoreCase("false")) {
            System.out.println("Invalid option for connect");
            System.out.println("Valid Options : true | false");
            bl = false;
        }
        if (this.startConnected != null && !this.startConnected.equalsIgnoreCase("true") && !this.startConnected.equalsIgnoreCase("false")) {
            System.out.println("Invalid option for startConnected");
            System.out.println("Valid Options : true | false");
            bl = false;
        }
        if (this.remote != null && !this.remote.equalsIgnoreCase("true") && !this.remote.equalsIgnoreCase("false")) {
            System.out.println("Invalid option for remote");
            System.out.println("Valid Options : true | false");
            bl = false;
        }
        return bl;
    }

    void doOperation() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg {
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        this.vmRef = this.getMOREFs.vmByVMname(this.virtualmachinename, managedObjectReference);
        if (this.vmRef == null) {
            System.out.println("Virtual Machine " + this.virtualmachinename + " not found.");
            return;
        }
        if (this.operation.equalsIgnoreCase("get")) {
            this.getInfo();
        } else if (this.operation.equalsIgnoreCase("add")) {
            this.addFloppy();
        }
        if (this.operation.equalsIgnoreCase("remove")) {
            this.removeFloppy();
        }
        if (this.operation.equalsIgnoreCase("set")) {
            this.setFloppy();
        }
    }

    void getInfo() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        int n = 0;
        for (VirtualDevice virtualDevice : list) {
            if (!(virtualDevice instanceof VirtualFloppy)) continue;
            String string = virtualDevice.getDeviceInfo().getLabel();
            int n2 = virtualDevice.getKey();
            boolean bl = virtualDevice.getConnectable().isConnected();
            boolean bl2 = virtualDevice.getConnectable().isStartConnected();
            boolean bl3 = false;
            String string2 = "";
            String string3 = "";
            if (virtualDevice.getBacking() instanceof VirtualFloppyRemoteDeviceBackingInfo) {
                bl3 = true;
                string2 = ((VirtualFloppyRemoteDeviceBackingInfo)virtualDevice.getBacking()).getDeviceName();
            }
            if (virtualDevice.getBacking() instanceof VirtualFloppyDeviceBackingInfo) {
                string2 = ((VirtualFloppyDeviceBackingInfo)virtualDevice.getBacking()).getDeviceName();
            }
            if (virtualDevice.getBacking() instanceof VirtualFloppyImageBackingInfo) {
                string3 = ((VirtualFloppyImageBackingInfo)virtualDevice.getBacking()).getFileName();
            }
            System.out.println("Image Path              : " + string3);
            System.out.println("Device                  : " + string2);
            System.out.println("Remote                  : " + bl3);
            System.out.println("Connected               : " + bl);
            System.out.println("ConnectedAtPowerOn      : " + bl2);
            System.out.println("Id                      : VirtualMachine-" + this.vmRef.getValue() + "/" + n2);
            System.out.println("Name                    : Floppy/" + string);
            System.out.println("---------------------------------------------");
            ++n;
        }
        if (n == 0) {
            System.out.println("No Floppy device attached to this VM.");
        }
    }

    void addFloppy() throws ConcurrentAccessFaultMsg, DuplicateNameFaultMsg, FileFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidNameFaultMsg, InvalidStateFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualFloppyRemoteDeviceBackingInfo virtualFloppyRemoteDeviceBackingInfo;
        if (this.remote == null) {
            this.remote = "false";
        }
        if (this.startConnected == null) {
            this.startConnected = "false";
        }
        if (this.setConnect == null) {
            this.setConnect = "false";
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        VirtualFloppy virtualFloppy = new VirtualFloppy();
        virtualFloppy.setKey(-1);
        VirtualDeviceConnectInfo virtualDeviceConnectInfo = new VirtualDeviceConnectInfo();
        if (this.setConnect != null) {
            virtualDeviceConnectInfo.setConnected(Boolean.valueOf(this.setConnect).booleanValue());
        }
        if (this.startConnected != null) {
            virtualDeviceConnectInfo.setStartConnected(Boolean.valueOf(this.startConnected).booleanValue());
        }
        virtualFloppy.setConnectable(virtualDeviceConnectInfo);
        if (this.remote.equalsIgnoreCase("true")) {
            virtualFloppyRemoteDeviceBackingInfo = new VirtualFloppyRemoteDeviceBackingInfo();
            virtualFloppyRemoteDeviceBackingInfo.setDeviceName("/dev/fd0");
            virtualFloppy.setBacking((VirtualDeviceBackingInfo)virtualFloppyRemoteDeviceBackingInfo);
        } else if (this.imagePath != null) {
            virtualFloppyRemoteDeviceBackingInfo = new VirtualFloppyImageBackingInfo();
            virtualFloppyRemoteDeviceBackingInfo.setFileName(this.imagePath);
            virtualFloppy.setBacking((VirtualDeviceBackingInfo)virtualFloppyRemoteDeviceBackingInfo);
        } else if (this.device != null) {
            virtualFloppyRemoteDeviceBackingInfo = new VirtualFloppyDeviceBackingInfo();
            virtualFloppyRemoteDeviceBackingInfo.setDeviceName(this.device);
            virtualFloppy.setBacking((VirtualDeviceBackingInfo)virtualFloppyRemoteDeviceBackingInfo);
        } else {
            throw new IllegalArgumentException("Plese specify the --imgpath or --device option if --remote is either omitted or set to false while adding a floppy\n");
        }
        virtualDeviceConfigSpec.setDevice((VirtualDevice)virtualFloppy);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.ADD);
        arrayList.add(virtualDeviceConfigSpec);
        virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        virtualFloppyRemoteDeviceBackingInfo = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone((ManagedObjectReference)virtualFloppyRemoteDeviceBackingInfo)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualmachinename, this.operation);
        } else {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualmachinename, this.operation);
        }
    }

    void removeFloppy() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg {
        Description description;
        Object object3;
        if (this.label == null) {
            System.out.println("Option label is required for remove option");
            return;
        }
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        Object object2 = null;
        for (Object object3 : list) {
            if (!(object3 instanceof VirtualFloppy) || (description = object3.getDeviceInfo()) == null || !description.getLabel().equalsIgnoreCase(this.label)) continue;
            object2 = object3;
            break;
        }
        if (object2 == null) {
            System.out.println("Specified Device Not Found");
            return;
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        object3 = new ArrayList();
        description = new VirtualDeviceConfigSpec();
        description.setDevice(object2);
        description.setOperation(VirtualDeviceConfigSpecOperation.REMOVE);
        object3.add(description);
        virtualMachineConfigSpec.getDeviceChange().addAll(object3);
        ManagedObjectReference managedObjectReference = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone(managedObjectReference)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualmachinename, this.operation);
        } else {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualmachinename, this.operation);
        }
    }

    void setFloppy() throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, DuplicateNameFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, InvalidDatastoreFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidNameFaultMsg, InvalidCollectorVersionFaultMsg {
        VirtualDevice virtualDevice3;
        if (this.label == null) {
            System.out.println("Option label is required for set option");
            return;
        }
        if (this.remote == null) {
            this.remote = "false";
        }
        if (this.startConnected == null) {
            this.startConnected = "false";
        }
        if (this.setConnect == null) {
            this.setConnect = "false";
        }
        VirtualMachineConfigSpec virtualMachineConfigSpec = new VirtualMachineConfigSpec();
        ArrayList<VirtualDeviceConfigSpec> arrayList = new ArrayList<VirtualDeviceConfigSpec>();
        VirtualDeviceConfigSpec virtualDeviceConfigSpec = new VirtualDeviceConfigSpec();
        List list = ((ArrayOfVirtualDevice)this.getMOREFs.entityProps(this.vmRef, new String[]{"config.hardware.device"}).get("config.hardware.device")).getVirtualDevice();
        VirtualDevice virtualDevice2 = null;
        for (VirtualDevice virtualDevice3 : list) {
            Description description;
            if (!(virtualDevice3 instanceof VirtualFloppy) || (description = virtualDevice3.getDeviceInfo()) == null || !description.getLabel().equalsIgnoreCase(this.label)) continue;
            virtualDevice2 = virtualDevice3;
            break;
        }
        if (virtualDevice2 == null) {
            System.out.println("Specified Device Not Found");
            return;
        }
        VirtualDeviceConnectInfo virtualDeviceConnectInfo = new VirtualDeviceConnectInfo();
        if (this.setConnect != null) {
            virtualDeviceConnectInfo.setConnected(Boolean.valueOf(this.setConnect).booleanValue());
        }
        if (this.startConnected != null) {
            virtualDeviceConnectInfo.setStartConnected(Boolean.valueOf(this.startConnected).booleanValue());
        }
        virtualDevice2.setConnectable(virtualDeviceConnectInfo);
        if (this.remote.equalsIgnoreCase("true")) {
            virtualDevice3 = new VirtualFloppyRemoteDeviceBackingInfo();
            virtualDevice3.setDeviceName("/dev/fd0");
            virtualDevice2.setBacking((VirtualDeviceBackingInfo)virtualDevice3);
        } else if (this.imagePath != null) {
            virtualDevice3 = new VirtualFloppyImageBackingInfo();
            virtualDevice3.setFileName(this.imagePath);
            virtualDevice2.setBacking((VirtualDeviceBackingInfo)virtualDevice3);
        } else if (this.device != null) {
            virtualDevice3 = new VirtualFloppyDeviceBackingInfo();
            virtualDevice3.setDeviceName(this.device);
            virtualDevice2.setBacking((VirtualDeviceBackingInfo)virtualDevice3);
        }
        virtualDeviceConfigSpec.setDevice(virtualDevice2);
        virtualDeviceConfigSpec.setOperation(VirtualDeviceConfigSpecOperation.EDIT);
        arrayList.add(virtualDeviceConfigSpec);
        virtualMachineConfigSpec.getDeviceChange().addAll(arrayList);
        virtualDevice3 = this.vimPort.reconfigVMTask(this.vmRef, virtualMachineConfigSpec);
        if (this.getTaskResultAfterDone((ManagedObjectReference)virtualDevice3)) {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Successful on %s%n", this.virtualmachinename, this.operation);
        } else {
            System.out.printf(" Reconfiguring the Virtual Machine  - [ %s ] Failure on %s%n", this.virtualmachinename, this.operation);
        }
    }

    @Action
    public void run() throws DuplicateNameFaultMsg, RuntimeFaultFaultMsg, TaskInProgressFaultMsg, InsufficientResourcesFaultFaultMsg, VmConfigFaultFaultMsg, InvalidDatastoreFaultMsg, InvalidPropertyFaultMsg, FileFaultFaultMsg, ConcurrentAccessFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg {
        if (this.validateTheInput()) {
            this.doOperation();
        }
    }
}

