/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vm;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Option;
import com.vmware.common.annotations.Sample;
import com.vmware.connection.ConnectedVimServiceBase;
import com.vmware.vim25.FileFaultFaultMsg;
import com.vmware.vim25.InsufficientResourcesFaultFaultMsg;
import com.vmware.vim25.InvalidCollectorVersionFaultMsg;
import com.vmware.vim25.InvalidNameFaultMsg;
import com.vmware.vim25.InvalidPropertyFaultMsg;
import com.vmware.vim25.InvalidStateFaultMsg;
import com.vmware.vim25.LocalizedMethodFault;
import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import com.vmware.vim25.SnapshotFaultFaultMsg;
import com.vmware.vim25.TaskInProgressFaultMsg;
import com.vmware.vim25.TaskInfoState;
import com.vmware.vim25.VirtualMachineSnapshotInfo;
import com.vmware.vim25.VirtualMachineSnapshotTree;
import com.vmware.vim25.VmConfigFaultFaultMsg;
import java.util.List;

@Sample(name="vm-snapshot", description="This sample demonstrates VM snapshot operations")
public class VMSnapshot
extends ConnectedVimServiceBase {
    String virtualMachineName;
    String operation;
    String snapshotname;
    String description;
    String removechild;

    @Option(name="vmname", description="Name of the virtual machine")
    public void setVirtualMachineName(String string) {
        this.virtualMachineName = string;
    }

    @Option(name="operation", description="operation type - [list|create|remove|revert]")
    public void setOperation(String string) {
        this.operation = string;
    }

    @Option(name="snapshotname", required=false, description="Name of the snapshot")
    public void setSnapshotname(String string) {
        this.snapshotname = string;
    }

    @Option(name="description", required=false, description="description of the sanpshot")
    public void setDescription(String string) {
        this.description = string;
    }

    @Option(name="removechild", required=false, description="remove snapshot children - [1 | 0]")
    public void setRemovechild(String string) {
        this.removechild = string;
    }

    boolean getTaskResultAfterDone(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg, InvalidCollectorVersionFaultMsg {
        boolean bl = false;
        Object[] objectArray = this.waitForValues.wait(managedObjectReference, new String[]{"info.state", "info.error"}, new String[]{"state"}, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
        if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
            bl = true;
        }
        if (objectArray[1] instanceof LocalizedMethodFault) {
            throw new RuntimeException(((LocalizedMethodFault)objectArray[1]).getLocalizedMessage());
        }
        return bl;
    }

    boolean createSnapshot(ManagedObjectReference managedObjectReference) throws FileFaultFaultMsg, InvalidNameFaultMsg, InvalidStateFaultMsg, RuntimeFaultFaultMsg, SnapshotFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference2 = this.vimPort.createSnapshotTask(managedObjectReference, this.snapshotname, this.description, false, false);
        if (this.getTaskResultAfterDone(managedObjectReference2)) {
            System.out.printf(" Creating Snapshot - [ %s ] Successful %n", this.snapshotname);
            return true;
        }
        System.out.printf(" Creating Snapshot - [ %s ] Failure %n", this.snapshotname);
        return false;
    }

    boolean listSnapshot(ManagedObjectReference managedObjectReference) throws InvalidPropertyFaultMsg, RuntimeFaultFaultMsg {
        VirtualMachineSnapshotInfo virtualMachineSnapshotInfo = (VirtualMachineSnapshotInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"snapshot"}).get("snapshot");
        if (virtualMachineSnapshotInfo == null) {
            System.out.println("No Snapshots found");
        } else {
            List list = virtualMachineSnapshotInfo.getRootSnapshotList();
            this.traverseSnapshotInTree(list, null, true);
        }
        return true;
    }

    boolean revertSnapshot(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, VmConfigFaultFaultMsg, InsufficientResourcesFaultFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference2 = this.getSnapshotReference(managedObjectReference, this.virtualMachineName, this.snapshotname);
        if (managedObjectReference2 != null) {
            ManagedObjectReference managedObjectReference3 = this.vimPort.revertToSnapshotTask(managedObjectReference2, null, Boolean.valueOf(true));
            if (this.getTaskResultAfterDone(managedObjectReference3)) {
                System.out.printf(" Reverting Snapshot - [ %s ] Successful %n", this.snapshotname);
                return true;
            }
            System.out.printf(" Reverting Snapshot - [ %s ] Failure %n", this.snapshotname);
            return false;
        }
        System.out.println("Snapshot not found");
        return false;
    }

    boolean removeAllSnapshot(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, TaskInProgressFaultMsg, SnapshotFaultFaultMsg, InvalidStateFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg {
        ManagedObjectReference managedObjectReference2 = this.vimPort.removeAllSnapshotsTask(managedObjectReference, Boolean.valueOf(true));
        if (managedObjectReference2 != null) {
            String[] stringArray = new String[]{"info.state", "info.error", "info.progress"};
            String[] stringArray2 = new String[]{"state"};
            Object[] objectArray = this.waitForValues.wait(managedObjectReference2, stringArray, stringArray2, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
            if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
                System.out.printf(" Removing All Snapshots on - [ %s ] Successful %n", this.virtualMachineName);
                return true;
            }
            System.out.printf(" Removing All Snapshots on - [ %s ] Failure %n", this.virtualMachineName);
            return false;
        }
        return false;
    }

    boolean removeSnapshot(ManagedObjectReference managedObjectReference) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg, InvalidCollectorVersionFaultMsg, TaskInProgressFaultMsg {
        ManagedObjectReference managedObjectReference2;
        int n = Integer.parseInt(this.removechild);
        boolean bl = true;
        if (n == 0) {
            bl = false;
        }
        if ((managedObjectReference2 = this.getSnapshotReference(managedObjectReference, this.virtualMachineName, this.snapshotname)) != null) {
            ManagedObjectReference managedObjectReference3 = this.vimPort.removeSnapshotTask(managedObjectReference2, bl, Boolean.valueOf(true));
            if (managedObjectReference3 != null) {
                String[] stringArray = new String[]{"info.state", "info.error", "info.progress"};
                String[] stringArray2 = new String[]{"state"};
                Object[] objectArray = this.waitForValues.wait(managedObjectReference3, stringArray, stringArray2, new Object[][]{{TaskInfoState.SUCCESS, TaskInfoState.ERROR}});
                if (objectArray[0].equals(TaskInfoState.SUCCESS)) {
                    System.out.printf(" Removing Snapshot - [ %s ] Successful %n", this.snapshotname);
                    return true;
                }
                System.out.printf(" Removing Snapshot - [ %s ] Failure %n", this.snapshotname);
                return false;
            }
        } else {
            System.out.println("Snapshot not found");
        }
        return false;
    }

    ManagedObjectReference traverseSnapshotInTree(List<VirtualMachineSnapshotTree> list, String string, boolean bl) {
        ManagedObjectReference managedObjectReference = null;
        if (list == null) {
            return managedObjectReference;
        }
        for (VirtualMachineSnapshotTree virtualMachineSnapshotTree : list) {
            List list2;
            if (bl) {
                System.out.println("Snapshot Name : " + virtualMachineSnapshotTree.getName());
            }
            if (string != null && virtualMachineSnapshotTree.getName().equalsIgnoreCase(string)) {
                return virtualMachineSnapshotTree.getSnapshot();
            }
            List list3 = list2 = virtualMachineSnapshotTree.getChildSnapshotList();
            managedObjectReference = this.traverseSnapshotInTree(list3, string, bl);
        }
        return managedObjectReference;
    }

    ManagedObjectReference getSnapshotReference(ManagedObjectReference managedObjectReference, String string, String string2) throws RuntimeFaultFaultMsg, InvalidPropertyFaultMsg {
        VirtualMachineSnapshotInfo virtualMachineSnapshotInfo = (VirtualMachineSnapshotInfo)this.getMOREFs.entityProps(managedObjectReference, new String[]{"snapshot"}).get("snapshot");
        ManagedObjectReference managedObjectReference2 = null;
        if (virtualMachineSnapshotInfo != null) {
            List list = virtualMachineSnapshotInfo.getRootSnapshotList();
            managedObjectReference2 = this.traverseSnapshotInTree(list, string2, false);
            if (managedObjectReference2 == null) {
                System.out.println("No Snapshot named : " + string2 + " found for VirtualMachine : " + string);
            }
        } else {
            System.out.println("No Snapshots found for VirtualMachine : " + string);
        }
        return managedObjectReference2;
    }

    boolean isOptionSet(String string) {
        return string != null;
    }

    boolean verifyInputArguments() {
        boolean bl = true;
        String string = this.operation;
        if (!(!string.equalsIgnoreCase("create") || this.isOptionSet(this.snapshotname) && this.isOptionSet(this.description))) {
            System.out.println("For Create operation SnapshotName and Description are the Mandatory options");
            bl = false;
        }
        if (string.equalsIgnoreCase("remove")) {
            if (!this.isOptionSet(this.snapshotname) || !this.isOptionSet(this.removechild)) {
                System.out.println("For Remove operation Snapshotname and removechild are the Mandatory option");
                bl = false;
            } else {
                int n = Integer.parseInt(this.removechild);
                if (n != 0 && n != 1) {
                    System.out.println("Value of removechild parameter must be either 0 or 1");
                    bl = false;
                }
            }
        }
        if (string.equalsIgnoreCase("revert") && !this.isOptionSet(this.snapshotname)) {
            System.out.println("For Revert operation SnapshotName is the Mandatory option");
            bl = false;
        }
        return bl;
    }

    @Action
    public void run() throws InvalidPropertyFaultMsg, TaskInProgressFaultMsg, SnapshotFaultFaultMsg, VmConfigFaultFaultMsg, FileFaultFaultMsg, InvalidStateFaultMsg, InvalidCollectorVersionFaultMsg, InvalidNameFaultMsg, RuntimeFaultFaultMsg, InsufficientResourcesFaultFaultMsg {
        boolean bl = false;
        bl = this.verifyInputArguments();
        if (!bl) {
            return;
        }
        ManagedObjectReference managedObjectReference = this.connection.getServiceContent().getPropertyCollector();
        ManagedObjectReference managedObjectReference2 = this.getMOREFs.vmByVMname(this.virtualMachineName, managedObjectReference);
        if (managedObjectReference2 != null) {
            boolean bl2 = false;
            if (this.operation.equalsIgnoreCase("create")) {
                bl2 = this.createSnapshot(managedObjectReference2);
            } else if (this.operation.equalsIgnoreCase("list")) {
                bl2 = this.listSnapshot(managedObjectReference2);
            } else if (this.operation.equalsIgnoreCase("revert")) {
                bl2 = this.revertSnapshot(managedObjectReference2);
            } else if (this.operation.equalsIgnoreCase("removeall")) {
                bl2 = this.removeAllSnapshot(managedObjectReference2);
            } else if (this.operation.equalsIgnoreCase("remove")) {
                bl2 = this.removeSnapshot(managedObjectReference2);
            } else {
                System.out.println("Invalid operation [create|list|revert|removeall|remove]");
            }
            if (bl2) {
                System.out.println("Operation " + this.operation + "snapshot completed sucessfully");
            }
        } else {
            System.out.println("Virtual Machine " + this.virtualMachineName + " not found.");
            return;
        }
    }
}

