/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.parameters;

import com.vmware.common.samples.parameters.ComplexOptionReference;
import com.vmware.common.samples.parameters.ComplexSystemPropertyReference;
import com.vmware.common.samples.parameters.OptionReference;
import com.vmware.common.samples.parameters.SystemPropertyReference;
import java.lang.reflect.Method;
import java.util.LinkedHashSet;
import java.util.Set;

public class Options {
    public final Class<?> sample;
    public final Set<OptionReference> list;
    public final Set<SystemPropertyReference> systemProperties = new LinkedHashSet<SystemPropertyReference>();

    public Options(Class<?> sampleClass) {
        this.list = new LinkedHashSet<OptionReference>();
        this.sample = sampleClass;
    }

    public int size() {
        return this.list.size();
    }

    public String usage() {
        return "Expected " + this.parameterList() + " arguments.";
    }

    public String parameterList() {
        StringBuffer sb = new StringBuffer();
        for (OptionReference param : this.list) {
            this.optionSwitch(sb, param);
            sb.append(" <");
            sb.append(param.toString());
            sb.append(">");
            sb.append(" ");
        }
        return sb.toString();
    }

    private void optionSwitch(StringBuffer sb, OptionReference param) {
        sb.append("--");
        sb.append(param.toString().toLowerCase());
    }

    public Options option(String option, boolean required, boolean parameter, String description, Method method) {
        this.list.add(new OptionReference(option, required, parameter, description, method));
        return this;
    }

    public Options option(String option, String systemProperty, boolean required, boolean parameter, String description, Method method) {
        this.list.add(new OptionReference(option, systemProperty, required, parameter, description, method));
        return this;
    }

    public Options complex(String option, String property, Class<?> type, String systemProperty, boolean required, boolean parameter, String description, Method method, Method submethod) {
        this.list.add(new ComplexOptionReference(option, property, type, systemProperty, required, parameter, description, method, submethod));
        return this;
    }

    public Options systemProperty(String property, String defaultValue, boolean required, String description, Method method) {
        this.systemProperties.add(new SystemPropertyReference(property, defaultValue, required, description, method));
        return this;
    }

    public Options complexSystemProperties(String field, String property, String defaultValue, Boolean required, String description, Method method, Method setter, Class<?> type) {
        this.systemProperties.add(new ComplexSystemPropertyReference(field, property, defaultValue, required, description, method, setter, type));
        return this;
    }

    public Class<?> getSampleClass() {
        return this.sample;
    }
}

