/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.reflection;

import com.vmware.common.Main;
import com.vmware.common.samples.reflection.ClassScanner;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;

public class DirectoryClassScanner
implements ClassScanner {
    private final String classFileSuffix;

    public DirectoryClassScanner(String classFileSuffix) {
        this.classFileSuffix = classFileSuffix;
    }

    @Override
    public Collection<String> scan(URL url) {
        HashSet<String> classNames = new HashSet<String>();
        Collection<String> fileNames = this.search(DirectoryClassScanner.file(url), this.classFileSuffix);
        for (String fileName : fileNames) {
            classNames.add(fileName);
        }
        return classNames;
    }

    public static File file(URL url) {
        File root = null;
        try {
            root = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            throw new Main.SampleIllegalArgumentException(e);
        }
        return root;
    }

    private Collection<String> search(File root, String suffix) {
        LinkedList<String> names = new LinkedList<String>();
        LinkedList<File> dirs = new LinkedList<File>();
        dirs.push(root);
        String basePath = root.getAbsolutePath();
        int trimBasePath = basePath.length() + 1;
        while (!dirs.isEmpty()) {
            File dir = (File)dirs.pop();
            for (File file : dir.listFiles()) {
                if (file.isDirectory()) {
                    dirs.push(file);
                    continue;
                }
                String name = file.getAbsolutePath().substring(trimBasePath);
                if (!name.endsWith(this.classFileSuffix)) continue;
                names.push(name.substring(0, name.length() - this.classFileSuffix.length()).replace(File.separator, "."));
            }
        }
        return names;
    }
}

