/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.common.samples.reflection;

import com.vmware.common.samples.reflection.SampleAnnotationException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;

public class MethodFinder {
    public Method[] find(Class<?> clazz, Class<? extends Annotation> annotation) {
        List<Method> methods = this.getMethods(clazz, annotation);
        return methods.toArray(new Method[methods.size()]);
    }

    private List<Method> getMethods(Class<?> clazz, Class<? extends Annotation> annotation) {
        LinkedList<Method> methods = new LinkedList<Method>();
        if (clazz == null) {
            return methods;
        }
        if (!Object.class.equals(clazz) && clazz.getSuperclass() != null) {
            methods.addAll(this.getMethods(clazz.getSuperclass(), annotation));
        }
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(annotation)) continue;
            if (Modifier.isPublic(method.getModifiers())) {
                methods.add(method);
                continue;
            }
            throw new SampleAnnotationException(clazz, method, annotation);
        }
        return methods;
    }
}

