/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import javax.cim.CIMClassProperty;
import javax.cim.CIMElement;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import org.sblim.cimclient.internal.cim.CIMElementSorter;
import org.sblim.cimclient.internal.cim.CIMQualifiedElementInterfaceImpl;
import org.sblim.cimclient.internal.util.MOF;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMClass
extends CIMElement
implements CIMQualifiedElementInterface,
CIMNamedElementInterface {
    private static final long serialVersionUID = -5634561913210025100L;
    private CIMQualifiedElementInterfaceImpl iQualiImpl;
    private CIMObjectPath iObjPath;
    private String iSuperClass;
    private CIMClassProperty<?>[] iProps;
    private CIMMethod<?>[] iMethods;
    private boolean iIsKeyed;
    private boolean iIsAssoc;

    public CIMClass(CIMObjectPath pPath, String pSuperClass, CIMQualifier<?>[] pQualifiers, CIMClassProperty<?>[] pProps, CIMMethod<?>[] pMethods, boolean pIsAssociation, boolean pIsKeyed) {
        super(pPath.getObjectName());
        this.iObjPath = pPath;
        this.iSuperClass = pSuperClass;
        this.iQualiImpl = new CIMQualifiedElementInterfaceImpl(pQualifiers, false, false, pIsAssociation);
        this.iProps = (CIMClassProperty[])CIMElementSorter.sort(pProps);
        this.iMethods = (CIMMethod[])CIMElementSorter.sort(pMethods);
        this.iIsAssoc = pIsAssociation;
        this.iIsKeyed = CIMClass.hasKey(pProps);
    }

    public CIMClass(String pName, String pSuperClass, CIMQualifier<?>[] pQualifiers, CIMClassProperty<?>[] pProps, CIMMethod<?>[] pMethods) {
        super(pName);
        this.iObjPath = new CIMObjectPath(pName, null);
        this.iSuperClass = pSuperClass;
        this.iQualiImpl = new CIMQualifiedElementInterfaceImpl(pQualifiers);
        this.iProps = (CIMClassProperty[])CIMElementSorter.sort(pProps);
        this.iMethods = (CIMMethod[])CIMElementSorter.sort(pMethods);
        this.iIsAssoc = this.iQualiImpl.hasQualifierValue("Association", new Boolean(true));
        this.iIsKeyed = CIMClass.hasKey(pProps);
    }

    @Override
    public boolean equals(Object pObj) {
        if (!(pObj instanceof CIMClass)) {
            return false;
        }
        CIMClass that = (CIMClass)pObj;
        if (!super.equals(that)) {
            return false;
        }
        if (this.iSuperClass == null ? that.iSuperClass != null : !this.iSuperClass.equalsIgnoreCase(that.iSuperClass)) {
            return false;
        }
        return this.iQualiImpl.equals(that.iQualiImpl) && Arrays.equals(this.iProps, that.iProps) && Arrays.equals(this.iMethods, that.iMethods) && this.iIsAssoc == that.iIsAssoc && this.isKeyed() == that.isKeyed();
    }

    public CIMClass filterProperties(boolean pLocalOnly, boolean pIncludeQualifiers, boolean pIncludeClassOrigin, String[] pPropertyList) {
        int i;
        TreeSet<String> set;
        ArrayList newPropAList = new ArrayList();
        if (pPropertyList != null) {
            set = new TreeSet<String>();
            for (i = 0; i < pPropertyList.length; ++i) {
                set.add(pPropertyList[i].toUpperCase());
            }
        } else {
            set = null;
        }
        for (i = 0; i < this.getPropertyCount(); ++i) {
            CIMClassProperty<?> refProp = this.getProperty(i);
            if (pLocalOnly && refProp.isPropagated() || set != null && !set.contains(refProp.getName().toUpperCase())) continue;
            newPropAList.add(new CIMClassProperty(refProp.getName(), refProp.getDataType(), refProp.getValue(), pIncludeQualifiers ? refProp.getQualifiers() : null, pIncludeQualifiers ? refProp.isKey() : false, refProp.isPropagated(), pIncludeClassOrigin ? refProp.getOriginClass() : null));
        }
        return new CIMClass(this.getObjectPath(), this.getSuperClassName(), this.getQualifiers(), newPropAList.toArray(new CIMClassProperty[0]), null, this.isAssociation(), this.isKeyed());
    }

    public CIMClassProperty<?>[] getKeys() {
        ArrayList keyAList = new ArrayList();
        for (int i = 0; i < this.getPropertyCount(); ++i) {
            CIMClassProperty<?> prop = this.getProperty(i);
            if (!prop.isKey()) continue;
            keyAList.add(prop);
        }
        return keyAList.toArray(new CIMClassProperty[0]);
    }

    public CIMMethod<?> getMethod(int pIndex) {
        return this.iMethods[pIndex];
    }

    public CIMMethod<?> getMethod(String pName) {
        return this.getMethod(pName, null);
    }

    public CIMMethod<?> getMethod(String pName, String pOriginClass) {
        CIMMethod method = (CIMMethod)CIMElementSorter.find(this.iMethods, pName);
        if (method == null) {
            return null;
        }
        if (pOriginClass == null || pOriginClass.equalsIgnoreCase(method.getOriginClass())) {
            return method;
        }
        return null;
    }

    public int getMethodCount() {
        return this.iMethods == null ? 0 : this.iMethods.length;
    }

    public CIMMethod<?>[] getMethods() {
        return this.iMethods != null ? this.iMethods : new CIMMethod[]{};
    }

    @Override
    public CIMObjectPath getObjectPath() {
        return this.iObjPath;
    }

    public CIMClassProperty<?> getProperty(int pIndex) {
        return this.iProps[pIndex];
    }

    public CIMClassProperty<?> getProperty(String pName) {
        return (CIMClassProperty)CIMElementSorter.find(this.iProps, pName);
    }

    public CIMClassProperty<?> getProperty(String pName, String pOriginClass) {
        CIMClassProperty prop = (CIMClassProperty)CIMElementSorter.find(this.iProps, pName);
        if (pOriginClass == null) {
            return prop;
        }
        return pOriginClass.equalsIgnoreCase(prop.getOriginClass()) ? prop : null;
    }

    public CIMClassProperty<?>[] getProperties() {
        return this.iProps != null ? this.iProps : new CIMClassProperty[]{};
    }

    public int getPropertyCount() {
        return this.iProps != null ? this.iProps.length : 0;
    }

    @Override
    public CIMQualifier<?> getQualifier(int pIndex) {
        return this.iQualiImpl.getQualifier(pIndex);
    }

    @Override
    public CIMQualifier<?> getQualifier(String pName) {
        return this.iQualiImpl.getQualifier(pName);
    }

    @Override
    public Object getQualifierValue(String pName) {
        return this.iQualiImpl.getQualifierValue(pName);
    }

    @Override
    public int getQualifierCount() {
        return this.iQualiImpl.getQualifierCount();
    }

    @Override
    public CIMQualifier<?>[] getQualifiers() {
        return this.iQualiImpl.getQualifiers();
    }

    public String getSuperClassName() {
        return this.iSuperClass;
    }

    @Override
    public boolean hasQualifier(String pName) {
        return this.iQualiImpl.hasQualifier(pName);
    }

    @Override
    public boolean hasQualifierValue(String pName, Object pValue) {
        return this.iQualiImpl.hasQualifierValue(pName, pValue);
    }

    public boolean isAssociation() {
        return this.iIsAssoc;
    }

    public boolean isKeyed() {
        return this.iIsKeyed;
    }

    public CIMInstance newInstance() {
        return new CIMInstance(this.iObjPath, this.iProps);
    }

    @Override
    public String toString() {
        return MOF.classDeclaration(this, "");
    }

    private static boolean hasKey(CIMClassProperty<?>[] pProps) {
        if (pProps == null) {
            return false;
        }
        for (int i = 0; i < pProps.length; ++i) {
            if (!pProps[i].isKey()) continue;
            return true;
        }
        return false;
    }
}

