/*
 * Decompiled with CFR 0.152.
 */
package javax.cim;

import java.math.BigInteger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UnsignedInteger64
extends Number
implements Comparable<UnsignedInteger64> {
    private static final long serialVersionUID = -3734165689168941119L;
    public static final BigInteger MAX_VALUE = new BigInteger("18446744073709551615");
    public static final BigInteger MIN_VALUE = BigInteger.ZERO;
    private BigInteger iValue;

    private void setValue(BigInteger pValue) throws NumberFormatException {
        if (pValue.compareTo(MAX_VALUE) > 0 || pValue.compareTo(MIN_VALUE) < 0) {
            String msg = "uint64:" + pValue + " is out of range!";
            throw new NumberFormatException(msg);
        }
        this.iValue = pValue;
    }

    public UnsignedInteger64(BigInteger pValue) throws NumberFormatException {
        this.setValue(pValue);
    }

    public UnsignedInteger64(byte[] pValue) throws NumberFormatException {
        this.setValue(new BigInteger(pValue));
    }

    public UnsignedInteger64(String pValue) throws NumberFormatException {
        this.setValue(new BigInteger(pValue));
    }

    public BigInteger bigIntegerValue() {
        return this.iValue;
    }

    @Override
    public int compareTo(UnsignedInteger64 pOther) {
        UnsignedInteger64 that = pOther;
        int d = this.iValue.compareTo(that.iValue);
        if (d == 0) {
            return 0;
        }
        return d < 0 ? -1 : 1;
    }

    public boolean equals(Object pOther) {
        return this.iValue.equals(((UnsignedInteger64)pOther).iValue);
    }

    @Override
    public byte byteValue() {
        return this.iValue.byteValue();
    }

    @Override
    public double doubleValue() {
        return this.iValue.doubleValue();
    }

    @Override
    public float floatValue() {
        return this.iValue.floatValue();
    }

    public int hashCode() {
        return this.iValue.hashCode();
    }

    @Override
    public int intValue() {
        return this.iValue.intValue();
    }

    @Override
    public long longValue() {
        return this.iValue.longValue();
    }

    @Override
    public short shortValue() {
        return this.iValue.shortValue();
    }

    public String toString() {
        return this.iValue.toString();
    }
}

