/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.cim.CIMArgument;
import javax.cim.CIMClass;
import javax.cim.CIMClassProperty;
import javax.cim.CIMDataType;
import javax.cim.CIMInstance;
import javax.cim.CIMMethod;
import javax.cim.CIMNamedElementInterface;
import javax.cim.CIMObjectPath;
import javax.cim.CIMParameter;
import javax.cim.CIMProperty;
import javax.cim.CIMQualifiedElementInterface;
import javax.cim.CIMQualifier;
import javax.cim.CIMQualifierType;
import javax.cim.CIMTypedElement;
import javax.cim.CIMValuedElement;
import javax.wbem.WBEMException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.sblim.cimclient.internal.cim.CIMQualifiedElementInterfaceImpl;
import org.sblim.cimclient.internal.cimxml.CimXmlSerializer;
import org.sblim.cimclient.internal.util.MOF;
import org.sblim.cimclient.internal.util.WBEMConfiguration;
import org.sblim.cimclient.internal.wbem.CIMError;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CIMXMLBuilderImpl {
    private static final int MAJOR_CIM_VERSION = 2;
    private static final int MINOR_CIM_VERSION = 0;
    private static final int MAJOR_DTD_VERSION = 2;
    private static final int MINOR_DTD_VERSION = 0;
    private static final Pattern NUM_PAT = Pattern.compile("^[su]int(8|16|32|64)$", 2);
    private static final CIMQualifiedElementInterfaceImpl KEYQUALIFIERS_IMPL = new CIMQualifiedElementInterfaceImpl(null, true);
    static final CIMQualifier<Boolean> EMB_OBJ_QUALI = new CIMQualifier<Boolean>("EmbeddedObject", CIMDataType.BOOLEAN_T, new Boolean(true), 1);
    private static final Pattern NAMESPACE_SPLIT_PATTERN = Pattern.compile("/+");

    public static Element createCIM(Document pDoc) {
        Element e = pDoc.createElement("CIM");
        e.setAttribute("CIMVERSION", "2.0");
        e.setAttribute("DTDVERSION", "2.0");
        pDoc.appendChild(e);
        return e;
    }

    public static Element createVALUE(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("VALUE");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createVALUE(Document pDoc, Element pParentE, String pValue) {
        Element e = pDoc.createElement("VALUE");
        pParentE.appendChild(e);
        Text textE = pDoc.createTextNode(pValue);
        e.appendChild(textE);
        return e;
    }

    public static Element createVALUE(Document pDoc, Element pParentE, boolean pValue) {
        return CIMXMLBuilderImpl.createVALUE(pDoc, pParentE, pValue ? "true" : "false");
    }

    public static Element createVALUEARRAY(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("VALUE.ARRAY");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createVALUEREFERENCE(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("VALUE.REFERENCE");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createVALUEREFARRAY(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("VALUE.REFARRAY");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTY(Document pDoc, Element pParentE, String pName, String pType) {
        Element e = pDoc.createElement("PROPERTY");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pType != null) {
            e.setAttribute("TYPE", pType);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTYARRAY(Document pDoc, Element pParentE, String pName, String pType) {
        Element e = pDoc.createElement("PROPERTY.ARRAY");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pType != null) {
            e.setAttribute("TYPE", pType);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createPROPERTYREFERENCE(Document pDoc, Element pParentE, String pName, String pReferenceclass) {
        Element e = pDoc.createElement("PROPERTY.REFERENCE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pReferenceclass != null) {
            e.setAttribute("REFERENCECLASS", pReferenceclass);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createNAMESPACE(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("NAMESPACE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createLOCALINSTANCEPATH(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("LOCALINSTANCEPATH");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createCLASSNAME(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("CLASSNAME");
        if (pName != null) {
            e.setAttribute("NAME", pName);
            pParentE.appendChild(e);
        }
        return e;
    }

    public static Element createCLASS(Document pDoc, Element pParentE, String pName, String pSuperClass) {
        Element e = pDoc.createElement("CLASS");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pSuperClass != null && pSuperClass.length() > 0) {
            e.setAttribute("SUPERCLASS", pSuperClass);
        }
        if (pParentE != null) {
            pParentE.appendChild(e);
        }
        return e;
    }

    public static Element createINSTANCENAME(Document pDoc, Element pParentE, String pClassName) {
        Element e = pDoc.createElement("INSTANCENAME");
        if (pClassName != null) {
            e.setAttribute("CLASSNAME", pClassName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createKEYBINDING(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("KEYBINDING");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    private static String getValueTypeStr(String pTypeStr) {
        if (pTypeStr == null || "string".equalsIgnoreCase(pTypeStr)) {
            return "string";
        }
        if ("boolean".equalsIgnoreCase(pTypeStr)) {
            return "boolean";
        }
        Matcher m = NUM_PAT.matcher(pTypeStr);
        if (m.matches()) {
            return "numeric";
        }
        return "string";
    }

    public static Element createKEYVALUE(Document pDoc, Element pParentE, String pValueType, String pValue) {
        if (pValueType == null) {
            pValueType = "string";
        }
        Element e = pDoc.createElement("KEYVALUE");
        e.setAttribute("TYPE", pValueType);
        e.setAttribute("VALUETYPE", CIMXMLBuilderImpl.getValueTypeStr(pValueType));
        pParentE.appendChild(e);
        Text valueE = pDoc.createTextNode(pValue);
        e.appendChild(valueE);
        return e;
    }

    public static Element createINSTANCE(Document pDoc, Element pParentE, String pClassName) {
        Element e = pDoc.createElement("INSTANCE");
        if (pClassName != null) {
            e.setAttribute("CLASSNAME", pClassName);
        }
        if (pParentE != null) {
            pParentE.appendChild(e);
        }
        return e;
    }

    public static Element createQUALIFIER(Document pDoc, Element pParentE, String pName, String pType) {
        Element e = pDoc.createElement("QUALIFIER");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pType != null) {
            e.setAttribute("TYPE", pType);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createMESSAGE(Document pDoc, Element pParentE, String pId, String pProtocolVersion) {
        Element e = pDoc.createElement("MESSAGE");
        e.setAttribute("ID", pId);
        e.setAttribute("PROTOCOLVERSION", pProtocolVersion);
        pParentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLEREQ(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("SIMPLEREQ");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLEREQ(Document pDoc) {
        Element e = pDoc.createElement("SIMPLEREQ");
        return e;
    }

    public static Element createMULTIREQ(Document pDoc) {
        Element e = pDoc.createElement("MULTIREQ");
        return e;
    }

    public static Element createMETHODCALL(Document pDoc, Element pParentE, String pName, String pParamtype) {
        Element e = pDoc.createElement("METHODCALL");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        if (pParamtype != null) {
            e.setAttribute("PARAMTYPE", pParamtype);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createPARAMVALUE(Document pDoc, Element pParentE, CIMArgument<?> pArg) throws WBEMException {
        if (pArg == null) {
            return null;
        }
        Element e = pDoc.createElement("PARAMVALUE");
        EmbObjBuilder embObjBuilder = new EmbObjBuilder(pDoc, pArg);
        if (pArg.getName() != null) {
            e.setAttribute("NAME", pArg.getName());
        }
        e.setAttribute("PARAMTYPE", embObjBuilder.getTypeStr());
        embObjBuilder.addSign(e);
        embObjBuilder.addValue(e);
        pParentE.appendChild(e);
        return e;
    }

    public static Element createSIMPLERSP(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("SIMPLERSP");
        if (pParentE != null) {
            pParentE.appendChild(e);
        }
        return e;
    }

    public static Element createSIMPLEEXPRSP(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("SIMPLEEXPRSP");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createMETHODRESPONSE(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("METHODRESPONSE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createIMETHODRESPONSE(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("IMETHODRESPONSE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createEXPMETHODRESPONSE(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("EXPMETHODRESPONSE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createIRETURNVALUE(Document pDoc, Element pParentE) {
        Element e = pDoc.createElement("IRETURNVALUE");
        pParentE.appendChild(e);
        return e;
    }

    public static Element createRETURNVALUE(Document pDoc, Element pParentE, Object pValue) throws WBEMException {
        Element retValE = pDoc.createElement("RETURNVALUE");
        CIMDataType type = CIMDataType.getDataType(pValue);
        retValE.setAttribute("PARAMTYPE", CIMXMLBuilderImpl.getTypeStr(type));
        CIMXMLBuilderImpl.createVALUE(pDoc, retValE, pValue);
        pParentE.appendChild(retValE);
        return retValE;
    }

    public static Element createIMETHODCALL(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("IMETHODCALL");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createIPARAMVALUE(Document pDoc, Element pParentE, String pName) {
        Element e = pDoc.createElement("IPARAMVALUE");
        if (pName != null) {
            e.setAttribute("NAME", pName);
        }
        pParentE.appendChild(e);
        return e;
    }

    public static Element createERROR(Document doc, Element parentE, CIMError error) {
        String description;
        Element e = doc.createElement("ERROR");
        int code = error.getCode();
        if (code > 0) {
            e.setAttribute("CODE", Integer.toString(code));
        }
        if ((description = error.getDescription()) != null) {
            e.setAttribute("DESCRIPTION", description);
        }
        parentE.appendChild(e);
        return e;
    }

    private static void setFlavors(Element pElement, int pFlavors) {
        if ((pFlavors & 4) > 0) {
            pElement.setAttribute("TRANSLATABLE", "true");
        }
        if ((pFlavors & 1) > 0) {
            pElement.setAttribute("OVERRIDABLE", "false");
        }
        if ((pFlavors & 2) > 0) {
            pElement.setAttribute("TOSUBCLASS", "false");
        }
    }

    public static Element createQUALIFIER_DECLARATION(Document pDoc, Element pParentE, CIMQualifierType<?> pQualifierType) throws WBEMException {
        String pValueTypeStr = CIMXMLBuilderImpl.getTypeStr(pQualifierType.getDataType());
        Element qualifierdeclarationE = pDoc.createElement("QUALIFIER.DECLARATION");
        qualifierdeclarationE.setAttribute("NAME", pQualifierType.getName());
        qualifierdeclarationE.setAttribute("TYPE", pValueTypeStr);
        qualifierdeclarationE.setAttribute("ISARRAY", pQualifierType.getDataType().isArray() ? "true" : "false");
        CIMXMLBuilderImpl.setFlavors(qualifierdeclarationE, pQualifierType.getFlavor());
        int scopes = pQualifierType.getScope();
        if (scopes > 0) {
            Element scopeE = pDoc.createElement("SCOPE");
            if ((scopes & 1) > 0) {
                scopeE.setAttribute("CLASS", "true");
            }
            if ((scopes & 2) > 0) {
                scopeE.setAttribute("ASSOCIATION", "true");
            }
            if ((scopes & 0x10) > 0) {
                scopeE.setAttribute("REFERENCE", "true");
            }
            if ((scopes & 8) > 0) {
                scopeE.setAttribute("PROPERTY", "true");
            }
            if ((scopes & 0x20) > 0) {
                scopeE.setAttribute("METHOD", "true");
            }
            if ((scopes & 0x40) > 0) {
                scopeE.setAttribute("PARAMETER", "true");
            }
            if ((scopes & 4) > 0) {
                scopeE.setAttribute("INDICATION", "true");
            }
            qualifierdeclarationE.appendChild(scopeE);
        }
        CIMXMLBuilderImpl.createVALUE(pDoc, qualifierdeclarationE, pQualifierType.getValue());
        pParentE.appendChild(qualifierdeclarationE);
        return qualifierdeclarationE;
    }

    public static Element createQUALIFIER(Document pDoc, Element pParentE, CIMQualifier<?> pQualifier) throws WBEMException {
        Object value = pQualifier.getValue();
        if (value == null) {
            return null;
        }
        Element qualifierE = CIMXMLBuilderImpl.createQUALIFIER(pDoc, pParentE, pQualifier.getName(), CIMXMLBuilderImpl.getTypeStr(pQualifier.getDataType()));
        if (pQualifier.isPropagated()) {
            qualifierE.setAttribute("PROPAGATED", "true");
        }
        CIMXMLBuilderImpl.setFlavors(qualifierE, pQualifier.getFlavor());
        CIMXMLBuilderImpl.createVALUE(pDoc, qualifierE, value);
        pParentE.appendChild(qualifierE);
        return qualifierE;
    }

    public static void createQUALIFIERS(Document pDoc, Element pParentE, CIMQualifier<?>[] pQualifiersA) throws WBEMException {
        if (pQualifiersA == null) {
            return;
        }
        for (int i = 0; i < pQualifiersA.length; ++i) {
            CIMXMLBuilderImpl.createQUALIFIER(pDoc, pParentE, pQualifiersA[i]);
        }
    }

    public static void createPROPERTIES(Document pDoc, Element pParentE, CIMProperty<?>[] pProperties) throws WBEMException {
        if (pProperties == null) {
            return;
        }
        for (int i = 0; i < pProperties.length; ++i) {
            CIMXMLBuilderImpl.createPROPERTY(pDoc, pParentE, pProperties[i]);
        }
    }

    public static boolean isCIMObject(int typeCode) {
        return typeCode == 17 || typeCode == 15;
    }

    public static boolean isCIMObject(CIMDataType pType) {
        return pType == null ? false : CIMXMLBuilderImpl.isCIMObject(pType.getType());
    }

    public static String getEmbObjTypeStr(CIMDataType pType) {
        return CIMXMLBuilderImpl.isCIMObject(pType) ? "string" : CIMXMLBuilderImpl.getTypeStr(pType);
    }

    private static Document getDoc() {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            return docBuilder.newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static String cimObjectToXMLString(Object pObj) throws WBEMException {
        Element e;
        Document doc;
        if (pObj == null) {
            return null;
        }
        if (pObj instanceof CIMClass) {
            doc = CIMXMLBuilderImpl.getDoc();
            e = CIMXMLBuilderImpl.createCLASS(doc, null, (CIMClass)pObj);
        } else if (pObj instanceof CIMInstance) {
            doc = CIMXMLBuilderImpl.getDoc();
            e = CIMXMLBuilderImpl.createINSTANCE(doc, null, (CIMInstance)pObj);
        } else {
            throw new WBEMException(1, pObj.getClass().getName() + " parameter is not suitable for this method!");
        }
        doc.appendChild(e);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            CimXmlSerializer.serialize((OutputStream)os, doc.getDocumentElement(), false);
        }
        catch (IOException ex) {
            throw new WBEMException(1, "XML serialization failed with IOException!", null, ex);
        }
        return os.toString();
    }

    public static String[] cimObjectArrayToXMLString(Object pObj) throws WBEMException {
        if (pObj == null) {
            return null;
        }
        if (!(pObj instanceof Object[])) {
            throw new WBEMException(1, "Object[] parameter is required for this method!");
        }
        Object[] objA = (Object[])pObj;
        String[] strA = new String[objA.length];
        for (int i = 0; i < objA.length; ++i) {
            strA[i] = CIMXMLBuilderImpl.cimObjectToXMLString(objA[i]);
        }
        return strA;
    }

    static boolean embObjQualified(CIMQualifiedElementInterface pQualid) {
        return pQualid.hasQualifier("EmbeddedObject") || pQualid.hasQualifier("EmbeddedInstance");
    }

    public static Element createPROPERTY(Document pDoc, Element pParentE, CIMProperty<?> pProperty) throws WBEMException {
        CIMDataType propType = pProperty.getDataType();
        EmbObjBuilder embObjBuilder = new EmbObjBuilder(pDoc, pProperty, true);
        String typeStr = embObjBuilder.getTypeStr();
        Element propertyE = propType.isArray() ? CIMXMLBuilderImpl.createPROPERTYARRAY(pDoc, pParentE, pProperty.getName(), typeStr) : (propType.getType() == 14 ? CIMXMLBuilderImpl.createPROPERTYREFERENCE(pDoc, pParentE, pProperty.getName(), propType.getRefClassName()) : CIMXMLBuilderImpl.createPROPERTY(pDoc, pParentE, pProperty.getName(), typeStr));
        String classorigin = pProperty.getOriginClass();
        if (classorigin != null && classorigin.length() > 0) {
            propertyE.setAttribute("CLASSORIGIN", classorigin);
        }
        if (pProperty.isPropagated()) {
            propertyE.setAttribute("PROPAGATED", "true");
        }
        embObjBuilder.addSign(propertyE);
        if (pProperty instanceof CIMClassProperty) {
            CIMXMLBuilderImpl.createQUALIFIERS(pDoc, propertyE, ((CIMClassProperty)pProperty).getQualifiers());
        } else if (pProperty.isKey()) {
            CIMXMLBuilderImpl.createQUALIFIERS(pDoc, propertyE, KEYQUALIFIERS_IMPL.getQualifiers());
        }
        embObjBuilder.addValue(propertyE);
        return propertyE;
    }

    public static Element createVALUEARRAY(Document pDoc, Element pParentE, Object[] pValA) throws WBEMException {
        Element valuearrayE;
        Element element = valuearrayE = pValA instanceof CIMObjectPath[] || pValA instanceof CIMInstance[] ? CIMXMLBuilderImpl.createVALUEREFARRAY(pDoc, pParentE) : CIMXMLBuilderImpl.createVALUEARRAY(pDoc, pParentE);
        if (pValA != null) {
            for (int i = 0; i < pValA.length; ++i) {
                CIMXMLBuilderImpl.createVALUE(pDoc, valuearrayE, pValA[i]);
            }
        }
        pParentE.appendChild(valuearrayE);
        return valuearrayE;
    }

    public static Element createVALUE(Document pDoc, Element pParentE, Object pArgValue) throws WBEMException {
        if (pArgValue == null) {
            return null;
        }
        Element valueE = null;
        if (pArgValue instanceof Object[]) {
            valueE = CIMXMLBuilderImpl.createVALUEARRAY(pDoc, pParentE, (Object[])pArgValue);
        } else {
            CIMDataType type = CIMDataType.getDataType(pArgValue);
            if (type != null && type.getType() == 14) {
                valueE = CIMXMLBuilderImpl.createVALUEREFERENCE(pDoc, pParentE);
                CIMObjectPath op = (CIMObjectPath)pArgValue;
                CIMProperty<?>[] keys = op.getKeys();
                if (op.getHost() == null || "".equals(op.getHost())) {
                    if (op.getNamespace() == null || "".equals(op.getNamespace())) {
                        if (keys.length > 0) {
                            CIMXMLBuilderImpl.createINSTANCENAME(pDoc, valueE, op);
                        } else {
                            CIMXMLBuilderImpl.createCLASSNAME(pDoc, valueE, op.getObjectName());
                        }
                    } else if (keys.length > 0) {
                        CIMXMLBuilderImpl.createLOCALINSTANCEPATH(pDoc, valueE, op);
                    } else {
                        CIMXMLBuilderImpl.createLOCALCLASSPATH(pDoc, valueE, op);
                    }
                } else if (keys.length > 0) {
                    CIMXMLBuilderImpl.createINSTANCEPATH(pDoc, valueE, op);
                } else {
                    CIMXMLBuilderImpl.createCLASSPATH(pDoc, valueE, op);
                }
            } else if (pArgValue instanceof CIMInstance) {
                valueE = CIMXMLBuilderImpl.createVALUEREFERENCE(pDoc, pParentE);
                CIMObjectPath cop = ((CIMInstance)pArgValue).getObjectPath();
                CIMXMLBuilderImpl.createINSTANCENAME(pDoc, valueE, cop);
            } else if (pArgValue instanceof CIMClass) {
                valueE = CIMXMLBuilderImpl.createVALUE(pDoc, pParentE);
                CIMXMLBuilderImpl.createCLASS(pDoc, valueE, (CIMClass)pArgValue);
            } else {
                CIMXMLBuilderImpl.createVALUE(pDoc, pParentE, pArgValue.toString());
            }
        }
        return valueE;
    }

    public static Element createINSTANCE(Document pDoc, Element pParentE, CIMInstance pInstance) throws WBEMException {
        String className = pInstance.getObjectPath().getObjectName();
        if (className == null) {
            throw new WBEMException(1, "null class name");
        }
        Element instanceE = CIMXMLBuilderImpl.createINSTANCE(pDoc, pParentE, className);
        CIMXMLBuilderImpl.createPROPERTIES(pDoc, instanceE, pInstance.getProperties());
        if (pParentE != null) {
            pParentE.appendChild(instanceE);
        }
        return instanceE;
    }

    public static Element createOBJECTPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        Element objectpathE = pDoc.createElement("OBJECTPATH");
        CIMProperty<?>[] keys = pPath.getKeys();
        if (keys.length > 0) {
            CIMXMLBuilderImpl.createINSTANCEPATH(pDoc, objectpathE, pPath);
        } else {
            CIMXMLBuilderImpl.createCLASSPATH(pDoc, objectpathE, pPath);
        }
        pParentE.appendChild(objectpathE);
        return objectpathE;
    }

    public static Element createOBJECTNAME(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        CIMProperty<?>[] keys = pPath.getKeys();
        if (keys.length > 0) {
            return CIMXMLBuilderImpl.createINSTANCENAME(pDoc, pParentE, pPath);
        }
        if (pPath.getObjectName() == null) {
            throw new WBEMException(4, "null class name");
        }
        return CIMXMLBuilderImpl.createCLASSNAME(pDoc, pParentE, pPath.getObjectName());
    }

    public static Element createLOCALINSTANCEPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        Element localinstancepathE = pDoc.createElement("LOCALINSTANCEPATH");
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(pDoc, localinstancepathE, pPath);
        CIMXMLBuilderImpl.createINSTANCENAME(pDoc, localinstancepathE, pPath);
        pParentE.appendChild(localinstancepathE);
        return localinstancepathE;
    }

    public static Element createLOCALCLASSPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        Element localinstancepathE = pDoc.createElement("LOCALCLASSPATH");
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(pDoc, localinstancepathE, pPath);
        if (pPath.getObjectName() == null) {
            throw new WBEMException(4, "null class name");
        }
        CIMXMLBuilderImpl.createCLASSNAME(pDoc, localinstancepathE, pPath.getObjectName());
        pParentE.appendChild(localinstancepathE);
        return localinstancepathE;
    }

    public static Element createLOCALOBJECTPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        CIMProperty<?>[] keys = pPath.getKeys();
        if (keys.length > 0) {
            return CIMXMLBuilderImpl.createLOCALINSTANCEPATH(pDoc, pParentE, pPath);
        }
        return CIMXMLBuilderImpl.createLOCALCLASSPATH(pDoc, pParentE, pPath);
    }

    public static Element createVALUEREFERENCE(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        Element objectpathE = pDoc.createElement("VALUE.REFERENCE");
        String ns = pPath.getNamespace();
        if (pPath.getHost() == null || "".equals(pPath.getHost())) {
            if (pPath.getNamespace() == null || "".equals(ns)) {
                CIMXMLBuilderImpl.createINSTANCENAME(pDoc, objectpathE, pPath);
            } else {
                CIMXMLBuilderImpl.createLOCALOBJECTPATH(pDoc, objectpathE, pPath);
            }
        } else {
            CIMProperty<?>[] keys = pPath.getKeys();
            if (keys.length > 0) {
                CIMXMLBuilderImpl.createINSTANCEPATH(pDoc, objectpathE, pPath);
            } else {
                CIMXMLBuilderImpl.createCLASSPATH(pDoc, objectpathE, pPath);
            }
        }
        pParentE.appendChild(objectpathE);
        return objectpathE;
    }

    public static Element createINSTANCENAME(Document doc, Element parentE, CIMObjectPath instanceOP) throws WBEMException {
        Element instancenameE = doc.createElement("INSTANCENAME");
        String classname = instanceOP.getObjectName();
        if (classname != null) {
            instancenameE.setAttribute("CLASSNAME", classname);
        }
        CIMProperty<?>[] keysA = instanceOP.getKeys();
        for (int ii = 0; ii < keysA.length; ++ii) {
            CIMProperty<?> prop = keysA[ii];
            String propName = prop.getName();
            CIMDataType propType = prop.getDataType();
            Object propValue = prop.getValue();
            if (propValue == null && propType.getType() == 14) {
                throw new WBEMException(4, "Value of reference cannot be null!");
            }
            Element keybindingE = CIMXMLBuilderImpl.createKEYBINDING(doc, instancenameE, propName);
            if (propType.getType() == 14) {
                CIMObjectPath refOP = (CIMObjectPath)propValue;
                CIMXMLBuilderImpl.createVALUEREFERENCE(doc, keybindingE, refOP);
                continue;
            }
            String valueStr = propValue == null ? null : propValue.toString();
            String valueTypeStr = CIMXMLBuilderImpl.getTypeStr(propType);
            CIMXMLBuilderImpl.createKEYVALUE(doc, keybindingE, valueTypeStr, valueStr);
        }
        parentE.appendChild(instancenameE);
        return instancenameE;
    }

    public static Element createCLASSPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) {
        Element classpathE = pDoc.createElement("CLASSPATH");
        CIMXMLBuilderImpl.createNAMESPACEPATH(pDoc, classpathE, pPath);
        CIMXMLBuilderImpl.createCLASSNAME(pDoc, classpathE, pPath.getObjectName());
        pParentE.appendChild(classpathE);
        return classpathE;
    }

    public static void createPARAMETERS(Document pDoc, Element pParentE, CIMParameter<?>[] pParameters) throws WBEMException {
        if (pParameters == null) {
            return;
        }
        for (int i = 0; i < pParameters.length; ++i) {
            CIMXMLBuilderImpl.createPARAMETER(pDoc, pParentE, pParameters[i]);
        }
    }

    public static Element createPARAMETER(Document pDoc, Element pParentE, CIMParameter<?> pParameter) throws WBEMException {
        Element parameterE;
        CIMDataType type = pParameter.getDataType();
        int typeCode = type.getType();
        EmbObjBuilder embObjBuilder = new EmbObjBuilder(pDoc, pParameter);
        String typeStr = embObjBuilder.getTypeStr();
        if (type.isArray()) {
            if (typeCode == 14) {
                parameterE = pDoc.createElement("PARAMETER.REFARRAY");
                parameterE.setAttribute("REFERENCECLASS", type.getRefClassName());
            } else {
                parameterE = pDoc.createElement("PARAMETER.ARRAY");
                parameterE.setAttribute("TYPE", typeStr);
            }
        } else if (typeCode == 14) {
            parameterE = pDoc.createElement("PARAMETER.REFERENCE");
            parameterE.setAttribute("REFERENCECLASS", type.getRefClassName());
        } else {
            parameterE = pDoc.createElement("PARAMETER");
            parameterE.setAttribute("TYPE", typeStr);
        }
        parameterE.setAttribute("NAME", pParameter.getName());
        embObjBuilder.addSign(parameterE);
        CIMXMLBuilderImpl.createQUALIFIERS(pDoc, parameterE, pParameter.getQualifiers());
        pParentE.appendChild(parameterE);
        return parameterE;
    }

    public static void createMETHODS(Document pDoc, Element pParentE, CIMMethod<?>[] pMethods, String pClassName) throws WBEMException {
        for (int i = 0; i < pMethods.length; ++i) {
            CIMXMLBuilderImpl.createMETHOD(pDoc, pParentE, pMethods[i], pClassName);
        }
    }

    public static Element createMETHOD(Document pDoc, Element pParentE, CIMMethod<?> pMethod, String pClassName) throws WBEMException {
        Element methodE = pDoc.createElement("METHOD");
        methodE.setAttribute("NAME", pMethod.getName());
        EmbObjBuilder embObjBuilder = new EmbObjBuilder(pDoc, pMethod);
        String typeStr = embObjBuilder.getTypeStr();
        methodE.setAttribute("TYPE", typeStr);
        String classorigin = pMethod.getOriginClass();
        if (classorigin != null && classorigin.length() != 0) {
            methodE.setAttribute("CLASSORIGIN", classorigin);
        }
        if (classorigin != null && classorigin.equalsIgnoreCase(pClassName)) {
            methodE.setAttribute("PROPAGATED", "true");
        } else {
            methodE.setAttribute("PROPAGATED", "false");
        }
        embObjBuilder.addSign(methodE);
        CIMXMLBuilderImpl.createQUALIFIERS(pDoc, methodE, pMethod.getQualifiers());
        CIMXMLBuilderImpl.createPARAMETERS(pDoc, methodE, pMethod.getParameters());
        pParentE.appendChild(methodE);
        return methodE;
    }

    public static Element createCLASS(Document pDoc, Element pParentE, CIMClass pClass) throws WBEMException {
        Element classE = CIMXMLBuilderImpl.createCLASS(pDoc, pParentE, pClass.getName(), pClass.getSuperClassName());
        CIMXMLBuilderImpl.createQUALIFIERS(pDoc, classE, pClass.getQualifiers());
        CIMXMLBuilderImpl.createPROPERTIES(pDoc, classE, pClass.getProperties());
        CIMXMLBuilderImpl.createMETHODS(pDoc, classE, pClass.getMethods(), pClass.getName());
        return classE;
    }

    public static Element createHOST(Document pDoc, Element pParentE, String pHost) {
        Element hostE = pDoc.createElement("HOST");
        Text hostT = pDoc.createTextNode(pHost);
        hostE.appendChild(hostT);
        pParentE.appendChild(hostE);
        return hostE;
    }

    public static Element createNAMESPACEPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) {
        Element namespacepathE = pDoc.createElement("NAMESPACEPATH");
        String host = pPath.getHost();
        if (host == null) {
            host = "unassigned-hostname";
        }
        CIMXMLBuilderImpl.createHOST(pDoc, namespacepathE, host);
        CIMXMLBuilderImpl.createLOCALNAMESPACEPATH(pDoc, namespacepathE, pPath);
        pParentE.appendChild(namespacepathE);
        return namespacepathE;
    }

    public static Element createINSTANCEPATH(Document pDoc, Element pParentE, CIMObjectPath pPath) throws WBEMException {
        Element instancepathE = pDoc.createElement("INSTANCEPATH");
        CIMXMLBuilderImpl.createNAMESPACEPATH(pDoc, instancepathE, pPath);
        CIMXMLBuilderImpl.createINSTANCENAME(pDoc, instancepathE, pPath);
        pParentE.appendChild(instancepathE);
        return instancepathE;
    }

    public static Element createVALUENAMEDINSTANCE(Document pDoc, Element pParentE, CIMObjectPath pPath, CIMInstance pInst) throws WBEMException {
        Element valuenamedinstanceE = pDoc.createElement("VALUE.NAMEDINSTANCE");
        CIMXMLBuilderImpl.createINSTANCENAME(pDoc, valuenamedinstanceE, pPath);
        CIMXMLBuilderImpl.createINSTANCE(pDoc, valuenamedinstanceE, pInst);
        pParentE.appendChild(valuenamedinstanceE);
        return valuenamedinstanceE;
    }

    public static Element createVALUENAMEDINSTANCE(Document pDoc, Element pParentE, CIMInstance pInst) throws WBEMException {
        Element valuenamedinstanceE = pDoc.createElement("VALUE.NAMEDINSTANCE");
        CIMXMLBuilderImpl.createINSTANCENAME(pDoc, valuenamedinstanceE, pInst.getObjectPath());
        CIMXMLBuilderImpl.createINSTANCE(pDoc, valuenamedinstanceE, pInst);
        pParentE.appendChild(valuenamedinstanceE);
        return valuenamedinstanceE;
    }

    private static CIMObjectPath changeNameSpace(CIMNamedElementInterface pNamedElement, String pNameSpace) {
        CIMObjectPath path = pNamedElement.getObjectPath();
        return new CIMObjectPath(path.getScheme(), path.getHost(), path.getPort(), pNameSpace, path.getObjectName(), path.getKeys());
    }

    private static CIMClass changeClassNameSpace(CIMClass pClass, String pNameSpace) {
        CIMObjectPath newOp = CIMXMLBuilderImpl.changeNameSpace(pClass, pNameSpace);
        return new CIMClass(newOp, pClass.getSuperClassName(), pClass.getQualifiers(), pClass.getProperties(), pClass.getMethods(), pClass.isAssociation(), pClass.isKeyed());
    }

    private static CIMInstance changeInstanceNameSpace(CIMInstance pInst, String pNameSpace) {
        CIMObjectPath newOp = CIMXMLBuilderImpl.changeNameSpace(pInst, pNameSpace);
        return new CIMInstance(newOp, pInst.getProperties());
    }

    public static Element createVALUEOBJECTWITHPATH(Document pDoc, Element pParentE, Object pObj, String pNameSpace) throws WBEMException {
        Element valueobjectwithpathE = pDoc.createElement("VALUE.OBJECTWITHPATH");
        if (pObj instanceof CIMClass) {
            CIMClass clazz = (CIMClass)pObj;
            if (clazz.getObjectPath().getNamespace() == null || clazz.getObjectPath().getNamespace().length() == 0) {
                clazz = CIMXMLBuilderImpl.changeClassNameSpace(clazz, pNameSpace);
            }
            CIMXMLBuilderImpl.createCLASSPATH(pDoc, valueobjectwithpathE, clazz.getObjectPath());
            CIMXMLBuilderImpl.createCLASS(pDoc, valueobjectwithpathE, clazz);
        } else if (pObj instanceof CIMInstance) {
            CIMInstance inst = (CIMInstance)pObj;
            if (inst.getObjectPath().getNamespace() == null || inst.getObjectPath().getNamespace().length() == 0) {
                inst = CIMXMLBuilderImpl.changeInstanceNameSpace(inst, pNameSpace);
            }
            CIMXMLBuilderImpl.createINSTANCEPATH(pDoc, valueobjectwithpathE, inst.getObjectPath());
            CIMXMLBuilderImpl.createINSTANCE(pDoc, valueobjectwithpathE, inst);
        }
        pParentE.appendChild(valueobjectwithpathE);
        return valueobjectwithpathE;
    }

    public static Element createVALUEOBJECTWITHLOCALPATH(Document pDoc, Element pParentE, Object pObj, String pNameSpace) throws WBEMException {
        Element valueobjectwithpathE = pDoc.createElement("VALUE.OBJECTWITHLOCALPATH");
        if (pObj instanceof CIMClass) {
            CIMClass clazz = (CIMClass)pObj;
            if (clazz.getObjectPath().getNamespace() == null || clazz.getObjectPath().getNamespace().length() == 0) {
                clazz = CIMXMLBuilderImpl.changeClassNameSpace(clazz, pNameSpace);
            }
            CIMXMLBuilderImpl.createLOCALCLASSPATH(pDoc, valueobjectwithpathE, clazz.getObjectPath());
            CIMXMLBuilderImpl.createCLASS(pDoc, valueobjectwithpathE, clazz);
        } else if (pObj instanceof CIMInstance) {
            CIMInstance inst = (CIMInstance)pObj;
            if (inst.getObjectPath().getNamespace() == null || inst.getObjectPath().getNamespace().length() == 0) {
                inst = CIMXMLBuilderImpl.changeInstanceNameSpace(inst, pNameSpace);
            }
            CIMXMLBuilderImpl.createLOCALINSTANCEPATH(pDoc, valueobjectwithpathE, inst.getObjectPath());
            CIMXMLBuilderImpl.createINSTANCE(pDoc, valueobjectwithpathE, inst);
        }
        pParentE.appendChild(valueobjectwithpathE);
        return valueobjectwithpathE;
    }

    public static Element createIRETURNVALUE_ERROR(Document doc, Element parentE, CIMError error) {
        Element ireturnvalueE = doc.createElement("IRETURNVALUE");
        parentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_GETINSTANCE(Document pDoc, Element pParentE, CIMInstance pInst) throws WBEMException {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        CIMXMLBuilderImpl.createINSTANCENAME(pDoc, ireturnvalueE, pInst.getObjectPath());
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ASSOCIATORS_NAMES(Document pDoc, Element pParentE, CIMObjectPath[] pResultSet) throws Exception {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null) {
            for (int i = 0; i < pResultSet.length; ++i) {
                CIMObjectPath path = pResultSet[i];
                if (path.getHost() == null || "".equals(path.getHost())) {
                    CIMXMLBuilderImpl.createLOCALOBJECTPATH(pDoc, ireturnvalueE, path);
                    continue;
                }
                CIMXMLBuilderImpl.createOBJECTPATH(pDoc, ireturnvalueE, path);
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ASSOCIATORS(Document pDoc, Element pParentE, Object[] pResultSet, String pNameSpace) throws Exception {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null) {
            for (int i = 0; i < pResultSet.length; ++i) {
                Object obj = pResultSet[i];
                CIMObjectPath op = null;
                if (obj instanceof CIMClass) {
                    op = ((CIMClass)obj).getObjectPath();
                } else if (obj instanceof CIMInstance) {
                    op = ((CIMInstance)obj).getObjectPath();
                } else {
                    throw new WBEMException(1, "object in result set neither class nor instance!");
                }
                if (op.getHost() == null || "".equals(op.getHost())) {
                    CIMXMLBuilderImpl.createVALUEOBJECTWITHLOCALPATH(pDoc, ireturnvalueE, obj, pNameSpace);
                    continue;
                }
                CIMXMLBuilderImpl.createVALUEOBJECTWITHPATH(pDoc, ireturnvalueE, obj, pNameSpace);
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_INSTANCENAME(Document pDoc, Element pParentE, Object[] pResultSet, String pNameSpace) throws Exception {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null) {
            for (int i = 0; i < pResultSet.length; ++i) {
                Object obj = pResultSet[i];
                CIMObjectPath op = null;
                if (obj instanceof CIMClass) {
                    op = ((CIMClass)obj).getObjectPath();
                } else if (obj instanceof CIMInstance) {
                    op = ((CIMInstance)obj).getObjectPath();
                } else {
                    throw new WBEMException(1, "object in result set neither class nor instance!");
                }
                if (op.getHost() == null || "".equals(op.getHost())) {
                    CIMXMLBuilderImpl.createVALUEOBJECTWITHLOCALPATH(pDoc, ireturnvalueE, obj, pNameSpace);
                    continue;
                }
                CIMXMLBuilderImpl.createVALUEOBJECTWITHPATH(pDoc, ireturnvalueE, obj, pNameSpace);
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE(Document pDoc, Element pParentE, Object[] pResultSet) throws WBEMException {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null && pResultSet.length > 0) {
            Object obj = pResultSet[0];
            if (obj instanceof CIMClass) {
                for (int i = 0; i < pResultSet.length; ++i) {
                    CIMClass clazz = (CIMClass)pResultSet[i];
                    Element classnameE = pDoc.createElement("CLASSNAME");
                    ireturnvalueE.appendChild(classnameE);
                    if (clazz.getName() == null) continue;
                    classnameE.setAttribute("NAME", clazz.getName());
                }
            } else if (obj instanceof CIMInstance) {
                for (int i = 0; i < pResultSet.length; ++i) {
                    CIMInstance inst = (CIMInstance)pResultSet[i];
                    CIMXMLBuilderImpl.createVALUENAMEDINSTANCE(pDoc, ireturnvalueE, inst);
                }
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_CLASSNAME(Document pDoc, Element pParentE, CIMClass[] pResultSet) {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null && pResultSet.length > 0) {
            for (int i = 0; i < pResultSet.length; ++i) {
                CIMClass clazz = pResultSet[i];
                Element classnameE = pDoc.createElement("CLASSNAME");
                ireturnvalueE.appendChild(classnameE);
                if (clazz.getName() == null) continue;
                classnameE.setAttribute("NAME", clazz.getName());
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static Element createIndication_response(Document doc, String ID, CIMError error) {
        Element cimE = CIMXMLBuilderImpl.createCIM(doc);
        Element messageE = CIMXMLBuilderImpl.createMESSAGE(doc, cimE, ID, "1.0");
        Element simpleexprspE = CIMXMLBuilderImpl.createSIMPLEEXPRSP(doc, messageE);
        Element expmethodresponseE = CIMXMLBuilderImpl.createEXPMETHODRESPONSE(doc, simpleexprspE, "ExportIndication");
        if (error == null) {
            CIMXMLBuilderImpl.createIRETURNVALUE(doc, expmethodresponseE);
        } else {
            CIMXMLBuilderImpl.createERROR(doc, expmethodresponseE, error);
        }
        return cimE;
    }

    public static Element createIRETURNVALUE_ENUMERATE_INSTANCE(Document pDoc, Element pParentE, CIMInstance[] pResultSet) throws WBEMException {
        Element ireturnvalueE = pDoc.createElement("IRETURNVALUE");
        if (pResultSet != null && pResultSet.length > 0) {
            for (int i = 0; i < pResultSet.length; ++i) {
                CIMXMLBuilderImpl.createVALUENAMEDINSTANCE(pDoc, ireturnvalueE, pResultSet[i]);
            }
        }
        pParentE.appendChild(ireturnvalueE);
        return ireturnvalueE;
    }

    public static String getTypeStr(CIMDataType pType) {
        if (pType == null) {
            return "string";
        }
        if (pType.getType() == 14) {
            return "reference";
        }
        return MOF.dataType(pType);
    }

    public static String getOpTypeStr(CIMDataType pType) {
        return CIMXMLBuilderImpl.getTypeStr(pType);
    }

    public static Element createLOCALNAMESPACEPATH(Document pDoc, Element pParentE, CIMObjectPath pName) {
        if (pName == null) {
            return null;
        }
        Element localnamespacepathE = pDoc.createElement("LOCALNAMESPACEPATH");
        String nameSpace = pName.getNamespace();
        if (nameSpace != null) {
            String[] nsA = NAMESPACE_SPLIT_PATTERN.split(nameSpace);
            for (int i = 0; i < nsA.length; ++i) {
                if (nsA[i] == null || nsA[i].length() <= 0) continue;
                CIMXMLBuilderImpl.createNAMESPACE(pDoc, localnamespacepathE, nsA[i]);
            }
        }
        pParentE.appendChild(localnamespacepathE);
        return localnamespacepathE;
    }

    static class EmbObjBuilder {
        private static final int ATTRIB_ONLY = 0;
        private static final int EO_QUALI = 1;
        private static final int EO_AND_EI_QUALI = 2;
        private int iSignMethod;
        private Document iDoc;
        private CIMTypedElement iTypedE;
        private boolean iXMLQualified;

        public EmbObjBuilder(Document pDoc, CIMTypedElement pTypedE) {
            this(pDoc, pTypedE, false);
        }

        public EmbObjBuilder(Document pDoc, CIMTypedElement pTypedE, boolean pXMLQualified) {
            this.iDoc = pDoc;
            this.iTypedE = pTypedE;
            this.iXMLQualified = pXMLQualified;
            String builderCfg = WBEMConfiguration.getGlobalConfiguration().getCimXmlEmbObjBuilder();
            this.iSignMethod = "EmbObjQuali".equalsIgnoreCase(builderCfg) ? 1 : ("EmbObjAndEmbInstQuali".equalsIgnoreCase(builderCfg) ? 2 : 0);
        }

        public String getTypeStr() {
            return CIMXMLBuilderImpl.getEmbObjTypeStr(this.iTypedE.getDataType());
        }

        public boolean isArray() {
            return this.iTypedE.getDataType().isArray();
        }

        private Object getValue() {
            if (!(this.iTypedE instanceof CIMValuedElement)) {
                return null;
            }
            return ((CIMValuedElement)this.iTypedE).getValue();
        }

        public void addSign(Element pElement) throws WBEMException {
            CIMQualifiedElementInterface qualified;
            if (!CIMXMLBuilderImpl.isCIMObject(this.iTypedE.getDataType())) {
                return;
            }
            if (this.iTypedE instanceof CIMQualifiedElementInterface) {
                qualified = (CIMQualifiedElementInterface)((Object)this.iTypedE);
                if (CIMXMLBuilderImpl.embObjQualified(qualified)) {
                    return;
                }
            } else {
                qualified = null;
            }
            if (this.iSignMethod == 0 || qualified == null && !this.iXMLQualified) {
                pElement.setAttribute("EMBEDDEDOBJECT", this.iTypedE.getDataType().getType() == 15 ? "instance" : "object");
            } else if (this.iSignMethod == 2) {
                this.addEmbObjOrEmbInstQuali(pElement);
            } else {
                CIMXMLBuilderImpl.createQUALIFIER(this.iDoc, pElement, EMB_OBJ_QUALI);
            }
        }

        private void addEmbObjOrEmbInstQuali(Element pElement) throws WBEMException {
            CIMQualifier<Object> signQuali;
            if (this.iTypedE.getDataType().getType() == 15) {
                CIMInstance[] instA;
                CIMInstance inst = this.isArray() ? ((instA = (CIMInstance[])this.getValue()) == null ? null : instA[0]) : (CIMInstance)this.getValue();
                String className = inst == null ? "" : inst.getClassName();
                signQuali = new CIMQualifier<String>("EmbeddedInstance", CIMDataType.STRING_T, className, 1);
            } else {
                signQuali = EMB_OBJ_QUALI;
            }
            CIMXMLBuilderImpl.createQUALIFIER(this.iDoc, pElement, signQuali);
        }

        public void addValue(Element pElement) throws WBEMException {
            Object value = this.getValue();
            if (value == null) {
                return;
            }
            if (CIMXMLBuilderImpl.isCIMObject(this.iTypedE.getDataType())) {
                value = this.isArray() ? CIMXMLBuilderImpl.cimObjectArrayToXMLString(value) : CIMXMLBuilderImpl.cimObjectToXMLString(value);
            }
            CIMXMLBuilderImpl.createVALUE(this.iDoc, pElement, value);
        }
    }
}

