/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.cimxml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class CimXmlSerializer {
    private boolean iPretty;
    private int iIndent = 0;
    private boolean iLastClosed = false;

    private CimXmlSerializer(boolean pPretty) {
        this.iPretty = pPretty;
    }

    public static void serialize(OutputStream pOS, Document pDoc, boolean pPretty) throws IOException {
        try {
            XmlWriter writer = new XmlWriter(pOS, "UTF-8");
            writer.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            new CimXmlSerializer(pPretty).serializeNode(writer, pDoc.getDocumentElement());
            writer.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void serialize(OutputStream pOS, Node pNode, boolean pPretty) throws IOException {
        try {
            XmlWriter writer = new XmlWriter(pOS, "UTF-8");
            new CimXmlSerializer(pPretty).serializeNode(writer, pNode);
            writer.flush();
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    private void serializeNode(XmlWriter pWriter, Node pNode) throws IOException {
        switch (pNode.getNodeType()) {
            case 1: {
                Node child;
                pWriter.write(this.indent());
                pWriter.write("<");
                pWriter.write(pNode.getNodeName());
                NamedNodeMap attributes = pNode.getAttributes();
                if (attributes != null) {
                    for (int i = 0; i < attributes.getLength(); ++i) {
                        pWriter.write(" ");
                        this.serializeNode(pWriter, attributes.item(i));
                    }
                }
                if ((child = pNode.getFirstChild()) == null) {
                    pWriter.write("/>");
                    this.iLastClosed = true;
                    break;
                }
                pWriter.write(">");
                ++this.iIndent;
                this.iLastClosed = false;
                while (child != null) {
                    this.serializeNode(pWriter, child);
                    child = child.getNextSibling();
                }
                --this.iIndent;
                if (this.iLastClosed) {
                    pWriter.write(this.indent());
                }
                pWriter.write("</");
                pWriter.write(pNode.getNodeName());
                pWriter.write(">");
                this.iLastClosed = true;
                break;
            }
            case 2: {
                pWriter.write(pNode.getNodeName());
                pWriter.write("=\"");
                pWriter.writeValue(pNode.getNodeValue());
                pWriter.write("\"");
                break;
            }
            case 3: {
                pWriter.writeValue(pNode.getNodeValue());
            }
        }
    }

    private String indent() {
        if (!this.iPretty) {
            return "";
        }
        StringBuffer result = new StringBuffer();
        result.append('\n');
        for (int i = 0; i < this.iIndent; ++i) {
            result.append(' ');
        }
        return result.toString();
    }

    private static class XmlWriter {
        private BufferedWriter iWriter;

        public XmlWriter(OutputStream pOut, String pCharsetName) {
            this.iWriter = new BufferedWriter(new OutputStreamWriter(pOut, Charset.forName(pCharsetName).newEncoder()));
        }

        public void write(String pText) throws IOException {
            if (pText != null) {
                this.iWriter.write(pText);
            }
        }

        public void close() throws IOException {
            this.iWriter.close();
        }

        public void flush() throws IOException {
            this.iWriter.flush();
        }

        public void writeValue(String pText) throws IOException {
            if (pText == null) {
                return;
            }
            boolean escapeSpace = true;
            int oneBeforeLast = pText.length() - 2;
            for (int i = 0; i < pText.length(); ++i) {
                char currentChar = pText.charAt(i);
                boolean isSpace = false;
                if (this.isHighSurrogate(currentChar)) {
                    if (i > oneBeforeLast || !this.isLowSurrogate(pText.charAt(i + 1))) {
                        throw new IOException("Illegal Unicode character");
                    }
                    this.iWriter.write(pText, i++, 2);
                } else if (currentChar < ' ') {
                    this.writeAsHex(currentChar);
                } else if (currentChar > '~') {
                    this.iWriter.write(currentChar);
                } else {
                    switch (currentChar) {
                        case ' ': {
                            isSpace = true;
                            if (escapeSpace) {
                                this.writeAsHex(currentChar);
                                break;
                            }
                            this.iWriter.write(currentChar);
                            break;
                        }
                        case '<': {
                            this.iWriter.write("&lt;");
                            break;
                        }
                        case '>': {
                            this.iWriter.write("&gt;");
                            break;
                        }
                        case '&': {
                            this.iWriter.write("&amp;");
                            break;
                        }
                        case '\"': {
                            this.iWriter.write("&quot;");
                            break;
                        }
                        case '\'': {
                            this.iWriter.write("&apos;");
                            break;
                        }
                        default: {
                            this.iWriter.write(currentChar);
                        }
                    }
                }
                escapeSpace = isSpace && !escapeSpace || i == oneBeforeLast;
            }
        }

        private void writeAsHex(char pChar) throws IOException {
            this.iWriter.write("&#x" + Integer.toHexString(pChar) + ";");
        }

        private boolean isHighSurrogate(char pChar) {
            return pChar >= '\ud800' && pChar <= '\udbff';
        }

        private boolean isLowSurrogate(char pChar) {
            return pChar >= '\udc00' && pChar <= '\udfff';
        }
    }
}

