/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.discovery.slp;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import java.util.logging.Level;
import org.sblim.cimclient.discovery.Discoverer;
import org.sblim.cimclient.discovery.WBEMServiceAdvertisement;
import org.sblim.cimclient.internal.discovery.slp.WBEMServiceAdvertisementSLP;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;
import org.sblim.slp.Locator;
import org.sblim.slp.ServiceLocationEnumeration;
import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.ServiceLocationManager;
import org.sblim.slp.ServiceType;
import org.sblim.slp.ServiceURL;
import org.sblim.slp.internal.SLPDefaults;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscovererSLP
implements Discoverer {
    private static final String SERVICE_WBEM = "service:wbem";
    private static final ServiceType SERVICE_TYPE = new ServiceType("service:wbem");
    private static final Vector<String> ATTRIBUTES = new Vector();
    private Locale iLocale;
    private Vector<String> iScopes;

    public DiscovererSLP(Locale pLocale) {
        this.iLocale = pLocale;
        this.iScopes = new Vector();
        this.iScopes.add("default");
    }

    public Locale getLocale() {
        return this.iLocale;
    }

    public void setLocale(Locale pLocale) {
        this.iLocale = pLocale;
    }

    public Vector<String> getScopes() {
        return this.iScopes;
    }

    public void setScopes(Vector<String> pScopes) {
        this.iScopes = pScopes;
    }

    @Override
    public WBEMServiceAdvertisement[] findWbemServices(String[] pDirectoryUrls) {
        ArrayList<WBEMServiceAdvertisement> advertisements = new ArrayList<WBEMServiceAdvertisement>();
        if (pDirectoryUrls != null && pDirectoryUrls.length > 0) {
            for (int i = 0; i < pDirectoryUrls.length; ++i) {
                advertisements.addAll(this.findWbemServices(pDirectoryUrls[i]));
            }
        } else {
            advertisements.addAll(this.findWbemServices((String)null));
        }
        return advertisements.toArray(new WBEMServiceAdvertisement[advertisements.size()]);
    }

    private List<WBEMServiceAdvertisement> findWbemServices(String pDA) {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        logger.trace(Level.FINEST, "SLP discovery started on DA " + pDA);
        try {
            Vector<InetAddress> agents;
            if (pDA != null) {
                agents = new Vector<InetAddress>();
                InetAddress address = InetAddress.getByName(pDA);
                if (address == null) {
                    return new LinkedList<WBEMServiceAdvertisement>();
                }
                agents.add(address);
            } else {
                agents = null;
            }
            Locator locator = ServiceLocationManager.getLocator(this.iLocale);
            ArrayList<WBEMServiceAdvertisement> advertisements = new ArrayList<WBEMServiceAdvertisement>();
            ServiceLocationEnumeration serviceEnum = locator.findServices(SERVICE_TYPE, this.iScopes, "", agents);
            while (serviceEnum != null && serviceEnum.hasMoreElements()) {
                ServiceURL url;
                try {
                    url = (ServiceURL)serviceEnum.nextElement();
                }
                catch (RuntimeException e) {
                    logger.trace(Level.FINE, e.getMessage(), e);
                    continue;
                }
                ServiceLocationEnumeration attributeEnum = locator.findAttributes(url, this.iScopes, ATTRIBUTES, agents);
                ArrayList<String> attributes = new ArrayList<String>();
                while (attributeEnum != null && attributeEnum.hasMoreElements()) {
                    try {
                        attributes.add(attributeEnum.nextElement().toString());
                    }
                    catch (RuntimeException e) {
                        logger.trace(Level.FINE, e.getMessage(), e);
                    }
                }
                advertisements.add(new WBEMServiceAdvertisementSLP(pDA, url, attributes));
            }
            logger.trace(Level.FINEST, "SLP discovery completed on DA " + pDA + ". " + advertisements.size() + " WBEM services found");
            logger.exit();
            return advertisements;
        }
        catch (ServiceLocationException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "SLP discovery failed with error", e);
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception during service discovery", e);
        }
        logger.exit();
        return new LinkedList<WBEMServiceAdvertisement>();
    }

    @Override
    public String[] findDirectoryServices() {
        LogAndTraceBroker logger = LogAndTraceBroker.getBroker();
        logger.entry();
        try {
            ServiceURL url;
            ArrayList<String> agents = new ArrayList<String>();
            Locator locator = ServiceLocationManager.getLocator(this.iLocale);
            ServiceLocationEnumeration serviceEnum = locator.findServices(SLPDefaults.DA_SERVICE_TYPE, this.iScopes, "");
            while (serviceEnum != null && serviceEnum.hasMoreElements()) {
                url = (ServiceURL)serviceEnum.nextElement();
                agents.add(url.getHost());
            }
            logger.trace(Level.FINER, "SLP DA discovery completed in local subnet. " + agents.size() + " DAs found:" + agents.toString());
            if (agents.size() == 0) {
                serviceEnum = locator.findServices(SLPDefaults.SA_SERVICE_TYPE, this.iScopes, "");
                while (serviceEnum != null && serviceEnum.hasMoreElements()) {
                    url = (ServiceURL)serviceEnum.nextElement();
                    agents.add(url.getHost());
                }
                logger.trace(Level.FINER, "SLP SA discovery completed in local subnet. " + agents.size() + " SAs found:" + agents.toString());
            }
            logger.exit();
            return agents.toArray(new String[agents.size()]);
        }
        catch (ServiceLocationException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "SLP discovery failed with error", e);
        }
        catch (Exception e) {
            LogAndTraceBroker.getBroker().trace(Level.FINE, "Exception during service discovery", e);
        }
        logger.exit();
        return new String[0];
    }
}

