/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.cimclient.internal.http;

import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import javax.wbem.WBEMException;
import org.sblim.cimclient.internal.http.HttpMethod;
import org.sblim.cimclient.internal.http.io.ASCIIPrintStream;
import org.sblim.cimclient.internal.http.io.TrailerException;
import org.sblim.cimclient.internal.logging.LogAndTraceBroker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpHeader {
    private static BitSet cDontNeedEncoding;
    private static final String HEX_STR = "0123456789ABCDEF";
    private static String cDfltEncName;
    private Hashtable<HeaderEntry, String> iFields = new Hashtable();

    public HttpHeader() {
    }

    public HttpHeader(InputStream pReader) throws IOException {
        String line = null;
        while ((line = HttpMethod.readLine(pReader)) != null && line.length() > 0) {
            try {
                int separator = line.indexOf(58);
                if (separator > -1) {
                    int headerStartIndex = 0;
                    if (line.indexOf(45) == 2 && Character.isDigit(line.charAt(0)) && Character.isDigit(line.charAt(1))) {
                        headerStartIndex = 3;
                    }
                    String header = line.substring(headerStartIndex, separator);
                    String value = line.substring(separator + 1);
                    if (value.length() > 0 && value.startsWith(" ")) {
                        this.addField(header, value.substring(1));
                        continue;
                    }
                    this.addField(header, value);
                    continue;
                }
                LogAndTraceBroker.getBroker().message("CIM2005W", line);
            }
            catch (Exception e) {
                LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while parsing http header", e);
                LogAndTraceBroker.getBroker().message("CIM2005W", line);
            }
        }
    }

    public void addField(String pName, String pValue) {
        if (pName == null || pName.length() == 0) {
            return;
        }
        if (pValue != null) {
            this.iFields.put(new HeaderEntry(pName), pValue);
        } else {
            this.iFields.remove(new HeaderEntry(pName));
        }
    }

    public void clear() {
        this.iFields.clear();
    }

    public Iterator<Map.Entry<HeaderEntry, String>> iterator() {
        return this.iFields.entrySet().iterator();
    }

    public static HttpHeader parse(String pLine) {
        int prev = 0;
        int next = 0;
        HttpHeader header = new HttpHeader();
        if (pLine != null && pLine.length() > 0) {
            int separator;
            String hdr;
            next = pLine.indexOf(44);
            while (next > -1) {
                hdr = pLine.substring(prev, next);
                separator = hdr.indexOf(61);
                if (separator > -1) {
                    String key = hdr.substring(0, separator);
                    String value = hdr.substring(separator + 1);
                    header.addField(key, value);
                }
                prev = next + 1;
                while (Character.isSpaceChar(pLine.charAt(prev))) {
                    ++prev;
                }
                next = pLine.indexOf(44, prev);
            }
            hdr = pLine.substring(prev);
            separator = hdr.indexOf(61);
            if (separator > -1) {
                header.addField(hdr.substring(0, separator), hdr.substring(separator + 1));
            }
        }
        return header;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        int i = 0;
        Iterator<Map.Entry<HeaderEntry, String>> iterator = this.iFields.entrySet().iterator();
        while (iterator.hasNext()) {
            if (i++ > 0) {
                buf.append(',');
            }
            Map.Entry<HeaderEntry, String> entry = iterator.next();
            buf.append(entry.getKey().toString());
            buf.append(": ");
            buf.append(entry.getValue().toString());
        }
        return buf.toString();
    }

    public void removeField(String pName) {
        this.iFields.remove(new HeaderEntry(pName));
    }

    public String getField(String pName) {
        return this.iFields.get(new HeaderEntry(pName));
    }

    public void write(ASCIIPrintStream pWriter) {
        for (Map.Entry<HeaderEntry, String> entry : this.iFields.entrySet()) {
            pWriter.print(entry.getKey().toString());
            pWriter.print(": ");
            pWriter.print(entry.getValue().toString());
            pWriter.print("\r\n");
        }
        pWriter.print("\r\n");
    }

    public static synchronized String encode(byte[] pData) {
        String str = null;
        try {
            if (cDfltEncName == null) {
                cDfltEncName = (String)AccessController.doPrivileged(new GetProperty("file.encoding"));
            }
            str = HttpHeader.encode(pData, cDfltEncName);
        }
        catch (UnsupportedEncodingException e) {
            LogAndTraceBroker.getBroker().trace(Level.FINER, "Exception while encoding http header data", e);
        }
        return str;
    }

    public static String encode(byte[] pData, String pEnc) throws UnsupportedEncodingException {
        int maxBytesPerChar = 10;
        ByteArrayOutputStream buf = new ByteArrayOutputStream(maxBytesPerChar);
        new BufferedWriter(new OutputStreamWriter((OutputStream)buf, pEnc));
        StringBuffer out = new StringBuffer(pData.length);
        for (int i = 0; i < pData.length; ++i) {
            int c = pData[i] & 0xFF;
            if (cDontNeedEncoding.get(c)) {
                if (c == 32) {
                    out.append("%20");
                    continue;
                }
                out.append((char)c);
                continue;
            }
            out.append('%');
            out.append(HEX_STR.charAt(c >> 4 & 0xF));
            out.append(HEX_STR.charAt(c & 0xF));
        }
        return out.toString();
    }

    public static String encode(String pData, String pSourceEnc, String pTargetEnc) throws UnsupportedEncodingException {
        return HttpHeader.encode(pData.getBytes(pSourceEnc), pTargetEnc);
    }

    public void examineTrailer() throws TrailerException {
        Iterator<Map.Entry<HeaderEntry, String>> itr = this.iterator();
        int code = 0;
        String desc = null;
        while (itr.hasNext()) {
            Map.Entry<HeaderEntry, String> ent = itr.next();
            String keyStr = ent.getKey().toString();
            try {
                if (keyStr.equalsIgnoreCase("CIMStatusCode")) {
                    String valStr = URLDecoder.decode(this.getField(keyStr), "UTF-8");
                    code = Integer.parseInt(valStr);
                    continue;
                }
                if (!keyStr.equalsIgnoreCase("CIMStatusCodeDescription")) continue;
                desc = URLDecoder.decode(this.getField(keyStr), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        if (code > 0 || desc != null) {
            if (code > 0) {
                throw new TrailerException(new WBEMException(code, desc));
            }
            throw new TrailerException(new WBEMException(desc));
        }
    }

    static {
        int i;
        cDfltEncName = null;
        cDontNeedEncoding = new BitSet(256);
        for (i = 97; i <= 122; ++i) {
            cDontNeedEncoding.set(i);
        }
        for (i = 65; i <= 90; ++i) {
            cDontNeedEncoding.set(i);
        }
        for (i = 48; i <= 57; ++i) {
            cDontNeedEncoding.set(i);
        }
        cDontNeedEncoding.set(32);
        cDontNeedEncoding.set(45);
        cDontNeedEncoding.set(95);
        cDontNeedEncoding.set(47);
        cDontNeedEncoding.set(46);
        cDontNeedEncoding.set(42);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GetProperty
    implements PrivilegedAction<Object> {
        String iPropertyName;

        GetProperty(String propertyName) {
            this.iPropertyName = propertyName;
        }

        @Override
        public Object run() {
            return System.getProperty(this.iPropertyName);
        }
    }

    public static class HeaderEntry {
        String iHeader;
        int iHashcode;

        public HeaderEntry(String pName) {
            this.iHeader = pName;
            this.iHashcode = pName.toUpperCase().hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == null || !(obj instanceof HeaderEntry)) {
                return false;
            }
            return this.iHeader.equalsIgnoreCase(((HeaderEntry)obj).iHeader);
        }

        public String toString() {
            return this.iHeader;
        }

        public int hashCode() {
            return this.iHashcode;
        }
    }
}

