/*
 * Decompiled with CFR 0.152.
 */
package org.sblim.slp.internal.msg;

import org.sblim.slp.ServiceLocationException;
import org.sblim.slp.internal.SLPConfig;
import org.sblim.slp.internal.SLPDefaults;
import org.sblim.slp.internal.msg.FunctionIDs;
import org.sblim.slp.internal.msg.MsgHeader;
import org.sblim.slp.internal.msg.SLPOutputStream;
import org.sblim.slp.internal.msg.SerializeOption;
import org.sblim.slp.internal.msg.Util;

public abstract class SLPMessage
implements FunctionIDs {
    private final int iMaxDatagramSize = SLPConfig.getGlobalCfg().getMTU();
    private MsgHeader iHeader;

    public SLPMessage(int pFunctionID) {
        this(pFunctionID, Util.getLangTag(SLPDefaults.LOCALE));
    }

    public SLPMessage(int pFunctionID, String pLangTag) {
        this(new MsgHeader(2, pFunctionID, pLangTag, false, pFunctionID == 3, false, 0));
    }

    public SLPMessage(MsgHeader pHeader) {
        this.iHeader = pHeader;
    }

    public MsgHeader getHeader() {
        return this.iHeader;
    }

    public int getVersion() {
        return this.iHeader.getVersion();
    }

    public int getFunctionID() {
        return this.iHeader.getFunctionID();
    }

    public String getLangTag() {
        return this.iHeader.getLangTag();
    }

    public boolean overflows() {
        return this.iHeader.overflows();
    }

    public boolean fresh() {
        return this.iHeader.fresh();
    }

    public boolean multicast() {
        return this.iHeader.multicast();
    }

    public int getXID() {
        return this.iHeader.getXID();
    }

    public void setXID(int pXID) {
        this.iHeader.setXID(pXID);
    }

    public byte[] serialize(boolean pSetMulticastFlag, boolean pDatagramLimited, boolean pKeepXID) throws ServiceLocationException {
        return this.serialize(pSetMulticastFlag, pDatagramLimited, pKeepXID, null);
    }

    public byte[] serialize(boolean pSetMulticastFlag, boolean pDatagramLimited, boolean pKeepXID, SerializeOption pOption) throws ServiceLocationException {
        SLPOutputStream bodyOutStr = new SLPOutputStream(pDatagramLimited ? this.iMaxDatagramSize - this.iHeader.getSize() : -1);
        boolean fit = this.serializeBody(bodyOutStr, pOption);
        byte[] bodyBytes = bodyOutStr.toByteArray();
        byte[] headerBytes = this.iHeader.serialize(bodyBytes.length, !fit, pSetMulticastFlag, pKeepXID);
        byte[] bytes = new byte[headerBytes.length + bodyBytes.length];
        System.arraycopy(headerBytes, 0, bytes, 0, headerBytes.length);
        System.arraycopy(bodyBytes, 0, bytes, headerBytes.length, bodyBytes.length);
        return bytes;
    }

    protected abstract boolean serializeBody(SLPOutputStream var1, SerializeOption var2) throws ServiceLocationException;

    public String toString() {
        return super.toString() + " " + this.getXID();
    }
}

