/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.connection.helpers;

import com.vmware.pbm.InvalidArgumentFaultMsg;
import com.vmware.pbm.PbmCapabilityMetadata;
import com.vmware.pbm.PbmCapabilityMetadataPerCategory;
import com.vmware.pbm.PbmCapabilityProfile;
import com.vmware.pbm.PbmProfile;
import com.vmware.pbm.PbmProfileResourceType;
import com.vmware.pbm.PbmProfileResourceTypeEnum;
import com.vmware.pbm.PbmServiceInstanceContent;
import com.vmware.pbm.RuntimeFaultFaultMsg;
import com.vmware.spbm.connection.Connection;
import com.vmware.vim25.ManagedObjectReference;
import java.util.List;

public class PbmUtil {
    public static PbmCapabilityMetadata getCapabilityMeta(String string, List<PbmCapabilityMetadataPerCategory> list) {
        for (PbmCapabilityMetadataPerCategory pbmCapabilityMetadataPerCategory : list) {
            for (PbmCapabilityMetadata pbmCapabilityMetadata : pbmCapabilityMetadataPerCategory.getCapabilityMetadata()) {
                if (!pbmCapabilityMetadata.getId().getId().equals(string)) continue;
                return pbmCapabilityMetadata;
            }
        }
        return null;
    }

    public static PbmCapabilityProfile getPbmProfile(Connection connection, String string) throws InvalidArgumentFaultMsg, RuntimeFaultFaultMsg, RuntimeFaultFaultMsg {
        PbmServiceInstanceContent pbmServiceInstanceContent = connection.getPbmServiceContent();
        ManagedObjectReference managedObjectReference = pbmServiceInstanceContent.getProfileManager();
        List list = connection.getPbmPort().pbmQueryProfile(managedObjectReference, PbmUtil.getStorageResourceType(), null);
        if (list == null || list.isEmpty()) {
            throw new RuntimeFaultFaultMsg("No storage Profiles exist.", null);
        }
        List list2 = connection.getPbmPort().pbmRetrieveContent(managedObjectReference, list);
        for (PbmProfile pbmProfile : list2) {
            if (!pbmProfile.getName().equals(string)) continue;
            PbmCapabilityProfile pbmCapabilityProfile = (PbmCapabilityProfile)pbmProfile;
            return pbmCapabilityProfile;
        }
        throw new RuntimeFaultFaultMsg("Profile with the given name does not exist", null);
    }

    public static PbmProfileResourceType getStorageResourceType() {
        PbmProfileResourceType pbmProfileResourceType = new PbmProfileResourceType();
        pbmProfileResourceType.setResourceType(PbmProfileResourceTypeEnum.STORAGE.value());
        return pbmProfileResourceType;
    }

    public static PbmCapabilityMetadata getTagCategoryMeta(String string, List<PbmCapabilityMetadataPerCategory> list) {
        for (PbmCapabilityMetadataPerCategory pbmCapabilityMetadataPerCategory : list) {
            if (!pbmCapabilityMetadataPerCategory.getSubCategory().equals("tag")) continue;
            for (PbmCapabilityMetadata pbmCapabilityMetadata : pbmCapabilityMetadataPerCategory.getCapabilityMetadata()) {
                if (!pbmCapabilityMetadata.getId().getId().equals(string)) continue;
                return pbmCapabilityMetadata;
            }
        }
        return null;
    }
}

