/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.spbm.samples;

import com.vmware.common.annotations.Action;
import com.vmware.common.annotations.Sample;
import com.vmware.pbm.PbmCapabilityVendorNamespaceInfo;
import com.vmware.pbm.PbmCapabilityVendorResourceTypeInfo;
import com.vmware.spbm.connection.ConnectedServiceBase;
import com.vmware.vim25.RuntimeFaultFaultMsg;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.xml.datatype.XMLGregorianCalendar;

@Sample(name="aboutinfo", description="Displays the basic information about the spbm end-point")
public class AboutInfo
extends ConnectedServiceBase {
    void executeVimAPI() throws RuntimeFaultFaultMsg {
        XMLGregorianCalendar xMLGregorianCalendar = this.connection.getVimPort().currentTime(this.connection.getVimServiceInstanceReference());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd 'T' HH:mm:ss.SSSZ");
        System.out.println("Information retrieved at: " + simpleDateFormat.format(xMLGregorianCalendar.toGregorianCalendar().getTime()));
    }

    @Action
    public void printInfo() throws RuntimeFaultFaultMsg, com.vmware.pbm.RuntimeFaultFaultMsg {
        this.executeVimAPI();
        this.printSpbmAPIInfo();
        this.printVendorInfo();
    }

    void printSpbmAPIInfo() {
        System.out.println("SPBM Endpoint Information");
        System.out.println(this.connection.getPbmServiceContent().getAboutInfo().getName() + " - " + this.connection.getPbmServiceContent().getAboutInfo().getVersion());
    }

    void printVendorInfo() throws com.vmware.pbm.RuntimeFaultFaultMsg {
        List list = this.connection.getPbmPort().pbmFetchVendorInfo(this.connection.getPbmServiceContent().getProfileManager(), null);
        System.out.println("The No. of supported vendors are " + list.size());
        for (PbmCapabilityVendorResourceTypeInfo pbmCapabilityVendorResourceTypeInfo : list) {
            System.out.println("======");
            System.out.println("Resource Type:" + pbmCapabilityVendorResourceTypeInfo.getResourceType());
            List list2 = pbmCapabilityVendorResourceTypeInfo.getVendorNamespaceInfo();
            for (PbmCapabilityVendorNamespaceInfo pbmCapabilityVendorNamespaceInfo : list2) {
                System.out.println("vendor UUID: " + pbmCapabilityVendorNamespaceInfo.getVendorInfo().getVendorUuid());
                System.out.println("vendor.info.key: " + pbmCapabilityVendorNamespaceInfo.getVendorInfo().getInfo().getKey());
            }
        }
    }
}

