# Fix HttpNfcLeaseInfo type in vim-types.xsd, adding missing leaseState property

param(

	[string] $FileName

)

[xml]$vimTypes = Get-Content $FileName

$leaseInfo = $vimTypes.schema.complexType | ? {$_.name -eq 'HttpNfcLeaseInfo'}

$leaseState = $leaseInfo.complexContent.extension.sequence.element[0].clone()

$leaseState.name="leaseState"

$leaseState.type="vim25:HttpNfcLeaseState"

$leaseState.SetAttribute("minOccurs", 0)

$leaseInfo.complexContent.extension.sequence.AppendChild($leaseState) | Out-Null

$vimTypes.Save($fileName)